/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.documentation;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.documentation.DocBuilder;

public abstract class DocDelegate {
    protected DocBuilder builder;

    public DocDelegate(DocBuilder action) {
        this.builder = action;
    }

    protected String calculateTargetDocumentationFile(FileObject targetFolder, FileObject sourceFile) {
        String base = FilenameUtils.removeExtension((String)sourceFile.getName().getBaseName());
        if (this.builder.isPipeline(sourceFile)) {
            return targetFolder.getName().getPath() + "/" + base + "-pipeline.md";
        }
        if (this.builder.isWorkflow(sourceFile)) {
            return targetFolder.getName().getPath() + "/" + base + "-workflow.md";
        }
        return targetFolder.getName().getPath() + "/" + base + "-" + sourceFile.getName().getExtension() + ".md";
    }

    protected String calculateTargetImageFile(String name, String type) {
        return name + "-" + type + String.valueOf(UUID.randomUUID()) + ".svg";
    }

    protected String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    protected void addDetails(AbstractMeta meta, StringBuilder content, String relativeFile) throws UnknownParamException {
        if (StringUtils.isNotEmpty((String)meta.getDescription())) {
            content.append("* Description : ").append(meta.getDescription()).append(Const.CR);
        }
        if (StringUtils.isNotEmpty((String)meta.getExtendedDescription())) {
            content.append("* Extended Description : ").append(meta.getExtendedDescription()).append(Const.CR);
        }
        content.append("* Filename : ").append(relativeFile).append(Const.CR).append("* Last modified: ").append(this.formatDate(meta.getModifiedDate())).append(Const.CR);
        if (this.builder.isIncludingParameters() && meta.listParameters().length > 0) {
            content.append("- Parameters : ").append(Const.CR);
            for (String parameterName : meta.listParameters()) {
                content.append("    - ").append(parameterName).append(" : ").append(meta.getParameterDescription(parameterName)).append(", default is [").append(meta.getParameterDefault(parameterName)).append("]").append(Const.CR);
            }
        }
        content.append(Const.CR);
    }
}

