/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import com.beust.jcommander.Parameter;
import java.util.List;
import org.gridkit.lab.jvm.attach.AttachManager;
import org.gridkit.lab.jvm.attach.JavaProcessId;

public class JvmProcessPrinter {
    @Parameter(names={"-pd", "--process-details"}, variableArity=true, description="Print custom information related to a process. Following tags can be used: PID, MAIN, FDQN_MAIN, ARGS, D<sys-prop>, d<sys-prop>, X<jvm-flag>")
    private List<String> displayFields;

    public boolean isDefined() {
        return this.displayFields != null && !this.displayFields.isEmpty();
    }

    public String describe(JavaProcessId jpid) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String tag : this.displayFields) {
            if (!first) {
                sb.append('\t');
            }
            first = false;
            if ("PID".equals(tag)) {
                sb.append(this.getPid(jpid));
                continue;
            }
            if ("MAIN".equals(tag)) {
                sb.append(this.getShortMain(jpid));
                continue;
            }
            if ("FDQN_MAIN".equals(tag)) {
                sb.append(this.getMain(jpid));
                continue;
            }
            if ("ARGS".equals(tag)) {
                sb.append(this.getArgs(jpid));
                continue;
            }
            if (tag.startsWith("d")) {
                sb.append(this.getProp(jpid, tag.substring(1)));
                continue;
            }
            if (tag.startsWith("D")) {
                sb.append(tag.substring(1)).append("=");
                sb.append(this.getProp(jpid, tag.substring(1)));
                continue;
            }
            if (tag.startsWith("X")) {
                sb.append(this.getFlag(jpid, tag.substring(1)));
                continue;
            }
            sb.append("Unknown(" + tag + ")");
        }
        return sb.toString();
    }

    private String getProp(JavaProcessId jpid, String propName) {
        return (String)AttachManager.getDetails((JavaProcessId)jpid).getSystemProperties().get(propName);
    }

    private String getFlag(JavaProcessId jpid, String flagName) {
        return AttachManager.getDetails((JavaProcessId)jpid).getVmFlag(flagName);
    }

    private String getArgs(JavaProcessId jpid) {
        String desc = jpid.getDescription();
        int n = desc.indexOf(32);
        if (n >= 0) {
            desc = desc.substring(n + 1);
        }
        return desc;
    }

    private String getMain(JavaProcessId jpid) {
        String desc = jpid.getDescription();
        int n = desc.indexOf(32);
        if (n >= 0) {
            desc = desc.substring(0, n);
        }
        return desc;
    }

    private String getShortMain(JavaProcessId jpid) {
        String main = this.getMain(jpid);
        if (main.endsWith(".jar")) {
            return main;
        }
        int n = main.lastIndexOf(46);
        if (n >= 0) {
            main = main.substring(n + 1);
        }
        return main;
    }

    private String getPid(JavaProcessId jpid) {
        return String.valueOf(jpid.getPID());
    }
}

