/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;

public final class HiveSortLimitRemoveRule
extends RelOptRule {
    public static final HiveSortLimitRemoveRule INSTANCE = new HiveSortLimitRemoveRule();

    private HiveSortLimitRemoveRule() {
        super(HiveSortLimitRemoveRule.operand(HiveSortLimit.class, (RelOptRuleOperandChildren)HiveSortLimitRemoveRule.any()), HiveRelFactories.HIVE_BUILDER, null);
    }

    public boolean matches(RelOptRuleCall call) {
        HiveSortLimit sortLimit = (HiveSortLimit)call.rel(0);
        Double maxRowCount = call.getMetadataQuery().getMaxRowCount(sortLimit.getInput());
        if (maxRowCount != null) {
            if (HiveCalciteUtil.pureLimitRelNode(sortLimit)) {
                return maxRowCount <= (double)RexLiteral.intValue((RexNode)sortLimit.getFetchExpr());
            }
            if (HiveCalciteUtil.pureOrderRelNode(sortLimit)) {
                return maxRowCount <= 1.0;
            }
            return maxRowCount <= 1.0 && (double)RexLiteral.intValue((RexNode)sortLimit.getFetchExpr()) >= maxRowCount;
        }
        return false;
    }

    public void onMatch(RelOptRuleCall call) {
        HiveSortLimit sortLimit = (HiveSortLimit)call.rel(0);
        call.transformTo(sortLimit.getInput());
    }
}

