/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.alter.location;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.catalog.alter.AbstractAlterCatalogOperation;
import org.apache.hadoop.hive.ql.ddl.catalog.alter.location.AlterCatalogSetLocationDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class AlterCatalogSetLocationOperation
extends AbstractAlterCatalogOperation<AlterCatalogSetLocationDesc> {
    public AlterCatalogSetLocationOperation(DDLOperationContext context, AlterCatalogSetLocationDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Catalog catalog) throws HiveException {
        try {
            String newLocation = Utilities.getQualifiedPath(this.context.getConf(), new Path(((AlterCatalogSetLocationDesc)this.desc).getLocation()));
            URI locationURI = new URI(newLocation);
            if (!locationURI.isAbsolute()) {
                throw new HiveException(ErrorMsg.BAD_LOCATION_VALUE, new String[]{newLocation});
            }
            if (newLocation.equals(catalog.getLocationUri())) {
                LOG.info("AlterCatalog skipped. No change in location.");
            } else {
                catalog.setLocationUri(newLocation);
                LOG.info("Catalog location changed from {} to {}", (Object)catalog.getLocationUri(), (Object)newLocation);
            }
        }
        catch (URISyntaxException e) {
            throw new HiveException((Throwable)e);
        }
    }
}

