/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.List;
import org.apache.helix.HelixManager;
import org.apache.helix.api.status.ClusterManagementMode;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.ManagementControllerDataProvider;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.MessageDispatchStage;
import org.apache.helix.controller.stages.MessageOutput;
import org.apache.helix.model.Message;
import org.apache.helix.util.RebalanceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementMessageDispatchStage
extends MessageDispatchStage {
    private static final Logger LOG = LoggerFactory.getLogger(ManagementMessageDispatchStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        MessageOutput messageOutput = (MessageOutput)event.getAttribute(AttributeName.MESSAGES_ALL.name());
        this.processEvent(event, messageOutput);
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        List<Message> messagesSent = super.sendMessages(manager.getHelixDataAccessor(), messageOutput.getStatusChangeMessages());
        ManagementControllerDataProvider cache = (ManagementControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        cache.cacheMessages(messagesSent);
        ClusterManagementMode managementMode = (ClusterManagementMode)event.getAttribute(AttributeName.CLUSTER_STATUS.name());
        if (managementMode.isFullyInNormalMode()) {
            LogUtil.logInfo(LOG, this._eventId, "Exiting management mode pipeline for cluster " + event.getClusterName());
            RebalanceUtil.enableManagementMode(event.getClusterName(), false);
        }
    }
}

