/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.engine.Edition;
import org.restlet.engine.io.IoUtils;
import org.restlet.representation.StreamRepresentation;

public class InputRepresentation
extends StreamRepresentation {
    private volatile InputStream stream;

    public InputRepresentation(InputStream inputStream) {
        this(inputStream, null);
    }

    public InputRepresentation(InputStream inputStream, MediaType mediaType) {
        this(inputStream, mediaType, -1L);
    }

    public InputRepresentation(InputStream inputStream, MediaType mediaType, long expectedSize) {
        super(mediaType);
        this.setSize(expectedSize);
        this.setTransient(true);
        this.setStream(inputStream);
    }

    @Override
    public InputStream getStream() throws IOException {
        if (Edition.CURRENT != Edition.GWT) {
            InputStream result = this.stream;
            this.setStream(null);
            return result;
        }
        return this.stream;
    }

    @Override
    public String getText() throws IOException {
        return IoUtils.toString(this.getStream(), this.getCharacterSet());
    }

    @Override
    public void release() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Error while releasing the representation.", e);
            }
            this.stream = null;
        }
        super.release();
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
        this.setAvailable(stream != null);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        IoUtils.copy(this.getStream(), outputStream);
    }
}

