/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.StateTransitionContext;
import org.apache.helix.monitoring.StateTransitionDataPoint;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.HistogramDynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateTransitionStatMonitor
extends DynamicMBeanProvider {
    private static final Logger _logger = LoggerFactory.getLogger(StateTransitionStatMonitor.class);
    private List<DynamicMetric<?, ?>> _attributeList;
    private final ObjectName _initObjectName;
    private SimpleDynamicMetric<Long> _totalStateTransitionCounter;
    private SimpleDynamicMetric<Long> _totalFailedTransitionCounter;
    private SimpleDynamicMetric<Long> _totalSuccessTransitionCounter;
    private HistogramDynamicMetric _transitionLatencyGauge;
    private HistogramDynamicMetric _transitionExecutionLatencyGauge;
    private HistogramDynamicMetric _transitionMessageLatency;
    StateTransitionContext _context;

    public StateTransitionStatMonitor(StateTransitionContext context, ObjectName objectName) {
        this._context = context;
        this._initObjectName = objectName;
        this._attributeList = new ArrayList();
        this._totalStateTransitionCounter = new SimpleDynamicMetric<Long>("TotalStateTransitionCounter", 0L);
        this._totalFailedTransitionCounter = new SimpleDynamicMetric<Long>("TotalFailedTransitionCounter", 0L);
        this._totalSuccessTransitionCounter = new SimpleDynamicMetric<Long>("TotalSuccessTransitionCounter", 0L);
        this._transitionLatencyGauge = new HistogramDynamicMetric("TransitionLatencyGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._transitionExecutionLatencyGauge = new HistogramDynamicMetric("TransitionExecutionLatencyGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._transitionMessageLatency = new HistogramDynamicMetric("TransitionMessageLatencyGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
    }

    @Override
    public DynamicMBeanProvider register() throws JMException {
        this._attributeList.add(this._totalStateTransitionCounter);
        this._attributeList.add(this._totalFailedTransitionCounter);
        this._attributeList.add(this._totalSuccessTransitionCounter);
        this._attributeList.add(this._transitionLatencyGauge);
        this._attributeList.add(this._transitionExecutionLatencyGauge);
        this._attributeList.add(this._transitionMessageLatency);
        this.doRegister(this._attributeList, this._initObjectName);
        return this;
    }

    public StateTransitionContext getContext() {
        return this._context;
    }

    @Override
    public String getSensorName() {
        return String.format("StateTransitionStat.%s.%s.%s", this._context.getClusterName(), this._context.getResourceName(), this._context.getTransition());
    }

    public void addDataPoint(StateTransitionDataPoint data) {
        this.incrementSimpleDynamicMetric(this._totalStateTransitionCounter);
        if (data.getSuccess()) {
            this.incrementSimpleDynamicMetric(this._totalSuccessTransitionCounter);
        } else {
            this.incrementSimpleDynamicMetric(this._totalFailedTransitionCounter);
        }
        this._transitionLatencyGauge.updateValue(data.getTotalDelay());
        this._transitionExecutionLatencyGauge.updateValue(data.getExecutionDelay());
        this._transitionMessageLatency.updateValue(data.getMessageLatency());
    }
}

