/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixException;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.TrieNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTrie {
    public static final String DELIMITER = "/";
    public static final String CONNECTOR = ":";
    private static Logger logger = LoggerFactory.getLogger(ClusterTrie.class);
    private TrieNode _rootNode;
    private String[] _topologyKeys;
    private String _faultZoneType;
    private List<String> _invalidInstances = new ArrayList<String>();

    public ClusterTrie(List<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, ClusterConfig clusterConfig) {
        this.validateInstanceConfig(liveNodes, instanceConfigMap);
        this._topologyKeys = this.getTopologyDef(clusterConfig);
        this._faultZoneType = clusterConfig.getFaultZoneType();
        this._invalidInstances = this.getInvalidInstancesFromConfig(instanceConfigMap, this._topologyKeys);
        instanceConfigMap.keySet().removeAll(this._invalidInstances);
        this._rootNode = this.constructTrie(instanceConfigMap, this._topologyKeys);
    }

    public TrieNode getRootNode() {
        return this._rootNode;
    }

    public String[] getTopologyKeys() {
        return this._topologyKeys;
    }

    public String getFaultZoneType() {
        return this._faultZoneType;
    }

    public List<String> getInvalidInstances() {
        return this._invalidInstances;
    }

    public Set<String> getPathUnderNode(TrieNode node) {
        HashSet<String> resultMap = new HashSet<String>();
        ArrayDeque<TrieNode> nodeStack = new ArrayDeque<TrieNode>();
        nodeStack.push(node);
        while (!nodeStack.isEmpty()) {
            node = (TrieNode)nodeStack.pop();
            if (node.getChildren().isEmpty()) {
                resultMap.add(node.getPath());
                continue;
            }
            for (TrieNode child : node.getChildren().values()) {
                nodeStack.push(child);
            }
        }
        return resultMap;
    }

    public TrieNode getNode(LinkedHashMap<String, String> domainMap) {
        TrieNode curNode = this._rootNode;
        for (Map.Entry<String, String> entry : domainMap.entrySet()) {
            TrieNode nextNode = curNode.getChildren().get(entry.getKey() + CONNECTOR + entry.getValue());
            if (nextNode == null) {
                throw new IllegalArgumentException(String.format("The input domain %s does not have the value %s", entry.getKey(), entry.getValue()));
            }
            curNode = nextNode;
        }
        return curNode;
    }

    public List<TrieNode> getStartNodes(String domainType) {
        ArrayList<TrieNode> results = new ArrayList<TrieNode>();
        TrieNode curNode = this._rootNode;
        ArrayDeque<TrieNode> nodeStack = new ArrayDeque<TrieNode>();
        nodeStack.push(curNode);
        while (!nodeStack.isEmpty()) {
            curNode = (TrieNode)nodeStack.pop();
            if (curNode.getNodeKey().equals(domainType)) {
                results.add(curNode);
                continue;
            }
            for (TrieNode child : curNode.getChildren().values()) {
                nodeStack.push(child);
            }
        }
        return results;
    }

    private void validateInstanceConfig(List<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap) {
        if (instanceConfigMap == null || !instanceConfigMap.keySet().containsAll(liveNodes)) {
            ArrayList<String> liveNodesCopy = new ArrayList<String>();
            liveNodesCopy.addAll(liveNodes);
            throw new HelixException(String.format("Config for instances %s is not found!", instanceConfigMap == null ? liveNodes : Boolean.valueOf(liveNodesCopy.removeAll(instanceConfigMap.keySet()))));
        }
    }

    private List<String> getInvalidInstancesFromConfig(Map<String, InstanceConfig> instanceConfigMap, String[] topologyKeys) {
        ArrayList<String> invalidInstances = new ArrayList<String>();
        block2: for (String instanceName : instanceConfigMap.keySet()) {
            try {
                Map<String, String> domainAsMap = instanceConfigMap.get(instanceName).getDomainAsMap();
                for (String key : topologyKeys) {
                    String value = domainAsMap.get(key);
                    if (value != null && value.length() != 0) continue;
                    logger.info(String.format("Domain %s for instance %s is not set", domainAsMap.get(key), instanceName));
                    invalidInstances.add(instanceName);
                    continue block2;
                }
            }
            catch (IllegalArgumentException e) {
                invalidInstances.add(instanceName);
            }
        }
        return invalidInstances;
    }

    private String[] getTopologyDef(ClusterConfig clusterConfig) {
        String topologyDefInConfig = clusterConfig.getTopology();
        if (topologyDefInConfig == null || !topologyDefInConfig.trim().startsWith(DELIMITER)) {
            throw new HelixException(String.format("The topology of cluster %s is invalid!", clusterConfig.getClusterName()));
        }
        String[] topologyDef = Arrays.asList(topologyDefInConfig.split(DELIMITER)).stream().map(str -> str.trim()).filter(str -> !str.isEmpty()).collect(Collectors.toList()).toArray(new String[0]);
        if (topologyDef.length == 0) {
            throw new HelixException(String.format("The topology of cluster %s is not correctly defined", clusterConfig.getClusterName()));
        }
        return topologyDef;
    }

    private TrieNode constructTrie(Map<String, InstanceConfig> instanceConfigMap, String[] topologyKeys) {
        TrieNode rootNode = new TrieNode("", "ROOT");
        HashMap instanceDomainsMap = new HashMap();
        instanceConfigMap.entrySet().forEach(entry -> instanceDomainsMap.put((String)entry.getKey(), ((InstanceConfig)entry.getValue()).getDomainAsMap()));
        for (Map.Entry entry2 : instanceDomainsMap.entrySet()) {
            TrieNode curNode = rootNode;
            StringBuilder path = new StringBuilder();
            for (int i = 0; i < topologyKeys.length; ++i) {
                String key = topologyKeys[i] + CONNECTOR + (String)((Map)entry2.getValue()).get(topologyKeys[i]);
                path.append(DELIMITER).append(key);
                TrieNode nextNode = curNode.getChildren().get(key);
                if (nextNode == null) {
                    nextNode = new TrieNode(path.toString(), topologyKeys[i]);
                }
                curNode.addChild(key, nextNode);
                curNode = nextNode;
            }
        }
        return rootNode;
    }
}

