/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.WrapperList;

public class Variant {
    private volatile CharacterSet characterSet = null;
    private volatile List<Encoding> encodings = null;
    private volatile Reference locationRef;
    private volatile List<Language> languages;
    private volatile MediaType mediaType;

    public Variant() {
        this(null);
    }

    public Variant(MediaType mediaType) {
        this(mediaType, null);
    }

    public Variant(MediaType mediaType, Language language) {
        if (language != null) {
            this.getLanguages().add(language);
        } else {
            this.languages = null;
        }
        this.mediaType = mediaType;
        this.locationRef = null;
    }

    public ClientInfo createClientInfo() {
        ClientInfo result = new ClientInfo();
        if (this.getCharacterSet() != null) {
            result.getAcceptedCharacterSets().add(new Preference<CharacterSet>(this.getCharacterSet()));
        }
        if (this.getEncodings() != null) {
            for (Encoding encoding : this.getEncodings()) {
                result.getAcceptedEncodings().add(new Preference<Encoding>(encoding));
            }
        }
        if (this.getLanguages() != null) {
            for (Language language : this.getLanguages()) {
                result.getAcceptedLanguages().add(new Preference<Language>(language));
            }
        }
        if (this.getMediaType() != null) {
            result.getAcceptedMediaTypes().add(new Preference<MediaType>(this.getMediaType()));
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Variant)) {
            return false;
        }
        Variant that = (Variant)other;
        return Objects.equals(this.getCharacterSet(), that.getCharacterSet()) && Objects.equals(this.getMediaType(), that.getMediaType()) && this.getLanguages().equals(that.getLanguages()) && this.getEncodings().equals(that.getEncodings()) && Objects.equals(this.getLocationRef(), that.getLocationRef());
    }

    public CharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public List<Encoding> getEncodings() {
        if (this.encodings == null) {
            this.encodings = new WrapperList<Encoding>(){

                @Override
                public boolean add(Encoding element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.add(element);
                }

                @Override
                public void add(int index, Encoding element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    super.add(index, element);
                }

                @Override
                public boolean addAll(Collection<? extends Encoding> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Encoding> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.addAll(elements);
                }

                @Override
                public boolean addAll(int index, Collection<? extends Encoding> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Encoding> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.addAll(index, elements);
                }
            };
        }
        return this.encodings;
    }

    public List<Language> getLanguages() {
        if (this.languages == null) {
            this.languages = new WrapperList<Language>(){

                @Override
                public void add(int index, Language element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    super.add(index, element);
                }

                @Override
                public boolean add(Language element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    return super.add(element);
                }

                @Override
                public boolean addAll(Collection<? extends Language> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Language> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    return super.addAll(elements);
                }

                @Override
                public boolean addAll(int index, Collection<? extends Language> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Language> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    return super.addAll(index, elements);
                }
            };
        }
        return this.languages;
    }

    public Reference getLocationRef() {
        return this.locationRef;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public int hashCode() {
        return SystemUtils.hashCode(super.hashCode(), this.characterSet, this.encodings, this.locationRef, this.languages, this.mediaType);
    }

    public boolean includes(Variant other) {
        boolean result;
        boolean bl = result = other != null;
        if (result) {
            boolean bl2 = result = this.getCharacterSet() == null || this.getCharacterSet().includes(other.getCharacterSet());
        }
        if (result) {
            boolean bl3 = result = this.getMediaType() == null || this.getMediaType().includes(other.getMediaType());
        }
        if (result) {
            boolean bl4 = result = this.getLanguages().isEmpty() || this.getLanguages().contains(Language.ALL) || this.getLanguages().containsAll(other.getLanguages());
        }
        if (result) {
            result = this.getEncodings().isEmpty() || this.getEncodings().contains(Encoding.ALL) || this.getEncodings().containsAll(other.getEncodings());
        }
        return result;
    }

    public boolean isCompatible(Variant other) {
        return other != null && (this.includes(other) || other.includes(this));
    }

    public void setCharacterSet(CharacterSet characterSet) {
        this.characterSet = characterSet;
    }

    public void setEncodings(List<Encoding> encodings) {
        this.encodings = encodings;
    }

    public void setLanguages(List<Language> languages) {
        this.languages = languages;
    }

    public void setLocationRef(Reference location) {
        this.locationRef = location;
    }

    public void setLocationRef(String locationUri) {
        this.setLocationRef(new Reference(locationUri));
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        if (this.getMediaType() != null) {
            first = false;
            sb.append(this.getMediaType());
        }
        if (this.getCharacterSet() != null) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(this.getCharacterSet());
        }
        if (!this.getLanguages().isEmpty()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(this.getLanguages());
        }
        if (!this.getEncodings().isEmpty()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(this.getEncodings());
        }
        sb.append("]");
        return sb.toString();
    }
}

