/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.restlet.Context;

public class RestletSslContextFactory
extends SslContextFactory {
    public RestletSslContextFactory(org.restlet.engine.ssl.SslContextFactory restletSslContextFactory) throws Exception {
        this.setSslContext(restletSslContextFactory.createSslContext());
    }

    public void checkKeyStore() {
        try {
            if (this.getSslContext() == null) {
                super.checkKeyStore();
            }
        }
        catch (IllegalStateException e) {
            Context.getCurrentLogger().log(Level.FINE, "Unable to check Jetty SSL keystore", e);
        }
    }

    public SSLEngine newSSLEngine() {
        return this.getSslContext().createSSLEngine();
    }

    public SSLEngine newSSLEngine(String host, int port) {
        return this.getSslContext().createSSLEngine(host, port);
    }

    public SSLServerSocket newSslServerSocket(String host, int port, int backlog) throws IOException {
        SSLServerSocketFactory factory = this.getSslContext().getServerSocketFactory();
        return (SSLServerSocket)(host == null ? factory.createServerSocket(port, backlog) : factory.createServerSocket(port, backlog, InetAddress.getByName(host)));
    }

    public SSLSocket newSslSocket() throws IOException {
        return (SSLSocket)this.getSslContext().getSocketFactory().createSocket();
    }
}

