/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FastDateFormat
extends DateFormat {
    private static final long serialVersionUID = -1L;
    final DateFormat df;
    long lastSec = -1L;
    final StringBuffer sb = new StringBuffer();
    final transient FieldPosition fp = new FieldPosition(8);

    public FastDateFormat(DateFormat df) {
        this.df = df;
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        return this.df.parse(text, pos);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        long dt = date.getTime();
        long ds = dt / 1000L;
        if (ds != this.lastSec) {
            this.sb.setLength(0);
            this.df.format(date, this.sb, this.fp);
            this.lastSec = ds;
        } else {
            int ms = (int)(dt % 1000L);
            int pos = this.fp.getEndIndex();
            int begin = this.fp.getBeginIndex();
            if (pos > 0) {
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
                ms /= 10;
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
                ms /= 10;
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
            }
        }
        toAppendTo.append(this.sb.toString());
        return toAppendTo;
    }

    public StringBuilder format(Date date, StringBuilder toAppendTo, FieldPosition fieldPosition) {
        long dt = date.getTime();
        long ds = dt / 1000L;
        if (ds != this.lastSec) {
            this.sb.setLength(0);
            this.df.format(date, this.sb, this.fp);
            this.lastSec = ds;
        } else {
            int ms = (int)(dt % 1000L);
            int pos = this.fp.getEndIndex();
            int begin = this.fp.getBeginIndex();
            if (pos > 0) {
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
                ms /= 10;
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
                ms /= 10;
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
            }
        }
        toAppendTo.append(this.sb.toString());
        return toAppendTo;
    }

    public static void main(String[] args) {
        String format = "yyyy-MM-dd HH:mm:ss.SSS";
        if (args.length > 0) {
            format = args[0];
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        FastDateFormat fdf = new FastDateFormat(sdf);
        Date d = new Date();
        d.setTime(1L);
        System.out.println(fdf.format(d) + '\t' + sdf.format(d));
        d.setTime(20L);
        System.out.println(fdf.format(d) + '\t' + sdf.format(d));
        d.setTime(500L);
        System.out.println(fdf.format(d) + '\t' + sdf.format(d));
        d.setTime(543L);
        System.out.println(fdf.format(d) + '\t' + sdf.format(d));
        d.setTime(999L);
        System.out.println(fdf.format(d) + '\t' + sdf.format(d));
        d.setTime(1050L);
        System.out.println(fdf.format(d) + '\t' + sdf.format(d));
        d.setTime(2543L);
        System.out.println(fdf.format(d) + '\t' + sdf.format(d));
        d.setTime(12345L);
        System.out.println(fdf.format(d) + '\t' + sdf.format(d));
        d.setTime(12340L);
        System.out.println(fdf.format(d) + '\t' + sdf.format(d));
        int reps = 100000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            d.setTime(System.currentTimeMillis());
            fdf.format(d);
        }
        long elap = System.currentTimeMillis() - start;
        System.out.println("fast: " + elap + " elapsed");
        System.out.println(fdf.format(d));
        start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            d.setTime(System.currentTimeMillis());
            sdf.format(d);
        }
        elap = System.currentTimeMillis() - start;
        System.out.println("slow: " + elap + " elapsed");
        System.out.println(sdf.format(d));
    }
}

