/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.restlet.Server;
import org.restlet.ext.jetty.HttpServerHelper;
import org.restlet.ext.jetty.HttpsServerHelper;
import org.restlet.ext.jetty.JettyServerHelper;
import org.restlet.ext.jetty.internal.JettyCall;

public class JettyHandler
extends AbstractHandler {
    private final JettyServerHelper helper;

    public JettyHandler(Server server) {
        this(server, false);
    }

    public JettyHandler(Server server, boolean secure) {
        this.helper = secure ? new HttpsServerHelper(server) : new HttpServerHelper(server);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.helper.start();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.helper.stop();
    }

    public void handle(String target, Request arg1, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        Request baseRequest = servletRequest instanceof Request ? (Request)servletRequest : AbstractHttpConnection.getCurrentConnection().getRequest();
        this.helper.handle(new JettyCall((Server)this.helper.getHelped(), AbstractHttpConnection.getCurrentConnection()));
        baseRequest.setHandled(true);
    }
}

