/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.hdfs.protocolPB.RouterPolicyProvider;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.federation.router.RouterAdminServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestRouterPolicyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterPolicyProvider.class);
    private static Set<Class<?>> policyProviderProtocols;
    @Rule
    public TestName testName = new TestName();
    private final Class<?> rpcServerClass;

    @BeforeClass
    public static void initialize() {
        Service[] services = new RouterPolicyProvider().getServices();
        policyProviderProtocols = new HashSet(services.length);
        for (Service service : services) {
            policyProviderProtocols.add(service.getProtocol());
        }
    }

    public TestRouterPolicyProvider(Class<?> rpcServerClass) {
        this.rpcServerClass = rpcServerClass;
    }

    @Parameterized.Parameters(name="protocolsForServer-{0}")
    public static List<Class<?>[]> data() {
        return Arrays.asList({RouterRpcServer.class}, {NameNodeRpcServer.class}, {DataNode.class}, {RouterAdminServer.class});
    }

    @Test
    public void testPolicyProviderForServer() {
        List ifaces = ClassUtils.getAllInterfaces(this.rpcServerClass);
        HashSet<Class> serverProtocols = new HashSet<Class>(ifaces.size());
        for (Object obj : ifaces) {
            Class iface = (Class)obj;
            if (!iface.getSimpleName().endsWith("Protocol")) continue;
            serverProtocols.add(iface);
        }
        LOG.info("Running test {} for RPC server {}.  Found server protocols {} and policy provider protocols {}.", new Object[]{this.testName.getMethodName(), this.rpcServerClass.getName(), serverProtocols, policyProviderProtocols});
        Assert.assertFalse((String)"Expected to find at least one protocol in server.", (boolean)serverProtocols.isEmpty());
        Sets.SetView differenceSet = Sets.difference(serverProtocols, policyProviderProtocols);
        Assert.assertTrue((String)String.format("Following protocols for server %s are not defined in %s: %s", this.rpcServerClass.getName(), RouterPolicyProvider.class.getName(), Arrays.toString(differenceSet.toArray())), (boolean)differenceSet.isEmpty());
    }
}

