/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.util.UUID;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingContext {
    private final String clientCorrelationID;
    private final String fileSystemID;
    private String clientRequestId = "";
    private String primaryRequestId;
    private String streamID;
    private int retryCount;
    private FSOperationType opType;
    private final TracingHeaderFormat format;
    private Listener listener = null;
    private String header = "";
    private static final Logger LOG = LoggerFactory.getLogger(AbfsClient.class);
    public static final int MAX_CLIENT_CORRELATION_ID_LENGTH = 72;
    public static final String CLIENT_CORRELATION_ID_PATTERN = "[a-zA-Z0-9-]*";

    public TracingContext(String clientCorrelationID, String fileSystemID, FSOperationType opType, TracingHeaderFormat tracingHeaderFormat, Listener listener) {
        this.fileSystemID = fileSystemID;
        this.opType = opType;
        this.clientCorrelationID = clientCorrelationID;
        this.streamID = "";
        this.retryCount = 0;
        this.primaryRequestId = "";
        this.format = tracingHeaderFormat;
        this.listener = listener;
    }

    public TracingContext(String clientCorrelationID, String fileSystemID, FSOperationType opType, boolean needsPrimaryReqId, TracingHeaderFormat tracingHeaderFormat, Listener listener) {
        this(clientCorrelationID, fileSystemID, opType, tracingHeaderFormat, listener);
        String string = this.primaryRequestId = needsPrimaryReqId ? UUID.randomUUID().toString() : "";
        if (listener != null) {
            listener.updatePrimaryRequestID(this.primaryRequestId);
        }
    }

    public TracingContext(TracingContext originalTracingContext) {
        this.fileSystemID = originalTracingContext.fileSystemID;
        this.streamID = originalTracingContext.streamID;
        this.clientCorrelationID = originalTracingContext.clientCorrelationID;
        this.opType = originalTracingContext.opType;
        this.retryCount = 0;
        this.primaryRequestId = originalTracingContext.primaryRequestId;
        this.format = originalTracingContext.format;
        if (originalTracingContext.listener != null) {
            this.listener = originalTracingContext.listener.getClone();
        }
    }

    public static String validateClientCorrelationID(String clientCorrelationID) {
        if (clientCorrelationID.length() > 72 || !clientCorrelationID.matches(CLIENT_CORRELATION_ID_PATTERN)) {
            LOG.debug("Invalid config provided; correlation id not included in header.");
            return "";
        }
        return clientCorrelationID;
    }

    public void setPrimaryRequestID() {
        this.primaryRequestId = UUID.randomUUID().toString();
        if (this.listener != null) {
            this.listener.updatePrimaryRequestID(this.primaryRequestId);
        }
    }

    public void setStreamID(String stream) {
        this.streamID = stream;
    }

    public void setOperation(FSOperationType operation) {
        this.opType = operation;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void constructHeader(AbfsHttpOperation httpOperation) {
        this.clientRequestId = UUID.randomUUID().toString();
        switch (this.format) {
            case ALL_ID_FORMAT: {
                this.header = this.clientCorrelationID + ":" + this.clientRequestId + ":" + this.fileSystemID + ":" + this.primaryRequestId + ":" + this.streamID + ":" + (Object)((Object)this.opType) + ":" + this.retryCount;
                break;
            }
            case TWO_ID_FORMAT: {
                this.header = this.clientCorrelationID + ":" + this.clientRequestId;
                break;
            }
            default: {
                this.header = this.clientRequestId;
            }
        }
        if (this.listener != null) {
            this.listener.callTracingHeaderValidator(this.header, this.format);
        }
        httpOperation.setRequestProperty("x-ms-client-request-id", this.header);
    }

    public String getHeader() {
        return this.header;
    }
}

