/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.ReplicaAccessorBuilder;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsClientConf {
    private static final Logger LOG = LoggerFactory.getLogger(DfsClientConf.class);
    private final int hdfsTimeout;
    private final int maxFailoverAttempts;
    private final int maxRetryAttempts;
    private final int failoverSleepBaseMillis;
    private final int failoverSleepMaxMillis;
    private final int maxBlockAcquireFailures;
    private final int datanodeSocketWriteTimeout;
    private final int ioBufferSize;
    private final Options.ChecksumOpt defaultChecksumOpt;
    private final Options.ChecksumCombineMode checksumCombineMode;
    private final int checksumEcSocketTimeout;
    private final int writePacketSize;
    private final int writeMaxPackets;
    private final ByteArrayManager.Conf writeByteArrayManagerConf;
    private final int socketTimeout;
    private final int socketSendBufferSize;
    private final long excludedNodesCacheExpiry;
    private final int timeWindow;
    private final int numCachedConnRetry;
    private final int numBlockWriteRetry;
    private final int numBlockWriteLocateFollowingRetry;
    private final int blockWriteLocateFollowingInitialDelayMs;
    private final int blockWriteLocateFollowingMaxDelayMs;
    private final long defaultBlockSize;
    private final long prefetchSize;
    private final boolean uriCacheEnabled;
    private final short defaultReplication;
    private final String taskId;
    private final FsPermission uMask;
    private final boolean connectToDnViaHostname;
    private final int retryTimesForGetLastBlockLength;
    private final int retryIntervalForGetLastBlockLength;
    private final long datanodeRestartTimeout;
    private final long slowIoWarningThresholdMs;
    private final long refreshReadBlockLocationsMS;
    private final boolean refreshReadBlockLocationsAutomatically;
    private final ShortCircuitConf shortCircuitConf;
    private final int clientShortCircuitNum;
    private final long hedgedReadThresholdMillis;
    private final int hedgedReadThreadpoolSize;
    private final List<Class<? extends ReplicaAccessorBuilder>> replicaAccessorBuilderClasses;
    private final int stripedReadThreadpoolSize;
    private final boolean dataTransferTcpNoDelay;
    private final boolean readUseCachePriority;
    private final boolean deadNodeDetectionEnabled;
    private final long leaseHardLimitPeriod;

    public DfsClientConf(Configuration conf) {
        this.hdfsTimeout = Client.getRpcTimeout((Configuration)conf);
        this.maxRetryAttempts = conf.getInt("dfs.client.retry.max.attempts", 10);
        this.timeWindow = conf.getInt("dfs.client.retry.window.base", 3000);
        this.retryTimesForGetLastBlockLength = conf.getInt("dfs.client.retry.times.get-last-block-length", 3);
        this.retryIntervalForGetLastBlockLength = conf.getInt("dfs.client.retry.interval-ms.get-last-block-length", 4000);
        this.maxFailoverAttempts = conf.getInt("dfs.client.failover.max.attempts", 15);
        this.failoverSleepBaseMillis = conf.getInt("dfs.client.failover.sleep.base.millis", 500);
        this.failoverSleepMaxMillis = conf.getInt("dfs.client.failover.sleep.max.millis", 15000);
        this.maxBlockAcquireFailures = conf.getInt("dfs.client.max.block.acquire.failures", 3);
        this.datanodeSocketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        this.ioBufferSize = conf.getInt("io.file.buffer.size", 4096);
        this.defaultChecksumOpt = DfsClientConf.getChecksumOptFromConf(conf);
        this.checksumCombineMode = DfsClientConf.getChecksumCombineModeFromConf(conf);
        this.checksumEcSocketTimeout = conf.getInt("dfs.checksum.ec.socket-timeout", 3000);
        this.dataTransferTcpNoDelay = conf.getBoolean("dfs.data.transfer.client.tcpnodelay", true);
        this.socketTimeout = conf.getInt("dfs.client.socket-timeout", 60000);
        this.socketSendBufferSize = conf.getInt("dfs.client.socket.send.buffer.size", 0);
        this.writePacketSize = conf.getInt("dfs.client-write-packet-size", 65536);
        this.writeMaxPackets = conf.getInt("dfs.client.write.max-packets-in-flight", 80);
        this.writeByteArrayManagerConf = this.loadWriteByteArrayManagerConf(conf);
        this.defaultBlockSize = conf.getLongBytes("dfs.blocksize", 0x8000000L);
        this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
        this.taskId = conf.get("mapreduce.task.attempt.id", "NONMAPREDUCE");
        this.excludedNodesCacheExpiry = conf.getLong("dfs.client.write.exclude.nodes.cache.expiry.interval.millis", 600000L);
        this.prefetchSize = conf.getLong("dfs.client.read.prefetch.size", 10L * this.defaultBlockSize);
        this.uriCacheEnabled = conf.getBoolean("dfs.client.read.uri.cache.enabled", false);
        this.numCachedConnRetry = conf.getInt("dfs.client.cached.conn.retry", 3);
        this.numBlockWriteRetry = conf.getInt("dfs.client.block.write.retries", 3);
        this.numBlockWriteLocateFollowingRetry = conf.getInt("dfs.client.block.write.locateFollowingBlock.retries", 5);
        this.blockWriteLocateFollowingInitialDelayMs = conf.getInt("dfs.client.block.write.locateFollowingBlock.initial.delay.ms", 400);
        this.blockWriteLocateFollowingMaxDelayMs = conf.getInt("dfs.client.block.write.locateFollowingBlock.max.delay.ms", 60000);
        this.uMask = FsPermission.getUMask((Configuration)conf);
        this.connectToDnViaHostname = conf.getBoolean("dfs.client.use.datanode.hostname", false);
        this.datanodeRestartTimeout = conf.getTimeDuration("dfs.client.datanode-restart.timeout", 30L, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
        this.slowIoWarningThresholdMs = conf.getLong("dfs.client.slow.io.warning.threshold.ms", 30000L);
        this.readUseCachePriority = conf.getBoolean("dfs.client.read.use.cache.priority", false);
        this.refreshReadBlockLocationsMS = conf.getLong("dfs.client.refresh.read-block-locations.ms", 0L);
        this.refreshReadBlockLocationsAutomatically = conf.getBoolean("dfs.client.refresh.read-block-locations.register-automatically", true);
        this.hedgedReadThresholdMillis = conf.getLong("dfs.client.hedged.read.threshold.millis", 500L);
        this.hedgedReadThreadpoolSize = conf.getInt("dfs.client.hedged.read.threadpool.size", 0);
        this.deadNodeDetectionEnabled = conf.getBoolean("dfs.client.deadnode.detection.enabled", false);
        this.stripedReadThreadpoolSize = conf.getInt("dfs.client.read.striped.threadpool.size", 18);
        Preconditions.checkArgument((this.stripedReadThreadpoolSize > 0 ? 1 : 0) != 0, (Object)"The value of dfs.client.read.striped.threadpool.size must be greater than 0.");
        this.replicaAccessorBuilderClasses = this.loadReplicaAccessorBuilderClasses(conf);
        this.leaseHardLimitPeriod = conf.getLong("dfs.namenode.lease-hard-limit-sec", 1200L) * 1000L;
        this.shortCircuitConf = new ShortCircuitConf(conf);
        this.clientShortCircuitNum = conf.getInt("dfs.client.short.circuit.num", 1);
        Preconditions.checkArgument((this.clientShortCircuitNum >= 1 ? 1 : 0) != 0, (Object)"dfs.client.short.circuit.numcan't be less then 1.");
        Preconditions.checkArgument((this.clientShortCircuitNum <= 5 ? 1 : 0) != 0, (Object)"dfs.client.short.circuit.numcan't be more then 5.");
    }

    private ByteArrayManager.Conf loadWriteByteArrayManagerConf(Configuration conf) {
        boolean byteArrayManagerEnabled = conf.getBoolean("dfs.client.write.byte-array-manager.enabled", false);
        if (!byteArrayManagerEnabled) {
            return null;
        }
        int countThreshold = conf.getInt("dfs.client.write.byte-array-manager.count-threshold", 128);
        int countLimit = conf.getInt("dfs.client.write.byte-array-manager.count-limit", 2048);
        long countResetTimePeriodMs = conf.getLong("dfs.client.write.byte-array-manager.count-reset-time-period-ms", 10000L);
        return new ByteArrayManager.Conf(countThreshold, countLimit, countResetTimePeriodMs);
    }

    private List<Class<? extends ReplicaAccessorBuilder>> loadReplicaAccessorBuilderClasses(Configuration conf) {
        String[] classNames = conf.getTrimmedStrings("dfs.client.replica.accessor.builder.classes");
        if (classNames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Class<? extends ReplicaAccessorBuilder>> classes = new ArrayList<Class<? extends ReplicaAccessorBuilder>>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String className : classNames) {
            try {
                Class<?> cls = classLoader.loadClass(className);
                classes.add(cls);
            }
            catch (Throwable t) {
                LOG.warn("Unable to load " + className, t);
            }
        }
        return classes;
    }

    private static DataChecksum.Type getChecksumType(Configuration conf) {
        String checksum = conf.get("dfs.checksum.type", "CRC32C");
        try {
            return DataChecksum.Type.valueOf((String)checksum);
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Bad checksum type: {}. Using default {}", (Object)checksum, (Object)"CRC32C");
            return DataChecksum.Type.valueOf((String)"CRC32C");
        }
    }

    private static Options.ChecksumCombineMode getChecksumCombineModeFromConf(Configuration conf) {
        String mode = conf.get("dfs.checksum.combine.mode", "MD5MD5CRC");
        try {
            return Options.ChecksumCombineMode.valueOf((String)mode);
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Bad checksum combine mode: {}. Using default {}", (Object)mode, (Object)"MD5MD5CRC");
            return Options.ChecksumCombineMode.valueOf((String)"MD5MD5CRC");
        }
    }

    public static Options.ChecksumOpt getChecksumOptFromConf(Configuration conf) {
        DataChecksum.Type type = DfsClientConf.getChecksumType(conf);
        int bytesPerChecksum = conf.getInt("dfs.bytes-per-checksum", 512);
        return new Options.ChecksumOpt(type, bytesPerChecksum);
    }

    public DataChecksum createChecksum(Options.ChecksumOpt userOpt) {
        Options.ChecksumOpt opt = Options.ChecksumOpt.processChecksumOpt((Options.ChecksumOpt)this.defaultChecksumOpt, (Options.ChecksumOpt)userOpt);
        DataChecksum dataChecksum = DataChecksum.newDataChecksum((DataChecksum.Type)opt.getChecksumType(), (int)opt.getBytesPerChecksum());
        if (dataChecksum == null) {
            throw new HadoopIllegalArgumentException("Invalid checksum type: userOpt=" + userOpt + ", default=" + this.defaultChecksumOpt + ", effective=null");
        }
        return dataChecksum;
    }

    @VisibleForTesting
    public int getBlockWriteLocateFollowingInitialDelayMs() {
        return this.blockWriteLocateFollowingInitialDelayMs;
    }

    public int getBlockWriteLocateFollowingMaxDelayMs() {
        return this.blockWriteLocateFollowingMaxDelayMs;
    }

    public int getHdfsTimeout() {
        return this.hdfsTimeout;
    }

    public int getMaxFailoverAttempts() {
        return this.maxFailoverAttempts;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public int getFailoverSleepBaseMillis() {
        return this.failoverSleepBaseMillis;
    }

    public int getFailoverSleepMaxMillis() {
        return this.failoverSleepMaxMillis;
    }

    public int getMaxBlockAcquireFailures() {
        return this.maxBlockAcquireFailures;
    }

    public int getDatanodeSocketWriteTimeout() {
        return this.datanodeSocketWriteTimeout;
    }

    public int getIoBufferSize() {
        return this.ioBufferSize;
    }

    public Options.ChecksumOpt getDefaultChecksumOpt() {
        return this.defaultChecksumOpt;
    }

    public Options.ChecksumCombineMode getChecksumCombineMode() {
        return this.checksumCombineMode;
    }

    public int getChecksumEcSocketTimeout() {
        return this.checksumEcSocketTimeout;
    }

    public int getWritePacketSize() {
        return this.writePacketSize;
    }

    public int getWriteMaxPackets() {
        return this.writeMaxPackets;
    }

    public ByteArrayManager.Conf getWriteByteArrayManagerConf() {
        return this.writeByteArrayManagerConf;
    }

    public boolean getDataTransferTcpNoDelay() {
        return this.dataTransferTcpNoDelay;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getSocketSendBufferSize() {
        return this.socketSendBufferSize;
    }

    public long getExcludedNodesCacheExpiry() {
        return this.excludedNodesCacheExpiry;
    }

    public int getTimeWindow() {
        return this.timeWindow;
    }

    public int getNumCachedConnRetry() {
        return this.numCachedConnRetry;
    }

    public int getNumBlockWriteRetry() {
        return this.numBlockWriteRetry;
    }

    public int getNumBlockWriteLocateFollowingRetry() {
        return this.numBlockWriteLocateFollowingRetry;
    }

    public long getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public long getPrefetchSize() {
        return this.prefetchSize;
    }

    public boolean isUriCacheEnabled() {
        return this.uriCacheEnabled;
    }

    public short getDefaultReplication() {
        return this.defaultReplication;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public FsPermission getUMask() {
        return this.uMask;
    }

    public boolean isConnectToDnViaHostname() {
        return this.connectToDnViaHostname;
    }

    public int getRetryTimesForGetLastBlockLength() {
        return this.retryTimesForGetLastBlockLength;
    }

    public int getRetryIntervalForGetLastBlockLength() {
        return this.retryIntervalForGetLastBlockLength;
    }

    public long getDatanodeRestartTimeout() {
        return this.datanodeRestartTimeout;
    }

    public long getSlowIoWarningThresholdMs() {
        return this.slowIoWarningThresholdMs;
    }

    public int getClientShortCircuitNum() {
        return this.clientShortCircuitNum;
    }

    public long getHedgedReadThresholdMillis() {
        return this.hedgedReadThresholdMillis;
    }

    public int getHedgedReadThreadpoolSize() {
        return this.hedgedReadThreadpoolSize;
    }

    public int getStripedReadThreadpoolSize() {
        return this.stripedReadThreadpoolSize;
    }

    public boolean isDeadNodeDetectionEnabled() {
        return this.deadNodeDetectionEnabled;
    }

    public long getleaseHardLimitPeriod() {
        return this.leaseHardLimitPeriod;
    }

    public boolean isReadUseCachePriority() {
        return this.readUseCachePriority;
    }

    public List<Class<? extends ReplicaAccessorBuilder>> getReplicaAccessorBuilderClasses() {
        return this.replicaAccessorBuilderClasses;
    }

    public boolean isLocatedBlocksRefresherEnabled() {
        return this.refreshReadBlockLocationsMS > 0L;
    }

    public long getLocatedBlocksRefresherInterval() {
        return this.refreshReadBlockLocationsMS;
    }

    public boolean isRefreshReadBlockLocationsAutomatically() {
        return this.refreshReadBlockLocationsAutomatically;
    }

    public ShortCircuitConf getShortCircuitConf() {
        return this.shortCircuitConf;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    public static class ShortCircuitConf {
        private static final Logger LOG = DfsClientConf.access$000();
        private final int socketCacheCapacity;
        private final long socketCacheExpiry;
        private final boolean useLegacyBlockReaderLocal;
        private final String domainSocketPath;
        private final boolean skipShortCircuitChecksums;
        private final int shortCircuitBufferSize;
        private final boolean shortCircuitLocalReads;
        private final boolean domainSocketDataTraffic;
        private final int shortCircuitStreamsCacheSize;
        private final long shortCircuitStreamsCacheExpiryMs;
        private final int shortCircuitSharedMemoryWatcherInterruptCheckMs;
        private final boolean scrMetricsEnabled;
        private final int scrMetricsSamplingPercentage;
        private final boolean shortCircuitMmapEnabled;
        private final int shortCircuitMmapCacheSize;
        private final long shortCircuitMmapCacheExpiryMs;
        private final long shortCircuitMmapCacheRetryTimeout;
        private final long shortCircuitCacheStaleThresholdMs;
        private final long domainSocketDisableIntervalSeconds;
        private final long keyProviderCacheExpiryMs;

        public ShortCircuitConf(Configuration conf) {
            this.socketCacheCapacity = conf.getInt("dfs.client.socketcache.capacity", 16);
            this.socketCacheExpiry = conf.getLong("dfs.client.socketcache.expiryMsec", 3000L);
            this.useLegacyBlockReaderLocal = conf.getBoolean("dfs.client.use.legacy.blockreader.local", false);
            this.shortCircuitLocalReads = conf.getBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false);
            int scrSamplingPercentage = conf.getInt("dfs.client.read.shortcircuit.metrics.sampling.percentage", 0);
            if (scrSamplingPercentage <= 0) {
                this.scrMetricsSamplingPercentage = 0;
                this.scrMetricsEnabled = false;
            } else if (scrSamplingPercentage > 100) {
                this.scrMetricsSamplingPercentage = 100;
                this.scrMetricsEnabled = true;
            } else {
                this.scrMetricsSamplingPercentage = scrSamplingPercentage;
                this.scrMetricsEnabled = true;
            }
            this.domainSocketDataTraffic = conf.getBoolean("dfs.client.domain.socket.data.traffic", false);
            this.domainSocketPath = conf.getTrimmed("dfs.domain.socket.path", "");
            LOG.debug("dfs.client.use.legacy.blockreader.local = {}", (Object)this.useLegacyBlockReaderLocal);
            LOG.debug(HdfsClientConfigKeys.Read.ShortCircuit.KEY + " = {}", (Object)this.shortCircuitLocalReads);
            LOG.debug("dfs.client.domain.socket.data.traffic = {}", (Object)this.domainSocketDataTraffic);
            LOG.debug("dfs.domain.socket.path = {}", (Object)this.domainSocketPath);
            this.skipShortCircuitChecksums = conf.getBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
            this.shortCircuitBufferSize = conf.getInt("dfs.client.read.shortcircuit.buffer.size", 0x100000);
            this.shortCircuitStreamsCacheSize = conf.getInt("dfs.client.read.shortcircuit.streams.cache.size", 256);
            this.shortCircuitStreamsCacheExpiryMs = conf.getLong("dfs.client.read.shortcircuit.streams.cache.expiry.ms", 300000L);
            this.shortCircuitMmapEnabled = conf.getBoolean("dfs.client.mmap.enabled", true);
            this.shortCircuitMmapCacheSize = conf.getInt("dfs.client.mmap.cache.size", 256);
            this.shortCircuitMmapCacheExpiryMs = conf.getLong("dfs.client.mmap.cache.timeout.ms", 3600000L);
            this.shortCircuitMmapCacheRetryTimeout = conf.getLong("dfs.client.mmap.retry.timeout.ms", 300000L);
            this.shortCircuitCacheStaleThresholdMs = conf.getLong("dfs.client.read.short.circuit.replica.stale.threshold.ms", 1800000L);
            this.shortCircuitSharedMemoryWatcherInterruptCheckMs = conf.getInt("dfs.short.circuit.shared.memory.watcher.interrupt.check.ms", 60000);
            this.domainSocketDisableIntervalSeconds = conf.getLong("dfs.domain.socket.disable.interval.seconds", 600L);
            Preconditions.checkArgument((this.domainSocketDisableIntervalSeconds >= 0L ? 1 : 0) != 0, (Object)"dfs.domain.socket.disable.interval.secondscan't be negative.");
            this.keyProviderCacheExpiryMs = conf.getLong("dfs.client.key.provider.cache.expiry", HdfsClientConfigKeys.DFS_CLIENT_KEY_PROVIDER_CACHE_EXPIRY_DEFAULT);
        }

        public int getSocketCacheCapacity() {
            return this.socketCacheCapacity;
        }

        public long getSocketCacheExpiry() {
            return this.socketCacheExpiry;
        }

        public boolean isUseLegacyBlockReaderLocal() {
            return this.useLegacyBlockReaderLocal;
        }

        public String getDomainSocketPath() {
            return this.domainSocketPath;
        }

        public boolean isShortCircuitLocalReads() {
            return this.shortCircuitLocalReads;
        }

        public boolean isScrMetricsEnabled() {
            return this.scrMetricsEnabled;
        }

        public int getScrMetricsSamplingPercentage() {
            return this.scrMetricsSamplingPercentage;
        }

        public boolean isDomainSocketDataTraffic() {
            return this.domainSocketDataTraffic;
        }

        public boolean isSkipShortCircuitChecksums() {
            return this.skipShortCircuitChecksums;
        }

        public int getShortCircuitBufferSize() {
            return this.shortCircuitBufferSize;
        }

        public int getShortCircuitStreamsCacheSize() {
            return this.shortCircuitStreamsCacheSize;
        }

        public long getShortCircuitStreamsCacheExpiryMs() {
            return this.shortCircuitStreamsCacheExpiryMs;
        }

        public int getShortCircuitSharedMemoryWatcherInterruptCheckMs() {
            return this.shortCircuitSharedMemoryWatcherInterruptCheckMs;
        }

        public boolean isShortCircuitMmapEnabled() {
            return this.shortCircuitMmapEnabled;
        }

        public int getShortCircuitMmapCacheSize() {
            return this.shortCircuitMmapCacheSize;
        }

        public long getShortCircuitMmapCacheExpiryMs() {
            return this.shortCircuitMmapCacheExpiryMs;
        }

        public long getShortCircuitMmapCacheRetryTimeout() {
            return this.shortCircuitMmapCacheRetryTimeout;
        }

        public long getShortCircuitCacheStaleThresholdMs() {
            return this.shortCircuitCacheStaleThresholdMs;
        }

        public long getDomainSocketDisableIntervalSeconds() {
            return this.domainSocketDisableIntervalSeconds;
        }

        public long getKeyProviderCacheExpiryMs() {
            return this.keyProviderCacheExpiryMs;
        }

        public String confAsString() {
            return "shortCircuitStreamsCacheSize = " + this.shortCircuitStreamsCacheSize + ", shortCircuitStreamsCacheExpiryMs = " + this.shortCircuitStreamsCacheExpiryMs + ", shortCircuitMmapCacheSize = " + this.shortCircuitMmapCacheSize + ", shortCircuitMmapCacheExpiryMs = " + this.shortCircuitMmapCacheExpiryMs + ", shortCircuitMmapCacheRetryTimeout = " + this.shortCircuitMmapCacheRetryTimeout + ", shortCircuitCacheStaleThresholdMs = " + this.shortCircuitCacheStaleThresholdMs + ", socketCacheCapacity = " + this.socketCacheCapacity + ", socketCacheExpiry = " + this.socketCacheExpiry + ", shortCircuitLocalReads = " + this.shortCircuitLocalReads + ", useLegacyBlockReaderLocal = " + this.useLegacyBlockReaderLocal + ", domainSocketDataTraffic = " + this.domainSocketDataTraffic + ", shortCircuitSharedMemoryWatcherInterruptCheckMs = " + this.shortCircuitSharedMemoryWatcherInterruptCheckMs + ", keyProviderCacheExpiryMs = " + this.keyProviderCacheExpiryMs + ", domainSocketDisableIntervalSeconds = " + this.domainSocketDisableIntervalSeconds;
        }
    }
}

