/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask;

import com.google.common.base.Charsets;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputCollector;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.nativetask.NativeRuntime;
import org.apache.hadoop.mapred.nativetask.Platforms;
import org.apache.hadoop.mapred.nativetask.StatusReportChecker;
import org.apache.hadoop.mapred.nativetask.TaskContext;
import org.apache.hadoop.mapred.nativetask.handlers.NativeCollectorOnlyHandler;
import org.apache.hadoop.mapred.nativetask.serde.INativeSerializer;
import org.apache.hadoop.mapred.nativetask.serde.NativeSerialization;
import org.apache.hadoop.util.QuickSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NativeMapOutputCollectorDelegator<K, V>
implements MapOutputCollector<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(NativeMapOutputCollectorDelegator.class);
    private JobConf job;
    private NativeCollectorOnlyHandler<K, V> handler;
    private MapOutputCollector.Context context;
    private StatusReportChecker updater;

    public void collect(K key, V value, int partition) throws IOException, InterruptedException {
        this.handler.collect(key, value, partition);
    }

    public void close() throws IOException, InterruptedException {
        this.handler.close();
        if (null != this.updater) {
            this.updater.stop();
            NativeRuntime.reportStatus(this.context.getReporter());
        }
    }

    public void flush() throws IOException, InterruptedException, ClassNotFoundException {
        this.handler.flush();
    }

    public void init(MapOutputCollector.Context context) throws IOException, ClassNotFoundException {
        this.context = context;
        this.job = context.getJobConf();
        Platforms.init((Configuration)this.job);
        if (this.job.getNumReduceTasks() == 0) {
            String message = "There is no reducer, no need to use native output collector";
            LOG.error(message);
            throw new InvalidJobConfException(message);
        }
        Class comparatorClass = this.job.getClass("mapreduce.job.output.key.comparator.class", null, RawComparator.class);
        if (comparatorClass != null && !Platforms.define(comparatorClass)) {
            String message = "Native output collector doesn't support customized java comparator " + this.job.get("mapreduce.job.output.key.comparator.class");
            LOG.error(message);
            throw new InvalidJobConfException(message);
        }
        if (!QuickSort.class.getName().equals(this.job.get("map.sort.class"))) {
            String message = "Native-Task doesn't support sort class " + this.job.get("map.sort.class");
            LOG.error(message);
            throw new InvalidJobConfException(message);
        }
        if (this.job.getBoolean("mapreduce.shuffle.ssl.enabled", false)) {
            String message = "Native-Task doesn't support secure shuffle";
            LOG.error(message);
            throw new InvalidJobConfException(message);
        }
        Class keyCls = this.job.getMapOutputKeyClass();
        try {
            INativeSerializer<Writable> serializer = NativeSerialization.getInstance().getSerializer(keyCls);
            if (null == serializer) {
                String message = "Key type not supported. Cannot find serializer for " + keyCls.getName();
                LOG.error(message);
                throw new InvalidJobConfException(message);
            }
            if (!Platforms.support(keyCls.getName(), serializer, this.job)) {
                String message = "Native output collector doesn't support this key, this key is not comparable in native: " + keyCls.getName();
                LOG.error(message);
                throw new InvalidJobConfException(message);
            }
        }
        catch (IOException e) {
            String message = "Cannot find serializer for " + keyCls.getName();
            LOG.error(message);
            throw new IOException(message);
        }
        boolean ret = NativeRuntime.isNativeLibraryLoaded();
        if (ret) {
            String codec;
            if (this.job.getBoolean("mapreduce.map.output.compress", false) && !NativeRuntime.supportsCompressionCodec((codec = this.job.get("mapreduce.map.output.compress.codec")).getBytes(Charsets.UTF_8))) {
                String message = "Native output collector doesn't support compression codec " + codec;
                LOG.error(message);
                throw new InvalidJobConfException(message);
            }
        } else {
            String message = "NativeRuntime cannot be loaded, please check that libnativetask.so is in hadoop library dir";
            LOG.error(message);
            throw new InvalidJobConfException(message);
        }
        NativeRuntime.configure((Configuration)this.job);
        long updateInterval = this.job.getLong("native.update.interval", 3000L);
        this.updater = new StatusReportChecker(context.getReporter(), updateInterval);
        this.updater.start();
        this.handler = null;
        try {
            Class oKClass = this.job.getMapOutputKeyClass();
            Class oVClass = this.job.getMapOutputValueClass();
            TaskAttemptID id = context.getMapTask().getTaskID();
            TaskContext taskContext = new TaskContext(this.job, null, null, oKClass, oVClass, context.getReporter(), id);
            this.handler = NativeCollectorOnlyHandler.create(taskContext);
        }
        catch (IOException e) {
            String message = "Native output collector cannot be loaded;";
            LOG.error(message);
            throw new IOException(message, e);
        }
        LOG.info("Native output collector can be successfully enabled!");
    }
}

