/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.TestStateStoreBase;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.NamenodeHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.NamenodeHeartbeatResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateNamenodeRegistrationRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStateStoreMembershipState
extends TestStateStoreBase {
    private static MembershipStore membershipStore;

    @BeforeClass
    public static void create() {
        TestStateStoreMembershipState.getConf().setLong("dfs.federation.router.store.membership.expiration", TimeUnit.SECONDS.toMillis(5L));
    }

    @Before
    public void setup() throws IOException, InterruptedException {
        membershipStore = (MembershipStore)TestStateStoreMembershipState.getStateStore().getRegisteredRecordStore(MembershipStore.class);
        Assert.assertTrue((boolean)FederationStateStoreTestUtils.clearRecords(TestStateStoreMembershipState.getStateStore(), MembershipState.class));
    }

    @Test
    public void testNamenodeStateOverride() throws Exception {
        String ns = "ns0";
        String nn = "nn0";
        MembershipState report = this.createRegistration(ns, nn, FederationTestUtils.ROUTERS[1], FederationNamenodeServiceState.STANDBY);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report));
        Assert.assertTrue((boolean)TestStateStoreMembershipState.getStateStore().loadCache(MembershipStore.class, true));
        MembershipState existingState = this.getNamenodeRegistration(ns, nn);
        Assert.assertEquals((Object)FederationNamenodeServiceState.STANDBY, (Object)existingState.getState());
        UpdateNamenodeRegistrationRequest request = UpdateNamenodeRegistrationRequest.newInstance((String)ns, (String)nn, (FederationNamenodeServiceState)FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)membershipStore.updateNamenodeRegistration(request).getResult());
        MembershipState newState = this.getNamenodeRegistration(ns, nn);
        Assert.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)newState.getState());
    }

    @Test
    public void testStateStoreDisconnected() throws Exception {
        TestStateStoreMembershipState.getStateStore().closeDriver();
        Assert.assertFalse((boolean)TestStateStoreMembershipState.getStateStore().isDriverReady());
        NamenodeHeartbeatRequest hbRequest = NamenodeHeartbeatRequest.newInstance();
        hbRequest.setNamenodeMembership(FederationStateStoreTestUtils.createMockRegistrationForNamenode("test", "test", FederationNamenodeServiceState.UNAVAILABLE));
        FederationTestUtils.verifyException(membershipStore, "namenodeHeartbeat", StateStoreUnavailableException.class, new Class[]{NamenodeHeartbeatRequest.class}, new Object[]{hbRequest});
        GetNamenodeRegistrationsRequest getRequest = GetNamenodeRegistrationsRequest.newInstance();
        FederationTestUtils.verifyException(membershipStore, "getNamenodeRegistrations", null, new Class[]{GetNamenodeRegistrationsRequest.class}, new Object[]{getRequest});
        FederationTestUtils.verifyException(membershipStore, "getExpiredNamenodeRegistrations", null, new Class[]{GetNamenodeRegistrationsRequest.class}, new Object[]{getRequest});
        UpdateNamenodeRegistrationRequest overrideRequest = UpdateNamenodeRegistrationRequest.newInstance();
        FederationTestUtils.verifyException(membershipStore, "updateNamenodeRegistration", null, new Class[]{UpdateNamenodeRegistrationRequest.class}, new Object[]{overrideRequest});
    }

    private void registerAndLoadRegistrations(List<MembershipState> registrationList) throws IOException {
        Assert.assertTrue((boolean)FederationStateStoreTestUtils.synchronizeRecords(TestStateStoreMembershipState.getStateStore(), registrationList, MembershipState.class));
        Assert.assertTrue((boolean)TestStateStoreMembershipState.getStateStore().loadCache(MembershipStore.class, true));
    }

    private MembershipState createRegistration(String ns, String nn, String router, FederationNamenodeServiceState state) throws IOException {
        MembershipState record = MembershipState.newInstance((String)router, (String)ns, (String)nn, (String)"testcluster", (String)("testblock-" + ns), (String)("testrpc-" + ns + nn), (String)("testservice-" + ns + nn), (String)("testlifeline-" + ns + nn), (String)("testweb-" + ns + nn), (FederationNamenodeServiceState)state, (boolean)false);
        return record;
    }

    @Test
    public void testRegistrationMajorityQuorum() throws InterruptedException, IOException {
        String ns = "ns0";
        String nn = "nn0";
        MembershipState report = this.createRegistration(ns, nn, FederationTestUtils.ROUTERS[1], FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report));
        Thread.sleep(1000L);
        report = this.createRegistration(ns, nn, FederationTestUtils.ROUTERS[2], FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report));
        Thread.sleep(1000L);
        report = this.createRegistration(ns, nn, FederationTestUtils.ROUTERS[3], FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report));
        report = this.createRegistration(ns, nn, FederationTestUtils.ROUTERS[0], FederationNamenodeServiceState.STANDBY);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report));
        Assert.assertTrue((boolean)TestStateStoreMembershipState.getStateStore().loadCache(MembershipStore.class, true));
        MembershipState quorumEntry = this.getNamenodeRegistration(report.getNameserviceId(), report.getNamenodeId());
        Assert.assertNotNull((Object)quorumEntry);
        Assert.assertEquals((Object)quorumEntry.getRouterId(), (Object)FederationTestUtils.ROUTERS[3]);
    }

    @Test
    public void testRegistrationQuorumExcludesExpired() throws InterruptedException, IOException {
        ArrayList<MembershipState> registrationList = new ArrayList<MembershipState>();
        String ns = "ns0";
        String nn = "nn0";
        String rpcAddress = "testrpcaddress";
        String serviceAddress = "testserviceaddress";
        String lifelineAddress = "testlifelineaddress";
        String blockPoolId = "testblockpool";
        String clusterId = "testcluster";
        String webAddress = "testwebaddress";
        boolean safemode = false;
        MembershipState record = MembershipState.newInstance((String)FederationTestUtils.ROUTERS[0], (String)ns, (String)nn, (String)clusterId, (String)blockPoolId, (String)rpcAddress, (String)serviceAddress, (String)lifelineAddress, (String)webAddress, (FederationNamenodeServiceState)FederationNamenodeServiceState.ACTIVE, (boolean)safemode);
        registrationList.add(record);
        record = MembershipState.newInstance((String)FederationTestUtils.ROUTERS[1], (String)ns, (String)nn, (String)clusterId, (String)blockPoolId, (String)rpcAddress, (String)serviceAddress, (String)lifelineAddress, (String)webAddress, (FederationNamenodeServiceState)FederationNamenodeServiceState.EXPIRED, (boolean)safemode);
        registrationList.add(record);
        record = MembershipState.newInstance((String)FederationTestUtils.ROUTERS[2], (String)ns, (String)nn, (String)clusterId, (String)blockPoolId, (String)rpcAddress, (String)serviceAddress, (String)lifelineAddress, (String)webAddress, (FederationNamenodeServiceState)FederationNamenodeServiceState.EXPIRED, (boolean)safemode);
        registrationList.add(record);
        record = MembershipState.newInstance((String)FederationTestUtils.ROUTERS[3], (String)ns, (String)nn, (String)clusterId, (String)blockPoolId, (String)rpcAddress, (String)serviceAddress, (String)lifelineAddress, (String)webAddress, (FederationNamenodeServiceState)FederationNamenodeServiceState.EXPIRED, (boolean)safemode);
        registrationList.add(record);
        this.registerAndLoadRegistrations(registrationList);
        MembershipState quorumEntry = this.getNamenodeRegistration(record.getNameserviceId(), record.getNamenodeId());
        Assert.assertNotNull((Object)quorumEntry);
        Assert.assertEquals((Object)FederationTestUtils.ROUTERS[0], (Object)quorumEntry.getRouterId());
    }

    @Test
    public void testRegistrationQuorumAllExpired() throws IOException {
        ArrayList<MembershipState> registrationList = new ArrayList<MembershipState>();
        String ns = FederationTestUtils.NAMESERVICES[0];
        String nn = FederationTestUtils.NAMENODES[0];
        String rpcAddress = "testrpcaddress";
        String serviceAddress = "testserviceaddress";
        String lifelineAddress = "testlifelineaddress";
        String blockPoolId = "testblockpool";
        String clusterId = "testcluster";
        String webAddress = "testwebaddress";
        boolean safemode = false;
        long startingTime = Time.now();
        MembershipState record = MembershipState.newInstance((String)FederationTestUtils.ROUTERS[0], (String)ns, (String)nn, (String)clusterId, (String)blockPoolId, (String)rpcAddress, (String)webAddress, (String)lifelineAddress, (String)webAddress, (FederationNamenodeServiceState)FederationNamenodeServiceState.EXPIRED, (boolean)safemode);
        record.setDateModified(startingTime - 10000L);
        registrationList.add(record);
        record = MembershipState.newInstance((String)FederationTestUtils.ROUTERS[1], (String)ns, (String)nn, (String)clusterId, (String)blockPoolId, (String)rpcAddress, (String)serviceAddress, (String)lifelineAddress, (String)webAddress, (FederationNamenodeServiceState)FederationNamenodeServiceState.EXPIRED, (boolean)safemode);
        record.setDateModified(startingTime);
        registrationList.add(record);
        record = MembershipState.newInstance((String)FederationTestUtils.ROUTERS[2], (String)ns, (String)nn, (String)clusterId, (String)blockPoolId, (String)rpcAddress, (String)serviceAddress, (String)lifelineAddress, (String)webAddress, (FederationNamenodeServiceState)FederationNamenodeServiceState.EXPIRED, (boolean)safemode);
        record.setDateModified(startingTime);
        registrationList.add(record);
        record = MembershipState.newInstance((String)FederationTestUtils.ROUTERS[3], (String)ns, (String)nn, (String)clusterId, (String)blockPoolId, (String)rpcAddress, (String)serviceAddress, (String)lifelineAddress, (String)webAddress, (FederationNamenodeServiceState)FederationNamenodeServiceState.EXPIRED, (boolean)safemode);
        record.setDateModified(startingTime);
        registrationList.add(record);
        this.registerAndLoadRegistrations(registrationList);
        Assert.assertNull((Object)this.getNamenodeRegistration(record.getNameserviceId(), record.getNamenodeId()));
    }

    @Test
    public void testRegistrationNoQuorum() throws InterruptedException, IOException {
        MembershipState report1 = this.createRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], FederationTestUtils.ROUTERS[1], FederationNamenodeServiceState.STANDBY);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report1));
        Thread.sleep(100L);
        MembershipState report2 = this.createRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], FederationTestUtils.ROUTERS[2], FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report2));
        Thread.sleep(100L);
        MembershipState report3 = this.createRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], FederationTestUtils.ROUTERS[3], FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report3));
        Thread.sleep(100L);
        MembershipState report4 = this.createRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], FederationTestUtils.ROUTERS[0], FederationNamenodeServiceState.STANDBY);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report4));
        Assert.assertTrue((boolean)TestStateStoreMembershipState.getStateStore().loadCache(MembershipStore.class, true));
        MembershipState quorumEntry = this.getNamenodeRegistration(report1.getNameserviceId(), report1.getNamenodeId());
        Assert.assertNotNull((Object)quorumEntry);
        Assert.assertEquals((Object)FederationTestUtils.ROUTERS[0], (Object)quorumEntry.getRouterId());
        Assert.assertEquals((Object)FederationNamenodeServiceState.STANDBY, (Object)quorumEntry.getState());
    }

    @Test
    public void testRegistrationExpired() throws InterruptedException, IOException {
        MembershipState report = this.createRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], FederationTestUtils.ROUTERS[0], FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report));
        Assert.assertTrue((boolean)TestStateStoreMembershipState.getStateStore().loadCache(MembershipStore.class, true));
        MembershipState quorumEntry = this.getNamenodeRegistration(report.getNameserviceId(), report.getNamenodeId());
        Assert.assertNotNull((Object)quorumEntry);
        Assert.assertEquals((Object)FederationTestUtils.ROUTERS[0], (Object)quorumEntry.getRouterId());
        Assert.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)quorumEntry.getState());
        Thread.sleep(6000L);
        Assert.assertTrue((boolean)TestStateStoreMembershipState.getStateStore().loadCache(MembershipStore.class, true));
        quorumEntry = this.getNamenodeRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0]);
        Assert.assertNull((Object)quorumEntry);
        quorumEntry = this.getNamenodeRegistration(report.getNameserviceId(), report.getNamenodeId());
        Assert.assertNull((Object)quorumEntry);
        Assert.assertTrue((boolean)this.namenodeHeartbeat(report));
        Assert.assertTrue((boolean)TestStateStoreMembershipState.getStateStore().loadCache(MembershipStore.class, true));
        quorumEntry = this.getNamenodeRegistration(report.getNameserviceId(), report.getNamenodeId());
        Assert.assertNotNull((Object)quorumEntry);
        Assert.assertEquals((Object)FederationTestUtils.ROUTERS[0], (Object)quorumEntry.getRouterId());
        Assert.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)quorumEntry.getState());
    }

    @Test
    public void testNamespaceInfoWithUnavailableNameNodeRegistration() throws IOException {
        ArrayList<MembershipState> registrationList = new ArrayList<MembershipState>();
        String router = FederationTestUtils.ROUTERS[0];
        String ns = FederationTestUtils.NAMESERVICES[0];
        String rpcAddress = "testrpcaddress";
        String serviceAddress = "testserviceaddress";
        String lifelineAddress = "testlifelineaddress";
        String blockPoolId = "testblockpool";
        String clusterId = "testcluster";
        String webAddress = "testwebaddress";
        boolean safemode = false;
        MembershipState record = MembershipState.newInstance((String)router, (String)ns, (String)FederationTestUtils.NAMENODES[0], (String)clusterId, (String)blockPoolId, (String)rpcAddress, (String)serviceAddress, (String)lifelineAddress, (String)webAddress, (FederationNamenodeServiceState)FederationNamenodeServiceState.ACTIVE, (boolean)safemode);
        registrationList.add(record);
        record = MembershipState.newInstance((String)router, (String)ns, (String)FederationTestUtils.NAMENODES[1], (String)"", (String)"", (String)rpcAddress, (String)serviceAddress, (String)lifelineAddress, (String)webAddress, (FederationNamenodeServiceState)FederationNamenodeServiceState.UNAVAILABLE, (boolean)safemode);
        registrationList.add(record);
        this.registerAndLoadRegistrations(registrationList);
        GetNamespaceInfoRequest request = GetNamespaceInfoRequest.newInstance();
        GetNamespaceInfoResponse response = membershipStore.getNamespaceInfo(request);
        Set namespaces = response.getNamespaceInfo();
        Assert.assertEquals((long)1L, (long)namespaces.size());
        FederationNamespaceInfo namespace = (FederationNamespaceInfo)namespaces.iterator().next();
        Assert.assertEquals((Object)ns, (Object)namespace.getNameserviceId());
        Assert.assertEquals((Object)clusterId, (Object)namespace.getClusterId());
        Assert.assertEquals((Object)blockPoolId, (Object)namespace.getBlockPoolId());
    }

    private MembershipState getNamenodeRegistration(String nsId, String nnId) throws IOException {
        MembershipState partial = MembershipState.newInstance();
        partial.setNameserviceId(nsId);
        partial.setNamenodeId(nnId);
        GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance((MembershipState)partial);
        GetNamenodeRegistrationsResponse response = membershipStore.getNamenodeRegistrations(request);
        List results = response.getNamenodeMemberships();
        if (results != null && results.size() == 1) {
            MembershipState record = (MembershipState)results.get(0);
            return record;
        }
        return null;
    }

    private boolean namenodeHeartbeat(MembershipState namenode) throws IOException {
        NamenodeHeartbeatRequest request = NamenodeHeartbeatRequest.newInstance((MembershipState)namenode);
        NamenodeHeartbeatResponse response = membershipStore.namenodeHeartbeat(request);
        return response.getResult();
    }
}

