/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDisableRouterQuota {
    private static Router router;

    @BeforeClass
    public static void setUp() throws Exception {
        router = new Router();
        Configuration routerConf = new RouterConfigBuilder().quota(false).rpc().build();
        router.init(routerConf);
        router.setRouterId("TestRouterId");
        router.start();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (router != null) {
            router.stop();
            router.close();
        }
    }

    @Before
    public void checkDisableQuota() {
        Assert.assertFalse((boolean)router.isQuotaEnabled());
    }

    @Test
    public void testSetQuota() throws Exception {
        long nsQuota = 1024L;
        long ssQuota = 1024L;
        try {
            Quota quotaModule = router.getRpcServer().getQuotaModule();
            quotaModule.setQuota("/test", nsQuota, ssQuota, null);
            Assert.fail((String)"The setQuota call should fail.");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"The quota system is disabled in Router.", (Throwable)ioe);
        }
    }

    @Test
    public void testGetQuotaUsage() throws Exception {
        try {
            Quota quotaModule = router.getRpcServer().getQuotaModule();
            quotaModule.getQuotaUsage("/test");
            Assert.fail((String)"The getQuotaUsage call should fail.");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"The quota system is disabled in Router.", (Throwable)ioe);
        }
    }
}

