/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.client.api.AppAdminClient;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.submarine.common.conf.SubmarineLogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnServiceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(YarnServiceUtils.class);
    private static AppAdminClient stubServiceClient = null;

    public static AppAdminClient createServiceClient(Configuration yarnConfiguration) {
        if (stubServiceClient != null) {
            return stubServiceClient;
        }
        AppAdminClient serviceClient = AppAdminClient.createAppAdminClient((String)"yarn-service", (Configuration)yarnConfiguration);
        return serviceClient;
    }

    @VisibleForTesting
    public static void setStubServiceClient(AppAdminClient stubServiceClient) {
        YarnServiceUtils.stubServiceClient = stubServiceClient;
    }

    public static String getDNSName(String serviceName, String componentInstanceName, String userName, String domain, int port) {
        return componentInstanceName + YarnServiceUtils.getDNSNameCommonSuffix(serviceName, userName, domain, port);
    }

    private static String getDNSNameCommonSuffix(String serviceName, String userName, String domain, int port) {
        String commonEndpointSuffix = "." + serviceName + "." + userName + "." + domain + ":" + port;
        return commonEndpointSuffix;
    }

    public static String getTFConfigEnv(String curCommponentName, int nWorkers, int nPs, String serviceName, String userName, String domain) {
        String commonEndpointSuffix = YarnServiceUtils.getDNSNameCommonSuffix(serviceName, userName, domain, 8000);
        String json = "{\\\"cluster\\\":{";
        String master = YarnServiceUtils.getComponentArrayJson("master", 1, commonEndpointSuffix) + ",";
        String worker = YarnServiceUtils.getComponentArrayJson("worker", nWorkers - 1, commonEndpointSuffix) + ",";
        String ps = YarnServiceUtils.getComponentArrayJson("ps", nPs, commonEndpointSuffix) + "},";
        StringBuilder sb = new StringBuilder();
        sb.append("\\\"task\\\":{");
        sb.append(" \\\"type\\\":\\\"");
        sb.append(curCommponentName);
        sb.append("\\\",");
        sb.append(" \\\"index\\\":");
        sb.append('$');
        sb.append("_TASK_INDEX},");
        String task = sb.toString();
        String environment = "\\\"environment\\\":\\\"cloud\\\"}";
        sb = new StringBuilder();
        sb.append(json);
        sb.append(master);
        sb.append(worker);
        sb.append(ps);
        sb.append(task);
        sb.append(environment);
        return sb.toString();
    }

    public static void addQuicklink(Service serviceSpec, String label, String link) {
        HashMap<String, String> quicklinks = serviceSpec.getQuicklinks();
        if (null == quicklinks) {
            quicklinks = new HashMap<String, String>();
            serviceSpec.setQuicklinks(quicklinks);
        }
        if (SubmarineLogs.isVerbose()) {
            LOG.info("Added quicklink, " + label + "=" + link);
        }
        quicklinks.put(label, link);
    }

    private static String getComponentArrayJson(String componentName, int count, String endpointSuffix) {
        String component = "\\\"" + componentName + "\\\":";
        StringBuilder array = new StringBuilder();
        array.append("[");
        for (int i = 0; i < count; ++i) {
            array.append("\\\"");
            array.append(componentName);
            array.append("-");
            array.append(i);
            array.append(endpointSuffix);
            array.append("\\\"");
            if (i == count - 1) continue;
            array.append(",");
        }
        array.append("]");
        return component + array.toString();
    }
}

