/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.api.AppAdminClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.ServiceApiConstants;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.KerberosPrincipal;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.ResourceInformation;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.submarine.client.cli.param.Localization;
import org.apache.hadoop.yarn.submarine.client.cli.param.Quicklink;
import org.apache.hadoop.yarn.submarine.client.cli.param.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.api.TaskType;
import org.apache.hadoop.yarn.submarine.common.conf.SubmarineLogs;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobSubmitter;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.YarnServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnServiceJobSubmitter
implements JobSubmitter {
    public static final String TENSORBOARD_QUICKLINK_LABEL = "Tensorboard";
    private static final Logger LOG = LoggerFactory.getLogger(YarnServiceJobSubmitter.class);
    ClientContext clientContext;
    Service serviceSpec;
    private Set<Path> uploadedFiles = new HashSet<Path>();
    private Map<String, String> componentToLocalLaunchScriptPath = new HashMap<String, String>();

    public YarnServiceJobSubmitter(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    private Resource getServiceResourceFromYarnResource(org.apache.hadoop.yarn.api.records.Resource yarnResource) {
        Resource serviceResource = new Resource();
        serviceResource.setCpus(Integer.valueOf(yarnResource.getVirtualCores()));
        serviceResource.setMemory(String.valueOf(yarnResource.getMemorySize()));
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        for (org.apache.hadoop.yarn.api.records.ResourceInformation ri : yarnResource.getAllResourcesListCopy()) {
            ResourceInformation serviceRi = new ResourceInformation();
            serviceRi.setValue(Long.valueOf(ri.getValue()));
            serviceRi.setUnit(ri.getUnits());
            riMap.put(ri.getName(), serviceRi);
        }
        serviceResource.setResourceInformations(riMap);
        return serviceResource;
    }

    private String getValueOfEnvionment(String envar) {
        if (envar == null || !envar.contains("=")) {
            return "";
        }
        return envar.substring(envar.indexOf("=") + 1);
    }

    private boolean needHdfs(String content) {
        return content != null && content.contains("hdfs://");
    }

    private void addHdfsClassPathIfNeeded(RunJobParameters parameters, PrintWriter fw, Component comp) throws IOException {
        String hdfsHome = null;
        String javaHome = null;
        boolean hadoopEnv = false;
        for (String envar : parameters.getEnvars()) {
            if (envar.startsWith("DOCKER_HADOOP_HDFS_HOME=")) {
                hdfsHome = this.getValueOfEnvionment(envar);
                hadoopEnv = true;
                continue;
            }
            if (!envar.startsWith("DOCKER_JAVA_HOME=")) continue;
            javaHome = this.getValueOfEnvionment(envar);
        }
        boolean lackingEnvs = false;
        if (this.needHdfs(parameters.getInputPath()) || this.needHdfs(parameters.getPSLaunchCmd()) || this.needHdfs(parameters.getWorkerLaunchCmd()) || hadoopEnv) {
            if (hdfsHome != null) {
                fw.append("export HADOOP_HOME=\n");
                fw.append("export HADOOP_YARN_HOME=\n");
                fw.append("export HADOOP_HDFS_HOME=" + hdfsHome + "\n");
                fw.append("export HADOOP_COMMON_HOME=" + hdfsHome + "\n");
            } else {
                lackingEnvs = true;
            }
            fw.append("export HADOOP_CONF_DIR=$WORK_DIR\n");
            if (javaHome != null) {
                fw.append("export JAVA_HOME=" + javaHome + "\n");
                fw.append("export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$JAVA_HOME/lib/amd64/server\n");
            } else {
                lackingEnvs = true;
            }
            fw.append("export CLASSPATH=`$HADOOP_HDFS_HOME/bin/hadoop classpath --glob`\n");
        }
        if (lackingEnvs) {
            LOG.error("When hdfs is being used to read/write models/data. Followingenvs are required: 1) DOCKER_HADOOP_HDFS_HOME=<HDFS_HOME insidedocker container> 2) DOCKER_JAVA_HOME=<JAVA_HOME inside dockercontainer>. You can use --env to pass these envars.");
            throw new IOException("Failed to detect HDFS-related environments.");
        }
        Path stagingDir = this.clientContext.getRemoteDirectoryManager().getJobStagingArea(parameters.getName(), true);
        File coreSite = this.findFileOnClassPath("core-site.xml");
        File hdfsSite = this.findFileOnClassPath("hdfs-site.xml");
        if (coreSite == null || hdfsSite == null) {
            LOG.error("hdfs is being used, however we couldn't locate core-site.xml/hdfs-site.xml from classpath, please double check you classpathsetting and make sure they're included.");
            throw new IOException("Failed to locate core-site.xml / hdfs-site.xml from class path");
        }
        this.uploadToRemoteFileAndLocalizeToContainerWorkDir(stagingDir, coreSite.getAbsolutePath(), "core-site.xml", comp);
        this.uploadToRemoteFileAndLocalizeToContainerWorkDir(stagingDir, hdfsSite.getAbsolutePath(), "hdfs-site.xml", comp);
        if (SubmarineLogs.isVerbose()) {
            fw.append("echo \"CLASSPATH:$CLASSPATH\"\n");
            fw.append("echo \"HADOOP_CONF_DIR:$HADOOP_CONF_DIR\"\n");
            fw.append("echo \"HADOOP_TOKEN_FILE_LOCATION:$HADOOP_TOKEN_FILE_LOCATION\"\n");
            fw.append("echo \"JAVA_HOME:$JAVA_HOME\"\n");
            fw.append("echo \"LD_LIBRARY_PATH:$LD_LIBRARY_PATH\"\n");
            fw.append("echo \"HADOOP_HDFS_HOME:$HADOOP_HDFS_HOME\"\n");
        }
    }

    private void addCommonEnvironments(Component component, TaskType taskType) {
        Map envs = component.getConfiguration().getEnv();
        envs.put("_TASK_INDEX", ServiceApiConstants.COMPONENT_ID);
        envs.put("_TASK_TYPE", taskType.name());
    }

    @VisibleForTesting
    protected String getUserName() {
        return System.getProperty("user.name");
    }

    private String getDNSDomain() {
        return this.clientContext.getYarnConfig().get("hadoop.registry.dns.domain-name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateCommandLaunchScript(RunJobParameters parameters, TaskType taskType, Component comp) throws IOException {
        File file = File.createTempFile(taskType.name() + "-launch-script", ".sh");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try (PrintWriter pw = new PrintWriter(w);){
            pw.append("#!/bin/bash\n");
            this.addHdfsClassPathIfNeeded(parameters, pw, comp);
            if (taskType.equals((Object)TaskType.TENSORBOARD)) {
                String tbCommand = "export LC_ALL=C && tensorboard --logdir=" + parameters.getCheckpointPath();
                pw.append(tbCommand + "\n");
                LOG.info("Tensorboard command=" + tbCommand);
            } else {
                if (parameters.isDistributed()) {
                    String tfConfigEnv = YarnServiceUtils.getTFConfigEnv(taskType.getComponentName(), parameters.getNumWorkers(), parameters.getNumPS(), parameters.getName(), this.getUserName(), this.getDNSDomain());
                    pw.append("export TF_CONFIG=\"" + tfConfigEnv + "\"\n");
                }
                if (taskType.equals((Object)TaskType.WORKER) || taskType.equals((Object)TaskType.PRIMARY_WORKER)) {
                    pw.append(parameters.getWorkerLaunchCmd() + '\n');
                    if (SubmarineLogs.isVerbose()) {
                        LOG.info("Worker command =[" + parameters.getWorkerLaunchCmd() + "]");
                    }
                } else if (taskType.equals((Object)TaskType.PS)) {
                    pw.append(parameters.getPSLaunchCmd() + '\n');
                    if (SubmarineLogs.isVerbose()) {
                        LOG.info("PS command =[" + parameters.getPSLaunchCmd() + "]");
                    }
                }
            }
        }
        return file.getAbsolutePath();
    }

    private String getScriptFileName(TaskType taskType) {
        return "run-" + taskType.name() + ".sh";
    }

    private File findFileOnClassPath(String fileName) {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classpath, pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            File target;
            String pathElement = tokenizer.nextToken();
            File directoryOrJar = new File(pathElement);
            File absoluteDirectoryOrJar = directoryOrJar.getAbsoluteFile();
            if (!(absoluteDirectoryOrJar.isFile() ? (target = new File(absoluteDirectoryOrJar.getParent(), fileName)).exists() : (target = new File(directoryOrJar, fileName)).exists())) continue;
            return target;
        }
        return null;
    }

    private void uploadToRemoteFileAndLocalizeToContainerWorkDir(Path stagingDir, String fileToUpload, String destFilename, Component comp) throws IOException {
        Path uploadedFilePath = this.uploadToRemoteFile(stagingDir, fileToUpload);
        this.locateRemoteFileToContainerWorkDir(destFilename, comp, uploadedFilePath);
    }

    private void locateRemoteFileToContainerWorkDir(String destFilename, Component comp, Path uploadedFilePath) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.clientContext.getYarnConfig());
        FileStatus fileStatus = fs.getFileStatus(uploadedFilePath);
        LOG.info("Uploaded file path = " + fileStatus.getPath());
        comp.getConfiguration().getFiles().add(new ConfigFile().srcFile(fileStatus.getPath().toUri().toString()).destFile(destFilename).type(ConfigFile.TypeEnum.STATIC));
    }

    private Path uploadToRemoteFile(Path stagingDir, String fileToUpload) throws IOException {
        FileSystem fs = this.clientContext.getRemoteDirectoryManager().getDefaultFileSystem();
        File localFile = new File(fileToUpload);
        if (!localFile.exists()) {
            throw new FileNotFoundException("Trying to upload file=" + localFile.getAbsolutePath() + " to remote, but couldn't find local file.");
        }
        String filename = new File(fileToUpload).getName();
        Path uploadedFilePath = new Path(stagingDir, filename);
        if (!this.uploadedFiles.contains(uploadedFilePath)) {
            if (SubmarineLogs.isVerbose()) {
                LOG.info("Copying local file=" + fileToUpload + " to remote=" + uploadedFilePath);
            }
            fs.copyFromLocalFile(new Path(fileToUpload), uploadedFilePath);
            this.uploadedFiles.add(uploadedFilePath);
        }
        return uploadedFilePath;
    }

    private void setPermission(Path destPath, FsPermission permission) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.clientContext.getYarnConfig());
        fs.setPermission(destPath, new FsPermission(permission));
    }

    private void handleLaunchCommand(RunJobParameters parameters, TaskType taskType, Component component) throws IOException {
        Path stagingDir = this.clientContext.getRemoteDirectoryManager().getJobStagingArea(parameters.getName(), true);
        String localScriptFile = this.generateCommandLaunchScript(parameters, taskType, component);
        String destScriptFileName = this.getScriptFileName(taskType);
        this.uploadToRemoteFileAndLocalizeToContainerWorkDir(stagingDir, localScriptFile, destScriptFileName, component);
        component.setLaunchCommand("./" + destScriptFileName);
        this.componentToLocalLaunchScriptPath.put(taskType.getComponentName(), localScriptFile);
    }

    private String getLastNameFromPath(String srcFileStr) {
        return new Path(srcFileStr).getName();
    }

    private String mayDownloadAndZipIt(String remoteDir, String zipFileName, boolean doZip) throws IOException {
        String suffix;
        RemoteDirectoryManager rdm = this.clientContext.getRemoteDirectoryManager();
        String srcDir = remoteDir;
        String zipDirPath = System.getProperty("java.io.tmpdir") + "/" + zipFileName;
        boolean needDeleteTempDir = false;
        if (rdm.isRemote(remoteDir)) {
            FileStatus status = rdm.getRemoteFileStatus(new Path(remoteDir));
            suffix = "_" + status.getModificationTime() + "-" + rdm.getRemoteFileSize(remoteDir);
            boolean downloaded = rdm.copyRemoteToLocal(remoteDir, zipDirPath);
            if (!downloaded) {
                throw new IOException("Failed to download files from " + remoteDir);
            }
            LOG.info("Downloaded remote: {} to local: {}", (Object)remoteDir, (Object)zipDirPath);
            srcDir = zipDirPath;
            needDeleteTempDir = true;
        } else {
            File localDir = new File(remoteDir);
            suffix = "_" + localDir.lastModified() + "-" + localDir.length();
        }
        if (!doZip) {
            return srcDir;
        }
        String zipFileUri = this.zipDir(srcDir, zipDirPath + suffix + ".zip");
        if (needDeleteTempDir) {
            this.deleteFiles(srcDir);
        }
        return zipFileUri;
    }

    @VisibleForTesting
    public String zipDir(String srcDir, String dstFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(dstFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        File srcFile = new File(srcDir);
        LOG.info("Compressing {}", (Object)srcDir);
        this.addDirToZip(zos, srcFile, srcFile);
        zos.close();
        LOG.info("Compressed {} to {}", (Object)srcDir, (Object)dstFile);
        return dstFile;
    }

    private void deleteFiles(String localUri) {
        boolean success = FileUtil.fullyDelete((File)new File(localUri));
        if (!success) {
            LOG.warn("Fail to delete {}", (Object)localUri);
        }
        LOG.info("Deleted {}", (Object)localUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirToZip(ZipOutputStream zos, File srcFile, File base) throws IOException {
        File[] files = srcFile.listFiles();
        if (null == files) {
            return;
        }
        FileInputStream fis = null;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addDirToZip(zos, files[i], base);
                continue;
            }
            byte[] buffer = new byte[1024];
            try {
                int length;
                fis = new FileInputStream(files[i]);
                String name = base.toURI().relativize(files[i].toURI()).getPath();
                LOG.info(" Zip adding: " + name);
                zos.putNextEntry(new ZipEntry(name));
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.flush();
                continue;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                zos.closeEntry();
            }
        }
    }

    private void addWorkerComponent(Service service, RunJobParameters parameters, TaskType taskType) throws IOException {
        Component workerComponent = new Component();
        this.addCommonEnvironments(workerComponent, taskType);
        workerComponent.setName(taskType.getComponentName());
        if (taskType.equals((Object)TaskType.PRIMARY_WORKER)) {
            workerComponent.setNumberOfContainers(Long.valueOf(1L));
        } else {
            workerComponent.setNumberOfContainers(Long.valueOf((long)parameters.getNumWorkers() - 1L));
        }
        if (parameters.getWorkerDockerImage() != null) {
            workerComponent.setArtifact(this.getDockerArtifact(parameters.getWorkerDockerImage()));
        }
        workerComponent.setResource(this.getServiceResourceFromYarnResource(parameters.getWorkerResource()));
        this.handleLaunchCommand(parameters, taskType, workerComponent);
        workerComponent.setRestartPolicy(Component.RestartPolicyEnum.NEVER);
        service.addComponent(workerComponent);
    }

    private void addWorkerComponents(Service service, RunJobParameters parameters) throws IOException {
        this.addWorkerComponent(service, parameters, TaskType.PRIMARY_WORKER);
        if (parameters.getNumWorkers() > 1) {
            this.addWorkerComponent(service, parameters, TaskType.WORKER);
        }
    }

    private void appendToEnv(Service service, String key, String value, String delim) {
        Map env = service.getConfiguration().getEnv();
        if (!env.containsKey(key)) {
            env.put(key, value);
        } else if (!value.isEmpty()) {
            String existingValue = (String)env.get(key);
            if (!existingValue.endsWith(delim)) {
                env.put(key, existingValue + delim + value);
            } else {
                env.put(key, existingValue + value);
            }
        }
    }

    private void handleServiceEnvs(Service service, RunJobParameters parameters) {
        if (parameters.getEnvars() != null) {
            for (String envarPair : parameters.getEnvars()) {
                String value;
                String key;
                if (envarPair.contains("=")) {
                    int idx = envarPair.indexOf(61);
                    key = envarPair.substring(0, idx);
                    value = envarPair.substring(idx + 1);
                } else {
                    key = envarPair;
                    value = "";
                }
                this.appendToEnv(service, key, value, ":");
            }
        }
        this.appendToEnv(service, "YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS", "/etc/passwd:/etc/passwd:ro", ",");
        String authenication = this.clientContext.getYarnConfig().get("hadoop.security.authentication");
        if (authenication != null && authenication.equals("kerberos")) {
            this.appendToEnv(service, "YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS", "/etc/krb5.conf:/etc/krb5.conf:ro", ",");
        }
    }

    private Artifact getDockerArtifact(String dockerImageName) {
        return new Artifact().type(Artifact.TypeEnum.DOCKER).id(dockerImageName);
    }

    private void handleQuicklinks(RunJobParameters runJobParameters) throws IOException {
        List<Quicklink> quicklinks = runJobParameters.getQuicklinks();
        if (null != quicklinks && !quicklinks.isEmpty()) {
            for (Quicklink ql : quicklinks) {
                String instanceName = ql.getComponentInstanceName();
                boolean found = false;
                block1: for (Component comp : this.serviceSpec.getComponents()) {
                    int i = 0;
                    while ((long)i < comp.getNumberOfContainers()) {
                        String possibleInstanceName = comp.getName() + "-" + i;
                        if (possibleInstanceName.equals(instanceName)) {
                            found = true;
                            continue block1;
                        }
                        ++i;
                    }
                }
                if (!found) {
                    throw new IOException("Couldn't find a component instance = " + instanceName + " while adding quicklink");
                }
                String link = ql.getProtocol() + YarnServiceUtils.getDNSName(this.serviceSpec.getName(), instanceName, this.getUserName(), this.getDNSDomain(), ql.getPort());
                YarnServiceUtils.addQuicklink(this.serviceSpec, ql.getLabel(), link);
            }
        }
    }

    private Service createServiceByParameters(RunJobParameters parameters) throws IOException {
        this.componentToLocalLaunchScriptPath.clear();
        this.serviceSpec = new Service();
        this.serviceSpec.setName(parameters.getName());
        this.serviceSpec.setVersion(String.valueOf(System.currentTimeMillis()));
        this.serviceSpec.setArtifact(this.getDockerArtifact(parameters.getDockerImageName()));
        this.handleKerberosPrincipal(parameters);
        this.handleServiceEnvs(this.serviceSpec, parameters);
        this.handleLocalizations(parameters);
        if (parameters.getNumWorkers() > 0) {
            this.addWorkerComponents(this.serviceSpec, parameters);
        }
        if (parameters.getNumPS() > 0) {
            Component psComponent = new Component();
            psComponent.setName(TaskType.PS.getComponentName());
            this.addCommonEnvironments(psComponent, TaskType.PS);
            psComponent.setNumberOfContainers(Long.valueOf(parameters.getNumPS()));
            psComponent.setRestartPolicy(Component.RestartPolicyEnum.NEVER);
            psComponent.setResource(this.getServiceResourceFromYarnResource(parameters.getPsResource()));
            if (parameters.getPsDockerImage() != null) {
                psComponent.setArtifact(this.getDockerArtifact(parameters.getPsDockerImage()));
            }
            this.handleLaunchCommand(parameters, TaskType.PS, psComponent);
            this.serviceSpec.addComponent(psComponent);
        }
        if (parameters.isTensorboardEnabled()) {
            Component tbComponent = new Component();
            tbComponent.setName(TaskType.TENSORBOARD.getComponentName());
            this.addCommonEnvironments(tbComponent, TaskType.TENSORBOARD);
            tbComponent.setNumberOfContainers(Long.valueOf(1L));
            tbComponent.setRestartPolicy(Component.RestartPolicyEnum.NEVER);
            tbComponent.setResource(this.getServiceResourceFromYarnResource(parameters.getTensorboardResource()));
            if (parameters.getTensorboardDockerImage() != null) {
                tbComponent.setArtifact(this.getDockerArtifact(parameters.getTensorboardDockerImage()));
            }
            this.handleLaunchCommand(parameters, TaskType.TENSORBOARD, tbComponent);
            String tensorboardLink = "http://" + YarnServiceUtils.getDNSName(parameters.getName(), TaskType.TENSORBOARD.getComponentName() + "-" + 0, this.getUserName(), this.getDNSDomain(), 6006);
            LOG.info("Link to tensorboard:" + tensorboardLink);
            this.serviceSpec.addComponent(tbComponent);
            YarnServiceUtils.addQuicklink(this.serviceSpec, TENSORBOARD_QUICKLINK_LABEL, tensorboardLink);
        }
        this.handleQuicklinks(parameters);
        return this.serviceSpec;
    }

    private void handleLocalizations(RunJobParameters parameters) throws IOException {
        String remoteUri;
        Path stagingDir = this.clientContext.getRemoteDirectoryManager().getJobStagingArea(parameters.getName(), true);
        List<Localization> locs = parameters.getLocalizations();
        RemoteDirectoryManager rdm = this.clientContext.getRemoteDirectoryManager();
        for (Localization loc : locs) {
            File localFile;
            remoteUri = loc.getRemoteUri();
            Path resourceToLocalize = new Path(remoteUri);
            if (rdm.isRemote(remoteUri) ? !rdm.existsRemoteFile(resourceToLocalize) : !(localFile = new File(remoteUri)).exists()) {
                throw new FileNotFoundException("File " + remoteUri + " doesn't exists.");
            }
            this.validFileSize(remoteUri);
        }
        for (Localization loc : locs) {
            remoteUri = loc.getRemoteUri();
            String containerLocalPath = loc.getLocalPath();
            String srcFileStr = remoteUri;
            ConfigFile.TypeEnum destFileType = ConfigFile.TypeEnum.STATIC;
            Path resourceToLocalize = new Path(remoteUri);
            boolean needUploadToHDFS = true;
            boolean needDeleteTempFile = false;
            if (rdm.isDir(remoteUri)) {
                destFileType = ConfigFile.TypeEnum.ARCHIVE;
                srcFileStr = this.mayDownloadAndZipIt(remoteUri, this.getLastNameFromPath(srcFileStr), true);
            } else if (rdm.isRemote(remoteUri)) {
                if (!this.needHdfs(remoteUri)) {
                    srcFileStr = this.mayDownloadAndZipIt(remoteUri, this.getLastNameFromPath(srcFileStr), false);
                    needDeleteTempFile = true;
                } else {
                    needUploadToHDFS = false;
                }
            }
            if (needUploadToHDFS) {
                resourceToLocalize = this.uploadToRemoteFile(stagingDir, srcFileStr);
            }
            if (needDeleteTempFile) {
                this.deleteFiles(srcFileStr);
            }
            if (destFileType == ConfigFile.TypeEnum.ARCHIVE && srcFileStr.endsWith(".zip")) {
                this.deleteFiles(srcFileStr);
                int suffixIndex = srcFileStr.lastIndexOf(95);
                srcFileStr = srcFileStr.substring(0, suffixIndex);
            }
            if (!containerLocalPath.equals(".") && !containerLocalPath.equals("./")) {
                srcFileStr = this.getLastNameFromPath(containerLocalPath);
            }
            String localizedName = this.getLastNameFromPath(srcFileStr);
            LOG.info("The file/dir to be localized is {}", (Object)resourceToLocalize.toString());
            LOG.info("Its localized file name will be {}", (Object)localizedName);
            this.serviceSpec.getConfiguration().getFiles().add(new ConfigFile().srcFile(resourceToLocalize.toUri().toString()).destFile(localizedName).type(destFileType));
            if (!containerLocalPath.startsWith("/")) continue;
            String mountStr = this.getLastNameFromPath(srcFileStr) + ":" + containerLocalPath + ":" + loc.getMountPermission();
            LOG.info("Add bind-mount string {}", (Object)mountStr);
            this.appendToEnv(this.serviceSpec, "YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS", mountStr, ",");
        }
    }

    private void validFileSize(String uri) throws IOException {
        long actualSizeByte;
        RemoteDirectoryManager rdm = this.clientContext.getRemoteDirectoryManager();
        String locationType = "Local";
        if (rdm.isRemote(uri)) {
            actualSizeByte = this.clientContext.getRemoteDirectoryManager().getRemoteFileSize(uri);
            locationType = "Remote";
        } else {
            actualSizeByte = FileUtil.getDU((File)new File(uri));
        }
        long maxFileSizeMB = this.clientContext.getSubmarineConfig().getLong("submarine.localization.max-allowed-file-size-mb", 2048L);
        LOG.info("{} fie/dir: {}, size(Byte):{}, Allowed max file/dir size: {}", new Object[]{locationType, uri, actualSizeByte, maxFileSizeMB * 1024L * 1024L});
        if (actualSizeByte > maxFileSizeMB * 1024L * 1024L) {
            throw new IOException(uri + " size(Byte): " + actualSizeByte + " exceeds configured max size:" + maxFileSizeMB * 1024L * 1024L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateServiceSpecFile(Service service) throws IOException {
        File serviceSpecFile = File.createTempFile(service.getName(), ".json");
        String buffer = ServiceApiUtil.jsonSerDeser.toJson((Object)service);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(serviceSpecFile), "UTF-8");
        try (PrintWriter pw = new PrintWriter(w);){
            pw.append(buffer);
        }
        return serviceSpecFile.getAbsolutePath();
    }

    private void handleKerberosPrincipal(RunJobParameters parameters) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)parameters.getKeytab()) && StringUtils.isNotBlank((CharSequence)parameters.getPrincipal())) {
            String keytab = parameters.getKeytab();
            String principal = parameters.getPrincipal();
            if (parameters.isDistributeKeytab()) {
                Path stagingDir = this.clientContext.getRemoteDirectoryManager().getJobStagingArea(parameters.getName(), true);
                Path remoteKeytabPath = this.uploadToRemoteFile(stagingDir, keytab);
                this.setPermission(remoteKeytabPath, FsPermission.createImmutable((short)((short)Integer.parseInt("400", 8))));
                this.serviceSpec.setKerberosPrincipal(new KerberosPrincipal().keytab(remoteKeytabPath.toString()).principalName(principal));
            } else {
                if (!keytab.startsWith("file")) {
                    keytab = "file://" + keytab;
                }
                this.serviceSpec.setKerberosPrincipal(new KerberosPrincipal().keytab(keytab).principalName(principal));
            }
        }
    }

    @Override
    public ApplicationId submitJob(RunJobParameters parameters) throws IOException, YarnException {
        this.createServiceByParameters(parameters);
        String serviceSpecFile = this.generateServiceSpecFile(this.serviceSpec);
        AppAdminClient appAdminClient = YarnServiceUtils.createServiceClient(this.clientContext.getYarnConfig());
        int code = appAdminClient.actionLaunch(serviceSpecFile, this.serviceSpec.getName(), null, null);
        if (code != 0) {
            throw new YarnException("Fail to launch application with exit code:" + code);
        }
        String appStatus = appAdminClient.getStatusString(this.serviceSpec.getName());
        Service app = (Service)ServiceApiUtil.jsonSerDeser.fromJson(appStatus);
        int maxRetryTimes = 30;
        for (int count = 0; app.getId() == null && count < maxRetryTimes; ++count) {
            LOG.info("Waiting for application Id. AppStatusString=\n {}", (Object)appStatus);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            appStatus = appAdminClient.getStatusString(this.serviceSpec.getName());
            app = (Service)ServiceApiUtil.jsonSerDeser.fromJson(appStatus);
        }
        if (app.getId() == null) {
            throw new YarnException("Can't get application id for Service " + this.serviceSpec.getName());
        }
        ApplicationId appid = ApplicationId.fromString((String)app.getId());
        appAdminClient.stop();
        return appid;
    }

    @VisibleForTesting
    public Service getServiceSpec() {
        return this.serviceSpec;
    }

    @VisibleForTesting
    public Map<String, String> getComponentToLocalLaunchScriptPath() {
        return this.componentToLocalLaunchScriptPath;
    }
}

