/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli.param;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.param.BaseParameters;
import org.apache.hadoop.yarn.submarine.common.ClientContext;

public abstract class RunParameters
extends BaseParameters {
    private String savedModelPath;
    private String dockerImageName;
    private List<String> envars = new ArrayList<String>();
    private String queue;

    @Override
    public void updateParametersByParsedCommandline(CommandLine parsedCommandLine, Options options, ClientContext clientContext) throws ParseException, IOException, YarnException {
        String savedModelPath = parsedCommandLine.getOptionValue("saved_model_path");
        this.setSavedModelPath(savedModelPath);
        ArrayList<String> envarsList = new ArrayList<String>();
        String[] envars = parsedCommandLine.getOptionValues("env");
        if (envars != null) {
            for (String envar : envars) {
                envarsList.add(envar);
            }
        }
        this.setEnvars(envarsList);
        String queue = parsedCommandLine.getOptionValue("queue");
        this.setQueue(queue);
        String dockerImage = parsedCommandLine.getOptionValue("docker_image");
        this.setDockerImageName(dockerImage);
        super.updateParametersByParsedCommandline(parsedCommandLine, options, clientContext);
    }

    public String getQueue() {
        return this.queue;
    }

    public RunParameters setQueue(String queue) {
        this.queue = queue;
        return this;
    }

    public String getDockerImageName() {
        return this.dockerImageName;
    }

    public RunParameters setDockerImageName(String dockerImageName) {
        this.dockerImageName = dockerImageName;
        return this;
    }

    public List<String> getEnvars() {
        return this.envars;
    }

    public RunParameters setEnvars(List<String> envars) {
        this.envars = envars;
        return this;
    }

    public String getSavedModelPath() {
        return this.savedModelPath;
    }

    public RunParameters setSavedModelPath(String savedModelPath) {
        this.savedModelPath = savedModelPath;
        return this;
    }
}

