/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli.param;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.CliUtils;
import org.apache.hadoop.yarn.submarine.client.cli.param.Localization;
import org.apache.hadoop.yarn.submarine.client.cli.param.Quicklink;
import org.apache.hadoop.yarn.submarine.client.cli.param.RunParameters;
import org.apache.hadoop.yarn.submarine.common.ClientContext;

public class RunJobParameters
extends RunParameters {
    private String input;
    private String checkpointPath;
    private int numWorkers;
    private int numPS;
    private Resource workerResource;
    private Resource psResource;
    private boolean tensorboardEnabled;
    private Resource tensorboardResource;
    private String tensorboardDockerImage;
    private String workerLaunchCmd;
    private String psLaunchCmd;
    private List<Quicklink> quicklinks = new ArrayList<Quicklink>();
    private List<Localization> localizations = new ArrayList<Localization>();
    private String psDockerImage = null;
    private String workerDockerImage = null;
    private boolean waitJobFinish = false;
    private boolean distributed = false;
    private String keytab;
    private String principal;
    private boolean distributeKeytab = false;

    @Override
    public void updateParametersByParsedCommandline(CommandLine parsedCommandLine, Options options, ClientContext clientContext) throws ParseException, IOException, YarnException {
        String[] quicklinkStrs;
        String input = parsedCommandLine.getOptionValue("input_path");
        String jobDir = parsedCommandLine.getOptionValue("checkpoint_path");
        int nWorkers = 1;
        if (parsedCommandLine.getOptionValue("num_workers") != null) {
            nWorkers = Integer.parseInt(parsedCommandLine.getOptionValue("num_workers"));
            if (null == input && 0 != nWorkers) {
                throw new ParseException("\"--input_path\" is absent");
            }
        }
        int nPS = 0;
        if (parsedCommandLine.getOptionValue("num_ps") != null) {
            nPS = Integer.parseInt(parsedCommandLine.getOptionValue("num_ps"));
        }
        if (nWorkers >= 2 && nPS > 0) {
            this.distributed = true;
        } else if (nWorkers <= 1 && nPS > 0) {
            throw new ParseException("Only specified one worker but non-zero PS, please double check.");
        }
        String kerberosKeytab = parsedCommandLine.getOptionValue("keytab");
        String kerberosPrincipal = parsedCommandLine.getOptionValue("principal");
        CliUtils.doLoginIfSecure(kerberosKeytab, kerberosPrincipal);
        this.workerResource = null;
        if (nWorkers > 0) {
            String workerResourceStr = parsedCommandLine.getOptionValue("worker_resources");
            if (workerResourceStr == null) {
                throw new ParseException("--worker_resources is absent.");
            }
            this.workerResource = CliUtils.createResourceFromString(workerResourceStr, clientContext.getOrCreateYarnClient().getResourceTypeInfo());
        }
        Resource psResource = null;
        if (nPS > 0) {
            String psResourceStr = parsedCommandLine.getOptionValue("ps_resources");
            if (psResourceStr == null) {
                throw new ParseException("--ps_resources is absent.");
            }
            psResource = CliUtils.createResourceFromString(psResourceStr, clientContext.getOrCreateYarnClient().getResourceTypeInfo());
        }
        boolean tensorboard = false;
        if (parsedCommandLine.hasOption("tensorboard")) {
            tensorboard = true;
            String tensorboardResourceStr = parsedCommandLine.getOptionValue("tensorboard_resources");
            if (tensorboardResourceStr == null || tensorboardResourceStr.isEmpty()) {
                tensorboardResourceStr = "memory=4G,vcores=1";
            }
            this.tensorboardResource = CliUtils.createResourceFromString(tensorboardResourceStr, clientContext.getOrCreateYarnClient().getResourceTypeInfo());
            this.tensorboardDockerImage = parsedCommandLine.getOptionValue("tensorboard_docker_image");
            this.setTensorboardResource(this.tensorboardResource);
        }
        if (parsedCommandLine.hasOption("wait_job_finish")) {
            this.waitJobFinish = true;
        }
        if ((quicklinkStrs = parsedCommandLine.getOptionValues("quicklink")) != null) {
            for (String string : quicklinkStrs) {
                Quicklink quicklink = new Quicklink();
                quicklink.parse(string);
                this.quicklinks.add(quicklink);
            }
        }
        this.psDockerImage = parsedCommandLine.getOptionValue("ps_docker_image");
        this.workerDockerImage = parsedCommandLine.getOptionValue("worker_docker_image");
        String workerLaunchCmd = parsedCommandLine.getOptionValue("worker_launch_cmd");
        String psLaunchCommand = parsedCommandLine.getOptionValue("ps_launch_cmd");
        String[] localizationsStr = parsedCommandLine.getOptionValues("localization");
        if (null != localizationsStr) {
            for (String loc : localizationsStr) {
                Localization localization = new Localization();
                localization.parse(loc);
                this.localizations.add(localization);
            }
        }
        boolean bl = parsedCommandLine.hasOption("distribute_keytab");
        this.setInputPath(input).setCheckpointPath(jobDir).setNumPS(nPS).setNumWorkers(nWorkers).setPSLaunchCmd(psLaunchCommand).setWorkerLaunchCmd(workerLaunchCmd).setPsResource(psResource).setTensorboardEnabled(tensorboard).setKeytab(kerberosKeytab).setPrincipal(kerberosPrincipal).setDistributeKeytab(bl);
        super.updateParametersByParsedCommandline(parsedCommandLine, options, clientContext);
    }

    public String getInputPath() {
        return this.input;
    }

    public RunJobParameters setInputPath(String input) {
        this.input = input;
        return this;
    }

    public String getCheckpointPath() {
        return this.checkpointPath;
    }

    public RunJobParameters setCheckpointPath(String checkpointPath) {
        this.checkpointPath = checkpointPath;
        return this;
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public RunJobParameters setNumWorkers(int numWorkers) {
        this.numWorkers = numWorkers;
        return this;
    }

    public int getNumPS() {
        return this.numPS;
    }

    public RunJobParameters setNumPS(int numPS) {
        this.numPS = numPS;
        return this;
    }

    public Resource getWorkerResource() {
        return this.workerResource;
    }

    public RunJobParameters setWorkerResource(Resource workerResource) {
        this.workerResource = workerResource;
        return this;
    }

    public Resource getPsResource() {
        return this.psResource;
    }

    public RunJobParameters setPsResource(Resource psResource) {
        this.psResource = psResource;
        return this;
    }

    public boolean isTensorboardEnabled() {
        return this.tensorboardEnabled;
    }

    public RunJobParameters setTensorboardEnabled(boolean tensorboardEnabled) {
        this.tensorboardEnabled = tensorboardEnabled;
        return this;
    }

    public String getWorkerLaunchCmd() {
        return this.workerLaunchCmd;
    }

    public RunJobParameters setWorkerLaunchCmd(String workerLaunchCmd) {
        this.workerLaunchCmd = workerLaunchCmd;
        return this;
    }

    public String getPSLaunchCmd() {
        return this.psLaunchCmd;
    }

    public RunJobParameters setPSLaunchCmd(String psLaunchCmd) {
        this.psLaunchCmd = psLaunchCmd;
        return this;
    }

    public boolean isWaitJobFinish() {
        return this.waitJobFinish;
    }

    public String getPsDockerImage() {
        return this.psDockerImage;
    }

    public String getWorkerDockerImage() {
        return this.workerDockerImage;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public Resource getTensorboardResource() {
        return this.tensorboardResource;
    }

    public void setTensorboardResource(Resource tensorboardResource) {
        this.tensorboardResource = tensorboardResource;
    }

    public String getTensorboardDockerImage() {
        return this.tensorboardDockerImage;
    }

    public List<Quicklink> getQuicklinks() {
        return this.quicklinks;
    }

    public List<Localization> getLocalizations() {
        return this.localizations;
    }

    public String getKeytab() {
        return this.keytab;
    }

    public RunJobParameters setKeytab(String kerberosKeytab) {
        this.keytab = kerberosKeytab;
        return this;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public RunJobParameters setPrincipal(String kerberosPrincipal) {
        this.principal = kerberosPrincipal;
        return this;
    }

    public boolean isDistributeKeytab() {
        return this.distributeKeytab;
    }

    public RunJobParameters setDistributeKeytab(boolean distributeKerberosKeytab) {
        this.distributeKeytab = distributeKerberosKeytab;
        return this;
    }
}

