/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli.param;

import org.apache.commons.cli.ParseException;

public class Quicklink {
    private String label;
    private String componentInstanceName;
    private String protocol;
    private int port;

    public void parse(String quicklinkStr) throws ParseException {
        if (!quicklinkStr.contains("=")) {
            throw new ParseException("Should be <label>=<link> format for quicklink");
        }
        int index = quicklinkStr.indexOf("=");
        this.label = quicklinkStr.substring(0, index);
        if ((quicklinkStr = quicklinkStr.substring(index + 1)).startsWith("http://")) {
            this.protocol = "http://";
        } else if (quicklinkStr.startsWith("https://")) {
            this.protocol = "https://";
        } else {
            throw new ParseException("Quicklink should start with http or https");
        }
        quicklinkStr = quicklinkStr.substring(this.protocol.length());
        index = quicklinkStr.indexOf(":");
        if (index == -1) {
            throw new ParseException("Quicklink should be componet-id:port form");
        }
        this.componentInstanceName = quicklinkStr.substring(0, index);
        this.port = Integer.parseInt(quicklinkStr.substring(index + 1));
    }

    public String getLabel() {
        return this.label;
    }

    public String getComponentInstanceName() {
        return this.componentInstanceName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }
}

