/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.service.exceptions.BadConfigException;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;

public class ZookeeperUtils {
    public static final int DEFAULT_PORT = 2181;

    public static String buildConnectionString(String zkHosts, int port) {
        String zkPort = Integer.toString(port);
        String[] hostlist = zkHosts.split(",", 0);
        String quorum = ServiceUtils.join(hostlist, ":" + zkPort + ",", false);
        return quorum;
    }

    public static List<String> splitToPairs(String hostPortQuorumList) {
        String[] strings = StringUtils.getStrings((String)hostPortQuorumList);
        int len = 0;
        if (strings != null) {
            len = strings.length;
        }
        ArrayList<String> tuples = new ArrayList<String>(len);
        if (strings != null) {
            for (String s : strings) {
                tuples.add(s.trim());
            }
        }
        return tuples;
    }

    public static List<HostAndPort> splitToHostsAndPorts(String hostPortQuorumList) {
        String[] strings = StringUtils.getStrings((String)hostPortQuorumList);
        int len = 0;
        if (strings != null) {
            len = strings.length;
        }
        ArrayList<HostAndPort> list = new ArrayList<HostAndPort>(len);
        if (strings != null) {
            for (String s : strings) {
                list.add(HostAndPort.fromString((String)s.trim()).withDefaultPort(2181));
            }
        }
        return list;
    }

    public static String buildHostsOnlyList(List<HostAndPort> hostAndPorts) {
        StringBuilder sb = new StringBuilder();
        for (HostAndPort hostAndPort : hostAndPorts) {
            sb.append(hostAndPort.getHost()).append(",");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public static String buildQuorumEntry(HostAndPort hostAndPort, int defaultPort) {
        String s = hostAndPort.toString();
        if (hostAndPort.hasPort()) {
            return s;
        }
        return s + ":" + defaultPort;
    }

    public static String buildQuorum(List<HostAndPort> hostAndPorts, int defaultPort) {
        ArrayList<String> entries = new ArrayList<String>(hostAndPorts.size());
        for (HostAndPort hostAndPort : hostAndPorts) {
            entries.add(ZookeeperUtils.buildQuorumEntry(hostAndPort, defaultPort));
        }
        return ServiceUtils.join(entries, ",", false);
    }

    public static String convertToHostsOnlyList(String quorum) throws BadConfigException {
        List<HostAndPort> hostAndPorts = ZookeeperUtils.splitToHostsAndPortsStrictly(quorum);
        return ZookeeperUtils.buildHostsOnlyList(hostAndPorts);
    }

    public static List<HostAndPort> splitToHostsAndPortsStrictly(String quorum) throws BadConfigException {
        List<HostAndPort> hostAndPorts = ZookeeperUtils.splitToHostsAndPorts(quorum);
        if (hostAndPorts.isEmpty()) {
            throw new BadConfigException("empty zookeeper quorum");
        }
        return hostAndPorts;
    }

    public static int getFirstPort(String quorum, int defVal) throws BadConfigException {
        List<HostAndPort> hostAndPorts = ZookeeperUtils.splitToHostsAndPortsStrictly(quorum);
        int port = hostAndPorts.get(0).getPortOrDefault(defVal);
        return port;
    }
}

