/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.records.ConfigFormat;
import org.apache.hadoop.yarn.service.exceptions.BadConfigException;
import org.apache.hadoop.yarn.service.utils.ConfigHelper;
import org.apache.hadoop.yarn.service.utils.PublishedConfigurationOutputter;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class PublishedConfiguration {
    public String description;
    public long updated;
    public String updatedTime;
    public Map<String, String> entries = new HashMap<String, String>();

    public PublishedConfiguration() {
    }

    public PublishedConfiguration(String description) {
        this.description = description;
    }

    public PublishedConfiguration(String description, Iterable<Map.Entry<String, String>> entries) {
        this.description = description;
        this.putValues(entries);
    }

    public PublishedConfiguration(String description, Iterable<Map.Entry<String, String>> keysource, Configuration valuesource) {
        this.description = description;
        this.putValues((Iterable<Map.Entry<String, String>>)ConfigHelper.resolveConfiguration(keysource, valuesource));
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void setUpdated(long updated) {
        this.updated = updated;
        this.updatedTime = new Date(updated).toString();
    }

    public long getUpdated() {
        return this.updated;
    }

    public void putValues(Iterable<Map.Entry<String, String>> entries) {
        this.entries = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : entries) {
            this.entries.put(entry.getKey(), entry.getValue());
        }
    }

    public Configuration asConfiguration() {
        Configuration conf = new Configuration(false);
        try {
            ConfigHelper.addConfigMap(conf, this.entries, "");
        }
        catch (BadConfigException e) {
            throw new RuntimeException(e.toString());
        }
        return conf;
    }

    public String asConfigurationXML() throws IOException {
        return ConfigHelper.toXml(this.asConfiguration());
    }

    public Properties asProperties() {
        Properties props = new Properties();
        props.putAll(this.entries);
        return props;
    }

    public String asJson() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        String json = mapper.writeValueAsString(this.entries);
        return json;
    }

    public PublishedConfiguration shallowCopy() {
        PublishedConfiguration that = new PublishedConfiguration();
        that.description = this.description;
        that.updated = this.updated;
        that.updatedTime = this.updatedTime;
        return that;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PublishedConfiguration{");
        sb.append("description='").append(this.description).append('\'');
        sb.append(" entries = ").append(this.entries.size());
        sb.append('}');
        return sb.toString();
    }

    public PublishedConfigurationOutputter createOutputter(ConfigFormat format) {
        return PublishedConfigurationOutputter.createOutputter(format, this);
    }
}

