/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.containerlaunch;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.service.containerlaunch.CommandLineBuilder;
import org.apache.hadoop.yarn.service.exceptions.BadConfigException;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;

public class JavaCommandLineBuilder
extends CommandLineBuilder {
    public JavaCommandLineBuilder() {
        this.add(this.getJavaBinary());
    }

    protected String getJavaBinary() {
        return ApplicationConstants.Environment.JAVA_HOME.$$() + "/bin/java";
    }

    public void setJVMOpts(String jvmOpts) {
        if (ServiceUtils.isSet(jvmOpts)) {
            this.add(jvmOpts);
        }
    }

    public void enableJavaAssertions() {
        this.add("-ea");
        this.add("-esa");
    }

    public void sysprop(String property, String value) {
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"null property name");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        this.add("-D" + property + "=" + value);
    }

    public JavaCommandLineBuilder forceIPv4() {
        this.sysprop("java.net.preferIPv4Stack", "true");
        return this;
    }

    public JavaCommandLineBuilder headless() {
        this.sysprop("java.awt.headless", "true");
        return this;
    }

    public boolean addConfOption(Configuration conf, String key) {
        return this.defineIfSet(key, conf.get(key));
    }

    public void addConfOptions(Configuration conf, String ... keys) {
        for (String key : keys) {
            this.addConfOption(conf, key);
        }
    }

    public int addPrefixedConfOptions(Configuration conf, String prefix) {
        int copied = 0;
        for (Map.Entry entry : conf) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            this.define((String)entry.getKey(), (String)entry.getValue());
            ++copied;
        }
        return copied;
    }

    public String addConfOptionToCLI(Configuration conf, String key, String defVal) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        String val = conf.get(key, defVal);
        this.define(key, val);
        return val;
    }

    public void define(String key, String val) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        Preconditions.checkArgument((val != null ? 1 : 0) != 0, (Object)"null value");
        this.add("-D", key + "=" + val);
    }

    public boolean defineIfSet(String key, String val) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        if (val != null) {
            this.define(key, val);
            return true;
        }
        return false;
    }

    public void addMandatoryConfOption(Configuration conf, String key) throws BadConfigException {
        if (!this.addConfOption(conf, key)) {
            throw new BadConfigException("Missing configuration option: " + key);
        }
    }
}

