/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.shaded.org.apache.commons.lang3.Range;
import org.apache.hadoop.shaded.org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppsBlock
extends HtmlBlock {
    private static final Logger LOG = LoggerFactory.getLogger(AppsBlock.class);
    protected ApplicationBaseProtocol appBaseProt;
    protected EnumSet<YarnApplicationState> reqAppStates;
    protected UserGroupInformation callerUGI;
    protected Collection<ApplicationReport> appReports;

    @Inject
    protected AppsBlock(ApplicationBaseProtocol appBaseProt, View.ViewContext ctx) {
        super(ctx);
        this.appBaseProt = appBaseProt;
    }

    protected void fetchData() throws YarnException, IOException, InterruptedException {
        this.reqAppStates = EnumSet.noneOf(YarnApplicationState.class);
        String reqStateString = this.$("app.state");
        if (reqStateString != null && !reqStateString.isEmpty()) {
            String[] appStateStrings;
            for (String stateString : appStateStrings = reqStateString.split(",")) {
                this.reqAppStates.add(YarnApplicationState.valueOf((String)stateString.trim()));
            }
        }
        this.callerUGI = this.getCallerUGI();
        final GetApplicationsRequest request = GetApplicationsRequest.newInstance(this.reqAppStates);
        String appsNumStr = this.$("apps.num");
        if (appsNumStr != null && !appsNumStr.isEmpty()) {
            long appsNum = Long.parseLong(appsNumStr);
            request.setLimit(appsNum);
        }
        String appStartedTimeBegainStr = this.$("app.started-time.begin");
        long appStartedTimeBegain = 0L;
        if (appStartedTimeBegainStr != null && !appStartedTimeBegainStr.isEmpty() && (appStartedTimeBegain = Long.parseLong(appStartedTimeBegainStr)) < 0L) {
            throw new BadRequestException("app.started-time.begin must be greater than 0");
        }
        String appStartedTimeEndStr = this.$("app.started-time.end");
        long appStartedTimeEnd = Long.MAX_VALUE;
        if (appStartedTimeEndStr != null && !appStartedTimeEndStr.isEmpty() && (appStartedTimeEnd = Long.parseLong(appStartedTimeEndStr)) < 0L) {
            throw new BadRequestException("app.started-time.end must be greater than 0");
        }
        if (appStartedTimeBegain > appStartedTimeEnd) {
            throw new BadRequestException("app.started-time.end must be greater than app.started-time.begin");
        }
        request.setStartRange(Range.between((Comparable)Long.valueOf(appStartedTimeBegain), (Comparable)Long.valueOf(appStartedTimeEnd)));
        this.appReports = this.callerUGI == null ? this.getApplicationReport(request) : (Collection)this.callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<ApplicationReport>>(){

            @Override
            public Collection<ApplicationReport> run() throws Exception {
                return AppsBlock.this.getApplicationReport(request);
            }
        });
    }

    protected List<ApplicationReport> getApplicationReport(GetApplicationsRequest request) throws YarnException, IOException {
        return this.appBaseProt.getApplications(request).getApplicationList();
    }

    public void render(HtmlBlock.Block html) {
        this.setTitle("Applications");
        try {
            this.fetchData();
        }
        catch (Exception e) {
            String message = "Failed to read the applications.";
            LOG.error(message, (Throwable)e);
            html.p().__(new Object[]{message}).__();
            return;
        }
        this.renderData(html);
    }

    protected void renderData(HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#apps").thead().tr().th(".id", "ID").th(".user", "User").th(".name", "Name").th(".type", "Application Type").th(".queue", "Queue").th(".priority", "Application Priority").th(".starttime", "StartTime").th(".launchtime", "LaunchTime").th(".finishtime", "FinishTime").th(".state", "State").th(".finalstatus", "FinalStatus").th(".progress", "Progress").th(".ui", "Tracking UI").__()).__()).tbody();
        StringBuilder appsTableData = new StringBuilder("[\n");
        for (ApplicationReport appReport : this.appReports) {
            String trackingURL;
            if (!this.reqAppStates.isEmpty() && !this.reqAppStates.contains(appReport.getYarnApplicationState())) continue;
            AppInfo app = new AppInfo(appReport);
            String percent = StringUtils.format((String)"%.1f", (Object[])new Object[]{Float.valueOf(app.getProgress())});
            appsTableData.append("[\"<a href='").append(this.url(new String[]{"app", app.getAppId()})).append("'>").append(app.getAppId()).append("</a>\",\"").append(StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)app.getUser()))).append("\",\"").append(StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)app.getName()))).append("\",\"").append(StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)app.getType()))).append("\",\"").append(StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)app.getQueue()))).append("\",\"").append(String.valueOf(app.getPriority())).append("\",\"").append(app.getStartedTime()).append("\",\"").append(app.getLaunchTime()).append("\",\"").append(app.getFinishedTime()).append("\",\"").append((Object)(app.getAppState() == null ? "N/A" : app.getAppState())).append("\",\"").append(app.getFinalAppStatus()).append("\",\"").append("<br title='").append(percent).append("'> <div class='").append(JQueryUI.C_PROGRESSBAR).append("' title='").append(StringHelper.join((Object[])new Object[]{percent, Character.valueOf('%')})).append("'> ").append("<div class='").append(JQueryUI.C_PROGRESSBAR_VALUE).append("' style='").append(StringHelper.join((Object[])new Object[]{"width:", percent, Character.valueOf('%')})).append("'> </div> </div>").append("\",\"<a ");
            String string = trackingURL = app.getTrackingUrl() == null || app.getTrackingUrl().equals("N/A") ? null : app.getTrackingUrl();
            String trackingUI = app.getTrackingUrl() == null || app.getTrackingUrl().equals("N/A") ? "Unassigned" : (Apps.isApplicationFinalState((YarnApplicationState)app.getAppState()) ? "History" : "ApplicationMaster");
            appsTableData.append(trackingURL == null ? "#" : "href='" + trackingURL).append("'>").append(trackingUI).append("</a>\"],\n");
        }
        if (appsTableData.charAt(appsTableData.length() - 2) == ',') {
            appsTableData.delete(appsTableData.length() - 2, appsTableData.length() - 1);
        }
        appsTableData.append("]");
        html.script().$type("text/javascript").__(new Object[]{"var appsTableData=" + appsTableData}).__();
        ((Hamlet.TABLE)tbody.__()).__();
    }
}

