/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSLeafQueue
extends FSQueue {
    private static final Logger LOG = LoggerFactory.getLogger((String)FSLeafQueue.class.getName());
    private static final List<FSQueue> EMPTY_LIST = Collections.emptyList();
    private FSContext context;
    private final List<FSAppAttempt> runnableApps = new ArrayList<FSAppAttempt>();
    private final List<FSAppAttempt> nonRunnableApps = new ArrayList<FSAppAttempt>();
    private final Set<ApplicationId> assignedApps = new HashSet<ApplicationId>();
    private final ReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private Resource demand = Resources.createResource((int)0);
    private long lastTimeAtMinShare;
    private Resource amResourceUsage;
    private final ActiveUsersManager activeUsersManager;

    public FSLeafQueue(String name, FairScheduler scheduler, FSParentQueue parent) {
        super(name, scheduler, parent);
        this.context = scheduler.getContext();
        this.lastTimeAtMinShare = scheduler.getClock().getTime();
        this.activeUsersManager = new ActiveUsersManager(this.getMetrics());
        this.amResourceUsage = Resource.newInstance((int)0, (int)0);
        this.getMetrics().setAMResourceUsage(this.amResourceUsage);
    }

    void addApp(FSAppAttempt app, boolean runnable) {
        this.writeLock.lock();
        try {
            if (runnable) {
                this.runnableApps.add(app);
            } else {
                this.nonRunnableApps.add(app);
            }
            this.assignedApps.remove(app.getApplicationId());
            this.incUsedResource(app.getResourceUsage());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    boolean removeApp(FSAppAttempt app) {
        boolean runnable = false;
        this.writeLock.lock();
        try {
            runnable = this.runnableApps.remove(app);
            if (!runnable && !this.removeNonRunnableApp(app)) {
                throw new IllegalStateException("Given app to remove " + app + " does not exist in queue " + this);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (runnable && app.isAmRunning()) {
            Resources.subtractFrom((Resource)this.amResourceUsage, (Resource)app.getAMResource());
            this.getMetrics().setAMResourceUsage(this.amResourceUsage);
        }
        this.decUsedResource(app.getResourceUsage());
        return runnable;
    }

    boolean removeNonRunnableApp(FSAppAttempt app) {
        this.writeLock.lock();
        try {
            boolean bl = this.nonRunnableApps.remove(app);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    boolean isRunnableApp(FSAppAttempt attempt) {
        this.readLock.lock();
        try {
            boolean bl = this.runnableApps.contains(attempt);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    boolean isNonRunnableApp(FSAppAttempt attempt) {
        this.readLock.lock();
        try {
            boolean bl = this.nonRunnableApps.contains(attempt);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    List<FSAppAttempt> getCopyOfNonRunnableAppSchedulables() {
        ArrayList<FSAppAttempt> appsToReturn = new ArrayList<FSAppAttempt>();
        this.readLock.lock();
        try {
            appsToReturn.addAll(this.nonRunnableApps);
        }
        finally {
            this.readLock.unlock();
        }
        return appsToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        this.readLock.lock();
        try {
            for (FSAppAttempt appSched : this.runnableApps) {
                apps.add(appSched.getApplicationAttemptId());
            }
            for (FSAppAttempt appSched : this.nonRunnableApps) {
                apps.add(appSched.getApplicationAttemptId());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    void updateInternal() {
        this.readLock.lock();
        try {
            this.policy.computeShares(this.runnableApps, this.getFairShare());
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Resource updateStarvedAppsFairshare(TreeSet<FSAppAttempt> appsWithDemand) {
        FSAppAttempt app;
        Resource appStarvation;
        Resource fairShareStarvation = Resources.clone((Resource)Resources.none());
        Iterator<FSAppAttempt> iterator = appsWithDemand.iterator();
        while (iterator.hasNext() && !Resources.isNone((Resource)(appStarvation = (app = iterator.next()).fairShareStarvation()))) {
            this.context.getStarvedApps().addStarvedApp(app);
            Resources.addTo((Resource)fairShareStarvation, (Resource)appStarvation);
        }
        return fairShareStarvation;
    }

    private void updateStarvedAppsMinshare(TreeSet<FSAppAttempt> appsWithDemand, Resource minShareStarvation) {
        Resource pending = Resources.clone((Resource)minShareStarvation);
        for (FSAppAttempt app : appsWithDemand) {
            if (!Resources.isNone((Resource)pending)) {
                Resource appMinShare = app.getPendingDemand();
                Resources.subtractFromNonNegative((Resource)appMinShare, (Resource)app.getFairshareStarvation());
                if (Resources.greaterThan((ResourceCalculator)this.policy.getResourceCalculator(), (Resource)this.scheduler.getClusterResource(), (Resource)appMinShare, (Resource)pending)) {
                    Resources.subtractFromNonNegative((Resource)appMinShare, (Resource)pending);
                    pending = Resources.none();
                } else {
                    Resources.subtractFromNonNegative((Resource)pending, (Resource)appMinShare);
                }
                app.setMinshareStarvation(appMinShare);
                this.context.getStarvedApps().addStarvedApp(app);
                continue;
            }
            app.resetMinshareStarvation();
        }
    }

    void updateStarvedApps() {
        TreeSet<FSAppAttempt> appsWithDemand = this.fetchAppsWithDemand(false);
        Resource fairShareStarvation = this.updateStarvedAppsFairshare(appsWithDemand);
        Resource minShareStarvation = this.minShareStarvation();
        Resources.subtractFromNonNegative((Resource)minShareStarvation, (Resource)fairShareStarvation);
        this.updateStarvedAppsMinshare(appsWithDemand, minShareStarvation);
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    Resource getAmResourceUsage() {
        return this.amResourceUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDemand() {
        Resource tmpDemand = Resources.createResource((int)0);
        this.readLock.lock();
        try {
            for (FSAppAttempt sched : this.runnableApps) {
                sched.updateDemand();
                Resources.addTo((Resource)tmpDemand, (Resource)sched.getDemand());
            }
            for (FSAppAttempt sched : this.nonRunnableApps) {
                sched.updateDemand();
                Resources.addTo((Resource)tmpDemand, (Resource)sched.getDemand());
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.demand = Resources.componentwiseMin((Resource)tmpDemand, (Resource)this.getMaxShare());
        if (LOG.isDebugEnabled()) {
            LOG.debug("The updated demand for " + this.getName() + " is " + this.demand + "; the max is " + this.getMaxShare());
            LOG.debug("The updated fairshare for " + this.getName() + " is " + this.getFairShare());
        }
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        Resource assigned = Resources.none();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node " + node.getNodeName() + " offered to queue: " + this.getName() + " fairShare: " + this.getFairShare());
        }
        if (!this.assignContainerPreCheck(node)) {
            return assigned;
        }
        for (FSAppAttempt sched : this.fetchAppsWithDemand(true)) {
            if (SchedulerAppUtils.isPlaceBlacklisted(sched, node, LOG) || (assigned = sched.assignContainer(node)).equals((Object)Resources.none())) continue;
            if (!LOG.isDebugEnabled()) break;
            LOG.debug("Assigned container in queue:" + this.getName() + " container:" + assigned);
            break;
        }
        return assigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet<FSAppAttempt> fetchAppsWithDemand(boolean assignment) {
        TreeSet<Schedulable> pendingForResourceApps = new TreeSet<Schedulable>(this.policy.getComparator());
        this.readLock.lock();
        try {
            for (FSAppAttempt app : this.runnableApps) {
                if (Resources.isNone((Resource)app.getPendingDemand()) || !assignment && !app.shouldCheckForStarvation()) continue;
                pendingForResourceApps.add(app);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return pendingForResourceApps;
    }

    @Override
    public List<FSQueue> getChildQueues() {
        return EMPTY_LIST;
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    private void setLastTimeAtMinShare(long lastTimeAtMinShare) {
        this.lastTimeAtMinShare = lastTimeAtMinShare;
    }

    @Override
    public int getNumRunnableApps() {
        this.readLock.lock();
        try {
            int n = this.runnableApps.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    int getNumNonRunnableApps() {
        this.readLock.lock();
        try {
            int n = this.nonRunnableApps.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumPendingApps() {
        int numPendingApps = 0;
        this.readLock.lock();
        try {
            for (FSAppAttempt attempt : this.runnableApps) {
                if (!attempt.isPending()) continue;
                ++numPendingApps;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return numPendingApps += this.nonRunnableApps.size();
    }

    public int getNumAssignedApps() {
        this.readLock.lock();
        try {
            int n = this.assignedApps.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            if (this.runnableApps.size() > 0 || this.nonRunnableApps.size() > 0 || this.assignedApps.size() > 0) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumActiveApps() {
        int numActiveApps = 0;
        this.readLock.lock();
        try {
            for (FSAppAttempt attempt : this.runnableApps) {
                if (attempt.isPending()) continue;
                ++numActiveApps;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return numActiveApps;
    }

    @Override
    public ActiveUsersManager getAbstractUsersManager() {
        return this.activeUsersManager;
    }

    private Resource computeMaxAMResource() {
        Resource maxResource = Resources.clone((Resource)this.getFairShare());
        if (maxResource.getMemorySize() == 0L) {
            maxResource.setMemorySize(Math.min(this.scheduler.getRootQueueMetrics().getAvailableMB(), this.getMaxShare().getMemorySize()));
        }
        if (maxResource.getVirtualCores() == 0) {
            maxResource.setVirtualCores(Math.min(this.scheduler.getRootQueueMetrics().getAvailableVirtualCores(), this.getMaxShare().getVirtualCores()));
        }
        return Resources.multiplyAndRoundUp((Resource)maxResource, (double)this.maxAMShare);
    }

    public boolean canRunAppAM(Resource amResource) {
        if ((double)Math.abs(this.maxAMShare - -1.0f) < 1.0E-4) {
            return true;
        }
        Resource maxAMResource = this.computeMaxAMResource();
        this.getMetrics().setMaxAMShare(maxAMResource);
        Resource ifRunAMResource = Resources.add((Resource)this.amResourceUsage, (Resource)amResource);
        return Resources.fitsIn((Resource)ifRunAMResource, (Resource)maxAMResource);
    }

    void addAMResourceUsage(Resource amResource) {
        if (amResource != null) {
            Resources.addTo((Resource)this.amResourceUsage, (Resource)amResource);
            this.getMetrics().setAMResourceUsage(this.amResourceUsage);
        }
    }

    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt schedulerAttempt, RMContainer rmContainer) {
    }

    @Override
    public void setWeights(float weight) {
        this.weights = weight;
    }

    @Override
    public Resource getMaximumContainerAllocation() {
        if (this.maxContainerAllocation.equals((Object)Resources.unbounded()) && this.getParent() != null) {
            return this.getParent().getMaximumContainerAllocation();
        }
        return this.maxContainerAllocation;
    }

    private Resource minShareStarvation() {
        Resource starvation = Resources.componentwiseMin((Resource)this.getMinShare(), (Resource)this.getDemand());
        Resources.subtractFromNonNegative((Resource)starvation, (Resource)this.getResourceUsage());
        boolean starved = !Resources.isNone((Resource)starvation);
        long now = this.scheduler.getClock().getTime();
        if (!starved) {
            this.setLastTimeAtMinShare(now);
        }
        if (now - this.lastTimeAtMinShare < this.getMinSharePreemptionTimeout()) {
            starvation = Resources.clone((Resource)Resources.none());
        }
        return starvation;
    }

    @VisibleForTesting
    private boolean isStarvedForMinShare() {
        return !Resources.isNone((Resource)this.minShareStarvation());
    }

    @VisibleForTesting
    private boolean isStarvedForFairShare() {
        for (FSAppAttempt app : this.runnableApps) {
            if (!app.isStarvedForFairShare()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean isStarved() {
        return this.isStarvedForMinShare() || this.isStarvedForFairShare();
    }

    @Override
    protected void dumpStateInternal(StringBuilder sb) {
        sb.append("{Name: " + this.getName() + ", Weight: " + this.weights + ", Policy: " + this.policy.getName() + ", FairShare: " + this.getFairShare() + ", SteadyFairShare: " + this.getSteadyFairShare() + ", MaxShare: " + this.getMaxShare() + ", MinShare: " + this.minShare + ", ResourceUsage: " + this.getResourceUsage() + ", Demand: " + this.getDemand() + ", Runnable: " + this.getNumRunnableApps() + ", NumPendingApps: " + this.getNumPendingApps() + ", NonRunnable: " + this.getNumNonRunnableApps() + ", MaxAMShare: " + this.maxAMShare + ", MaxAMResource: " + this.computeMaxAMResource() + ", AMResourceUsage: " + this.getAmResourceUsage() + ", LastTimeAtMinShare: " + this.lastTimeAtMinShare + "}");
    }

    public void addAssignedApp(ApplicationId applicationId) {
        this.writeLock.lock();
        try {
            this.assignedApps.add(applicationId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeAssignedApp(ApplicationId applicationId) {
        this.writeLock.lock();
        try {
            this.assignedApps.remove(applicationId);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

