/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Set;
import org.apache.hadoop.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class CSQueueUtils {
    public static final float EPSILON = 1.0E-4f;

    public static void checkMaxCapacity(String queueName, float capacity, float maximumCapacity) {
        if (maximumCapacity < 0.0f || maximumCapacity > 1.0f) {
            throw new IllegalArgumentException("Illegal value  of maximumCapacity " + maximumCapacity + " used in call to setMaxCapacity for queue " + queueName);
        }
    }

    public static void checkAbsoluteCapacity(String queueName, float absCapacity, float absMaxCapacity) {
        if (absMaxCapacity < absCapacity - 1.0E-4f) {
            throw new IllegalArgumentException("Illegal call to setMaxCapacity. Queue '" + queueName + "' has an absolute capacity (" + absCapacity + ") greater than its absolute maximumCapacity (" + absMaxCapacity + ")");
        }
    }

    private static void capacitiesSanityCheck(String queueName, QueueCapacities queueCapacities) {
        for (String label : queueCapacities.getExistingNodeLabels()) {
            float absMaxCapacity;
            float absCapacity = queueCapacities.getAbsoluteCapacity(label);
            if (!(absCapacity > (absMaxCapacity = queueCapacities.getAbsoluteMaximumCapacity(label)))) continue;
            throw new IllegalArgumentException("Illegal queue capacity setting (abs-capacity=" + absCapacity + ") > (abs-maximum-capacity=" + absMaxCapacity + ") for queue=[" + queueName + "],label=[" + label + "]");
        }
    }

    public static float computeAbsoluteMaximumCapacity(float maximumCapacity, CSQueue parent) {
        float parentAbsMaxCapacity = parent == null ? 1.0f : parent.getAbsoluteMaximumCapacity();
        return parentAbsMaxCapacity * maximumCapacity;
    }

    public static void updateAndCheckCapacitiesByLabel(String queuePath, QueueCapacities queueCapacities, QueueCapacities parentQueueCapacities) {
        CSQueueUtils.updateAbsoluteCapacitiesByNodeLabels(queueCapacities, parentQueueCapacities);
        CSQueueUtils.capacitiesSanityCheck(queuePath, queueCapacities);
    }

    public static void loadUpdateAndCheckCapacities(String queuePath, CapacitySchedulerConfiguration csConf, QueueCapacities queueCapacities, QueueCapacities parentQueueCapacities) {
        CSQueueUtils.loadCapacitiesByLabelsFromConf(queuePath, queueCapacities, csConf);
        CSQueueUtils.updateAbsoluteCapacitiesByNodeLabels(queueCapacities, parentQueueCapacities);
        CSQueueUtils.capacitiesSanityCheck(queuePath, queueCapacities);
    }

    private static void loadCapacitiesByLabelsFromConf(String queuePath, QueueCapacities queueCapacities, CapacitySchedulerConfiguration csConf) {
        queueCapacities.clearConfigurableFields();
        Set<String> configuredNodelabels = csConf.getConfiguredNodeLabels(queuePath);
        for (String label : configuredNodelabels) {
            if (label.equals("")) {
                queueCapacities.setCapacity(label, csConf.getNonLabeledQueueCapacity(queuePath) / 100.0f);
                queueCapacities.setMaximumCapacity(label, csConf.getNonLabeledQueueMaximumCapacity(queuePath) / 100.0f);
                queueCapacities.setMaxAMResourcePercentage(label, csConf.getMaximumAMResourcePercentPerPartition(queuePath, label));
                continue;
            }
            queueCapacities.setCapacity(label, csConf.getLabeledQueueCapacity(queuePath, label) / 100.0f);
            queueCapacities.setMaximumCapacity(label, csConf.getLabeledQueueMaximumCapacity(queuePath, label) / 100.0f);
            queueCapacities.setMaxAMResourcePercentage(label, csConf.getMaximumAMResourcePercentPerPartition(queuePath, label));
        }
    }

    private static void updateAbsoluteCapacitiesByNodeLabels(QueueCapacities queueCapacities, QueueCapacities parentQueueCapacities) {
        for (String label : queueCapacities.getExistingNodeLabels()) {
            float maxCapacity;
            float capacity = queueCapacities.getCapacity(label);
            if (capacity > 0.0f) {
                queueCapacities.setAbsoluteCapacity(label, capacity * (parentQueueCapacities == null ? 1.0f : parentQueueCapacities.getAbsoluteCapacity(label)));
            }
            if (!((maxCapacity = queueCapacities.getMaximumCapacity(label)) > 0.0f)) continue;
            queueCapacities.setAbsoluteMaximumCapacity(label, maxCapacity * (parentQueueCapacities == null ? 1.0f : parentQueueCapacities.getAbsoluteMaximumCapacity(label)));
        }
    }

    public static void updateUsedCapacity(ResourceCalculator rc, Resource totalPartitionResource, String nodePartition, AbstractCSQueue childQueue) {
        QueueCapacities queueCapacities = childQueue.getQueueCapacities();
        CSQueueMetrics queueMetrics = childQueue.getMetrics();
        ResourceUsage queueResourceUsage = childQueue.getQueueResourceUsage();
        Resource minimumAllocation = childQueue.getMinimumAllocation();
        float absoluteUsedCapacity = 0.0f;
        float usedCapacity = 0.0f;
        float reservedCapacity = 0.0f;
        float absoluteReservedCapacity = 0.0f;
        if (Resources.greaterThan((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)totalPartitionResource, (Resource)Resources.none())) {
            Resource queueGuaranteedResource = childQueue.getEffectiveCapacity(nodePartition);
            if (Float.compare(queueCapacities.getAbsoluteCapacity(nodePartition), 0.0f) == 0 && childQueue instanceof AutoCreatedLeafQueue) {
                ManagedParentQueue parentQueue = (ManagedParentQueue)childQueue.getParent();
                QueueCapacities leafQueueTemplateCapacities = parentQueue.getLeafQueueTemplate().getQueueCapacities();
                queueGuaranteedResource = Resources.multiply((Resource)totalPartitionResource, (double)leafQueueTemplateCapacities.getAbsoluteCapacity(nodePartition));
            }
            queueGuaranteedResource = Resources.max((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)queueGuaranteedResource, (Resource)minimumAllocation);
            Resource usedResource = queueResourceUsage.getUsed(nodePartition);
            absoluteUsedCapacity = Resources.divide((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)usedResource, (Resource)totalPartitionResource);
            usedCapacity = Resources.divide((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)usedResource, (Resource)queueGuaranteedResource);
            Resource resResource = queueResourceUsage.getReserved(nodePartition);
            reservedCapacity = Resources.divide((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)resResource, (Resource)queueGuaranteedResource);
            absoluteReservedCapacity = Resources.divide((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)resResource, (Resource)totalPartitionResource);
        }
        queueCapacities.setAbsoluteUsedCapacity(nodePartition, absoluteUsedCapacity);
        queueCapacities.setUsedCapacity(nodePartition, usedCapacity);
        queueCapacities.setReservedCapacity(nodePartition, reservedCapacity);
        queueCapacities.setAbsoluteReservedCapacity(nodePartition, absoluteReservedCapacity);
        queueMetrics.setUsedCapacity(nodePartition, queueCapacities.getUsedCapacity(""));
        queueMetrics.setAbsoluteUsedCapacity(nodePartition, Float.valueOf(queueCapacities.getAbsoluteUsedCapacity("")));
    }

    private static Resource getMaxAvailableResourceToQueuePartition(ResourceCalculator rc, CSQueue queue, Resource cluster, String partition) {
        Resource queueGuaranteedResource = queue.getEffectiveCapacity(partition);
        Resource available = Resources.greaterThan((ResourceCalculator)rc, (Resource)cluster, (Resource)queueGuaranteedResource, (Resource)queue.getQueueResourceUsage().getUsed(partition)) ? Resources.componentwiseMax((Resource)Resources.subtractFrom((Resource)queueGuaranteedResource, (Resource)queue.getQueueResourceUsage().getUsed(partition)), (Resource)Resources.none()) : Resources.none();
        return available;
    }

    @Lock(value={CSQueue.class})
    public static void updateQueueStatistics(ResourceCalculator rc, Resource cluster, AbstractCSQueue childQueue, RMNodeLabelsManager nlm, String nodePartition) {
        QueueCapacities queueCapacities = childQueue.getQueueCapacities();
        ResourceUsage queueResourceUsage = childQueue.getQueueResourceUsage();
        if (nodePartition == null) {
            for (String partition : Sets.union(queueCapacities.getNodePartitionsSet(), queueResourceUsage.getNodePartitionsSet())) {
                CSQueueUtils.updateUsedCapacity(rc, nlm.getResourceByLabel(partition, cluster), partition, childQueue);
                childQueue.getMetrics().setAvailableResourcesToQueue(partition, CSQueueUtils.getMaxAvailableResourceToQueuePartition(rc, childQueue, cluster, partition));
            }
        } else {
            CSQueueUtils.updateUsedCapacity(rc, nlm.getResourceByLabel(nodePartition, cluster), nodePartition, childQueue);
            childQueue.getMetrics().setAvailableResourcesToQueue(nodePartition, CSQueueUtils.getMaxAvailableResourceToQueuePartition(rc, childQueue, cluster, nodePartition));
        }
    }

    public static void updateConfiguredCapacityMetrics(ResourceCalculator rc, Resource partitionResource, String partition, AbstractCSQueue queue) {
        queue.getMetrics().setGuaranteedResources(partition, rc.multiplyAndNormalizeDown(partitionResource, (double)queue.getQueueCapacities().getAbsoluteCapacity(partition), queue.getMinimumAllocation()));
        queue.getMetrics().setMaxCapacityResources(partition, rc.multiplyAndNormalizeDown(partitionResource, (double)queue.getQueueCapacities().getAbsoluteMaximumCapacity(partition), queue.getMinimumAllocation()));
        queue.getMetrics().setGuaranteedCapacities(partition, queue.getQueueCapacities().getCapacity(partition), queue.getQueueCapacities().getAbsoluteCapacity(partition));
        queue.getMetrics().setMaxCapacities(partition, queue.getQueueCapacities().getMaximumCapacity(partition), queue.getQueueCapacities().getAbsoluteMaximumCapacity(partition));
    }
}

