/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.gpu.GpuResourceAllocator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.gpu.GpuResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.DockerCommandPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.NodeResourceUpdaterPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.AssignedGpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDiscoverer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDockerCommandPluginFactory;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuNodeResourceUpdateHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.NvidiaBinaryHelper;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NMResourceInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.GpuDeviceInformation;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.NMGpuResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpuResourcePlugin
implements ResourcePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(GpuResourcePlugin.class);
    private final GpuNodeResourceUpdateHandler resourceDiscoverHandler;
    private final GpuDiscoverer gpuDiscoverer;
    public static final int MAX_REPEATED_ERROR_ALLOWED = 10;
    private int numOfErrorExecutionSinceLastSucceed = 0;
    private GpuResourceHandlerImpl gpuResourceHandler = null;
    private DockerCommandPlugin dockerCommandPlugin = null;

    public GpuResourcePlugin(GpuNodeResourceUpdateHandler resourceDiscoverHandler, GpuDiscoverer gpuDiscoverer) {
        this.resourceDiscoverHandler = resourceDiscoverHandler;
        this.gpuDiscoverer = gpuDiscoverer;
    }

    @Override
    public void initialize(Context context) throws YarnException {
        this.validateExecutorConfig(context.getConf());
        this.gpuDiscoverer.initialize(context.getConf(), new NvidiaBinaryHelper());
        this.dockerCommandPlugin = GpuDockerCommandPluginFactory.createGpuDockerCommandPlugin(context.getConf());
    }

    private void validateExecutorConfig(Configuration conf) {
        Class executorClass = conf.getClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class);
        if (executorClass.equals(DefaultContainerExecutor.class)) {
            LOG.warn("Using GPU plugin with disabled LinuxContainerExecutor is considered to be unsafe.");
        }
    }

    @Override
    public ResourceHandler createResourceHandler(Context context, CGroupsHandler cGroupsHandler, PrivilegedOperationExecutor privilegedOperationExecutor) {
        if (this.gpuResourceHandler == null) {
            this.gpuResourceHandler = new GpuResourceHandlerImpl(context, cGroupsHandler, privilegedOperationExecutor, this.gpuDiscoverer);
        }
        return this.gpuResourceHandler;
    }

    @Override
    public NodeResourceUpdaterPlugin getNodeResourceHandlerInstance() {
        return this.resourceDiscoverHandler;
    }

    @Override
    public void cleanup() throws YarnException {
    }

    @Override
    public DockerCommandPlugin getDockerCommandPluginInstance() {
        return this.dockerCommandPlugin;
    }

    @Override
    public synchronized NMResourceInfo getNMResourceInfo() throws YarnException {
        GpuDeviceInformation gpuDeviceInformation;
        this.checkGpuResourceHandler();
        this.checkErrorCount();
        try {
            gpuDeviceInformation = this.gpuDiscoverer.getGpuDeviceInformation();
            this.numOfErrorExecutionSinceLastSucceed = 0;
        }
        catch (YarnException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            ++this.numOfErrorExecutionSinceLastSucceed;
            throw e;
        }
        GpuResourceAllocator gpuResourceAllocator = this.gpuResourceHandler.getGpuAllocator();
        List<GpuDevice> totalGpus = gpuResourceAllocator.getAllowedGpus();
        List<AssignedGpuDevice> assignedGpuDevices = gpuResourceAllocator.getAssignedGpus();
        return new NMGpuResourceInfo(gpuDeviceInformation, totalGpus, assignedGpuDevices);
    }

    private void checkGpuResourceHandler() throws YarnException {
        if (this.gpuResourceHandler == null) {
            String errorMsg = "Linux Container Executor is not configured for the NodeManager. To fully enable GPU feature on the node also set yarn.nodemanager.container-executor.class properly.";
            LOG.warn(errorMsg);
            throw new YarnException(errorMsg);
        }
    }

    private void checkErrorCount() throws YarnException {
        if (this.numOfErrorExecutionSinceLastSucceed == 10) {
            String msg = "Failed to execute GPU device information detection script for 10 times, skip following executions.";
            LOG.error(msg);
            throw new YarnException(msg);
        }
    }

    public String toString() {
        return GpuResourcePlugin.class.getName();
    }
}

