/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationDFSException;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.tfile.LogAggregationTFileController;
import org.apache.hadoop.yarn.server.api.ContainerLogAggregationPolicy;
import org.apache.hadoop.yarn.server.api.ContainerLogContext;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.FileDeletionTask;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.AllContainerLogAggregationPolicy;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.AppLogAggregator;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.Times;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppLogAggregatorImpl
implements AppLogAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(AppLogAggregatorImpl.class);
    private static final int THREAD_SLEEP_TIME = 1000;
    private final LocalDirsHandlerService dirsHandler;
    private final Dispatcher dispatcher;
    private final ApplicationId appId;
    private final String applicationId;
    private boolean logAggregationDisabled = false;
    private final Configuration conf;
    private final DeletionService delService;
    private final UserGroupInformation userUgi;
    private final Path remoteNodeLogFileForApp;
    private final Path remoteNodeTmpLogFileForApp;
    private final BlockingQueue<ContainerId> pendingContainers;
    private final AtomicBoolean appFinishing = new AtomicBoolean();
    private final AtomicBoolean appAggregationFinished = new AtomicBoolean();
    private final AtomicBoolean aborted = new AtomicBoolean();
    private final Map<ApplicationAccessType, String> appAcls;
    private final FileContext lfs;
    private final LogAggregationContext logAggregationContext;
    private final Context context;
    private final NodeId nodeId;
    private final LogAggregationFileControllerContext logControllerContext;
    private final AtomicBoolean waiting = new AtomicBoolean(false);
    private int logAggregationTimes = 0;
    private long logFileSizeThreshold;
    private boolean renameTemporaryLogFileFailed = false;
    private final Map<ContainerId, ContainerLogAggregator> containerLogAggregators = new HashMap<ContainerId, ContainerLogAggregator>();
    private final ContainerLogAggregationPolicy logAggPolicy;
    private final LogAggregationFileController logAggregationFileController;
    private final long recoveredLogInitedTime;

    public AppLogAggregatorImpl(Dispatcher dispatcher, DeletionService deletionService, Configuration conf, ApplicationId appId, UserGroupInformation userUgi, NodeId nodeId, LocalDirsHandlerService dirsHandler, Path remoteNodeLogFileForApp, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext, Context context, FileContext lfs, long rollingMonitorInterval) {
        this(dispatcher, deletionService, conf, appId, userUgi, nodeId, dirsHandler, remoteNodeLogFileForApp, appAcls, logAggregationContext, context, lfs, rollingMonitorInterval, -1L, null);
    }

    public AppLogAggregatorImpl(Dispatcher dispatcher, DeletionService deletionService, Configuration conf, ApplicationId appId, UserGroupInformation userUgi, NodeId nodeId, LocalDirsHandlerService dirsHandler, Path remoteNodeLogFileForApp, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext, Context context, FileContext lfs, long rollingMonitorInterval, long recoveredLogInitedTime) {
        this(dispatcher, deletionService, conf, appId, userUgi, nodeId, dirsHandler, remoteNodeLogFileForApp, appAcls, logAggregationContext, context, lfs, rollingMonitorInterval, recoveredLogInitedTime, null);
    }

    public AppLogAggregatorImpl(Dispatcher dispatcher, DeletionService deletionService, Configuration conf, ApplicationId appId, UserGroupInformation userUgi, NodeId nodeId, LocalDirsHandlerService dirsHandler, Path remoteNodeLogFileForApp, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext, Context context, FileContext lfs, long rollingMonitorInterval, long recoveredLogInitedTime, LogAggregationFileController logAggregationFileController) {
        boolean logAggregationInRolling;
        this.dispatcher = dispatcher;
        this.conf = conf;
        this.delService = deletionService;
        this.appId = appId;
        this.applicationId = appId.toString();
        this.userUgi = userUgi;
        this.dirsHandler = dirsHandler;
        this.pendingContainers = new LinkedBlockingQueue<ContainerId>();
        this.appAcls = appAcls;
        this.lfs = lfs;
        this.logAggregationContext = logAggregationContext;
        this.context = context;
        this.nodeId = nodeId;
        this.logAggPolicy = this.getLogAggPolicy(conf);
        this.recoveredLogInitedTime = recoveredLogInitedTime;
        this.logFileSizeThreshold = conf.getLong("yarn.log-aggregation.debug.filesize", 0x6400000L);
        if (logAggregationFileController == null) {
            this.logAggregationFileController = new LogAggregationTFileController();
            this.logAggregationFileController.initialize(conf, "TFile");
            this.logAggregationFileController.verifyAndCreateRemoteLogDir();
            this.logAggregationFileController.createAppDir(this.userUgi.getShortUserName(), appId, userUgi);
            this.remoteNodeLogFileForApp = this.logAggregationFileController.getRemoteNodeLogFileForApp(appId, this.userUgi.getShortUserName(), nodeId);
            this.remoteNodeTmpLogFileForApp = this.getRemoteNodeTmpLogFileForApp();
        } else {
            this.logAggregationFileController = logAggregationFileController;
            this.remoteNodeLogFileForApp = remoteNodeLogFileForApp;
            this.remoteNodeTmpLogFileForApp = this.getRemoteNodeTmpLogFileForApp();
        }
        boolean bl = logAggregationInRolling = rollingMonitorInterval > 0L && this.logAggregationContext != null && this.logAggregationContext.getRolledLogsIncludePattern() != null && !this.logAggregationContext.getRolledLogsIncludePattern().isEmpty();
        if (logAggregationInRolling) {
            LOG.info("Rolling mode is turned on with include pattern {}", (Object)this.logAggregationContext.getRolledLogsIncludePattern());
        } else {
            LOG.debug("Rolling mode is turned off");
        }
        this.logControllerContext = new LogAggregationFileControllerContext(this.remoteNodeLogFileForApp, this.remoteNodeTmpLogFileForApp, logAggregationInRolling, rollingMonitorInterval, this.appId, this.appAcls, this.nodeId, this.userUgi);
    }

    private ContainerLogAggregationPolicy getLogAggPolicy(Configuration conf) {
        ContainerLogAggregationPolicy policy = this.getLogAggPolicyInstance(conf);
        String params = this.getLogAggPolicyParameters(conf);
        if (params != null) {
            policy.parseParameters(params);
        }
        return policy;
    }

    private ContainerLogAggregationPolicy getLogAggPolicyInstance(Configuration conf) {
        String className;
        Class<ContainerLogAggregationPolicy> policyClass = null;
        if (this.logAggregationContext != null && (className = this.logAggregationContext.getLogAggregationPolicyClassName()) != null) {
            try {
                Class policyFromContext = conf.getClassByName(className);
                if (ContainerLogAggregationPolicy.class.isAssignableFrom(policyFromContext)) {
                    policyClass = policyFromContext.asSubclass(ContainerLogAggregationPolicy.class);
                } else {
                    LOG.warn(this.appId + " specified invalid log aggregation policy " + className);
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOG.warn(this.appId + " specified invalid log aggregation policy " + className);
            }
        }
        if (policyClass == null) {
            policyClass = conf.getClass("yarn.nodemanager.log-aggregation.policy.class", AllContainerLogAggregationPolicy.class, ContainerLogAggregationPolicy.class);
        } else {
            LOG.info(this.appId + " specifies ContainerLogAggregationPolicy of " + policyClass);
        }
        return (ContainerLogAggregationPolicy)ReflectionUtils.newInstance((Class)policyClass, (Configuration)conf);
    }

    private String getLogAggPolicyParameters(Configuration conf) {
        String params = null;
        if (this.logAggregationContext != null) {
            params = this.logAggregationContext.getLogAggregationPolicyParameters();
        }
        if (params == null) {
            params = conf.get("yarn.nodemanager.log-aggregation.policy.parameters");
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadLogsForContainers(boolean appFinished) throws LogAggregationDFSException {
        if (this.logAggregationDisabled) {
            return;
        }
        this.addCredentials();
        HashSet<ContainerId> pendingContainerInThisCycle = new HashSet<ContainerId>();
        this.pendingContainers.drainTo(pendingContainerInThisCycle);
        HashSet finishedContainers = new HashSet(pendingContainerInThisCycle);
        if (this.context.getApplications().get(this.appId) != null) {
            for (Container container : ((Application)this.context.getApplications().get(this.appId)).getContainers().values()) {
                ContainerType containerType = container.getContainerTokenIdentifier().getContainerType();
                if (!this.shouldUploadLogs(new ContainerLogContext(container.getContainerId(), containerType, 0))) continue;
                pendingContainerInThisCycle.add(container.getContainerId());
            }
        }
        if (pendingContainerInThisCycle.isEmpty()) {
            LOG.debug("No pending container in this cycle");
            this.sendLogAggregationReport(true, "", appFinished);
            return;
        }
        ++this.logAggregationTimes;
        LOG.debug("Cycle #{} of log aggregator", (Object)this.logAggregationTimes);
        String diagnosticMessage = "";
        boolean logAggregationSucceedInThisCycle = true;
        FileDeletionTask deletionTask = null;
        try {
            try {
                this.logAggregationFileController.initializeWriter(this.logControllerContext);
            }
            catch (IOException e1) {
                logAggregationSucceedInThisCycle = false;
                LOG.error("Cannot create writer for app " + this.applicationId + ". Skip log upload this time. ", (Throwable)e1);
                LogAggregationDFSException exc = null;
                try {
                    this.logAggregationFileController.closeWriter();
                }
                catch (LogAggregationDFSException e) {
                    diagnosticMessage = e.getMessage();
                    this.renameTemporaryLogFileFailed = true;
                    logAggregationSucceedInThisCycle = false;
                    exc = e;
                }
                if (logAggregationSucceedInThisCycle && deletionTask != null) {
                    this.delService.delete(deletionTask);
                }
                if (diagnosticMessage != null && !diagnosticMessage.isEmpty()) {
                    LOG.debug("Sending log aggregation report along with the following diagnostic message:\"{}\"", (Object)diagnosticMessage);
                }
                if (!logAggregationSucceedInThisCycle) {
                    LOG.warn("Log aggregation did not succeed in this cycle");
                }
                this.sendLogAggregationReport(logAggregationSucceedInThisCycle, diagnosticMessage, appFinished);
                if (exc != null) {
                    throw exc;
                }
                return;
            }
            boolean uploadedLogsInThisCycle = false;
            for (ContainerId container : pendingContainerInThisCycle) {
                ContainerLogAggregator aggregator = null;
                if (this.containerLogAggregators.containsKey(container)) {
                    aggregator = this.containerLogAggregators.get(container);
                } else {
                    aggregator = new ContainerLogAggregator(container);
                    this.containerLogAggregators.put(container, aggregator);
                }
                Set<Path> uploadedFilePathsInThisCycle = aggregator.doContainerLogAggregation(this.logAggregationFileController, appFinished, finishedContainers.contains(container));
                if (uploadedFilePathsInThisCycle.size() > 0) {
                    uploadedLogsInThisCycle = true;
                    LOG.trace("Uploaded the following files for {}: {}", (Object)container, (Object)uploadedFilePathsInThisCycle.toString());
                    ArrayList<Path> uploadedFilePathsInThisCycleList = new ArrayList<Path>();
                    uploadedFilePathsInThisCycleList.addAll(uploadedFilePathsInThisCycle);
                    if (LOG.isDebugEnabled()) {
                        for (Path uploadedFilePath : uploadedFilePathsInThisCycleList) {
                            try {
                                long fileSize = this.lfs.getFileStatus(uploadedFilePath).getLen();
                                if (fileSize < this.logFileSizeThreshold) continue;
                                LOG.debug("Log File " + uploadedFilePath + " size is " + fileSize + " bytes");
                            }
                            catch (Exception e1) {
                                LOG.error("Failed to get log file size " + e1);
                            }
                        }
                    }
                    deletionTask = new FileDeletionTask(this.delService, this.userUgi.getShortUserName(), null, uploadedFilePathsInThisCycleList);
                }
                if (!finishedContainers.contains(container)) continue;
                this.containerLogAggregators.remove(container);
            }
            this.logControllerContext.setUploadedLogsInThisCycle(uploadedLogsInThisCycle);
            this.logControllerContext.setLogUploadTimeStamp(System.currentTimeMillis());
            this.logControllerContext.increLogAggregationTimes();
            try {
                this.logAggregationFileController.postWrite(this.logControllerContext);
                diagnosticMessage = "Log uploaded successfully for Application: " + this.appId + " in NodeManager: " + LogAggregationUtils.getNodeString((NodeId)this.nodeId) + " at " + Times.format((long)this.logControllerContext.getLogUploadTimeStamp()) + "\n";
            }
            catch (Exception e) {
                diagnosticMessage = e.getMessage();
                this.renameTemporaryLogFileFailed = true;
                logAggregationSucceedInThisCycle = false;
            }
        }
        finally {
            LogAggregationDFSException exc = null;
            try {
                this.logAggregationFileController.closeWriter();
            }
            catch (LogAggregationDFSException e) {
                diagnosticMessage = e.getMessage();
                this.renameTemporaryLogFileFailed = true;
                logAggregationSucceedInThisCycle = false;
                exc = e;
            }
            if (logAggregationSucceedInThisCycle && deletionTask != null) {
                this.delService.delete(deletionTask);
            }
            if (diagnosticMessage != null && !diagnosticMessage.isEmpty()) {
                LOG.debug("Sending log aggregation report along with the following diagnostic message:\"{}\"", (Object)diagnosticMessage);
            }
            if (!logAggregationSucceedInThisCycle) {
                LOG.warn("Log aggregation did not succeed in this cycle");
            }
            this.sendLogAggregationReport(logAggregationSucceedInThisCycle, diagnosticMessage, appFinished);
            if (exc != null) {
                throw exc;
            }
        }
    }

    private void addCredentials() {
        Credentials systemCredentials;
        if (UserGroupInformation.isSecurityEnabled() && (systemCredentials = this.context.getSystemCredentialsForApps().get(this.appId)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding new framework-token for " + this.appId + " for log-aggregation: " + systemCredentials.getAllTokens() + "; userUgi=" + this.userUgi);
            }
            this.userUgi.addCredentials(systemCredentials);
        }
    }

    private void sendLogAggregationReport(boolean logAggregationSucceedInThisCycle, String diagnosticMessage, boolean appFinished) {
        LogAggregationStatus logAggregationStatus = logAggregationSucceedInThisCycle ? LogAggregationStatus.RUNNING : LogAggregationStatus.RUNNING_WITH_FAILURE;
        this.sendLogAggregationReportInternal(logAggregationStatus, diagnosticMessage, false);
        if (appFinished) {
            LogAggregationStatus finalLogAggregationStatus = this.renameTemporaryLogFileFailed || !logAggregationSucceedInThisCycle ? LogAggregationStatus.FAILED : LogAggregationStatus.SUCCEEDED;
            this.sendLogAggregationReportInternal(finalLogAggregationStatus, "", true);
        }
    }

    private void sendLogAggregationReportInternal(LogAggregationStatus logAggregationStatus, String diagnosticMessage, boolean finalized) {
        LogAggregationReport report = (LogAggregationReport)Records.newRecord(LogAggregationReport.class);
        report.setApplicationId(this.appId);
        report.setDiagnosticMessage(diagnosticMessage);
        report.setLogAggregationStatus(logAggregationStatus);
        this.context.getLogAggregationStatusForApps().add(report);
        this.context.getNMLogAggregationStatusTracker().updateLogAggregationStatus(this.appId, logAggregationStatus, System.currentTimeMillis(), diagnosticMessage, finalized);
    }

    @Override
    public void run() {
        try {
            this.doAppLogAggregation();
        }
        catch (LogAggregationDFSException e) {
            LOG.error("Error occurred while aggregating the log for the application " + this.appId, (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Error occurred while aggregating the log for the application " + this.appId, (Throwable)e);
            this.doAppLogAggregationPostCleanUp();
        }
        finally {
            if (!this.appAggregationFinished.get() && !this.aborted.get()) {
                LOG.warn("Log aggregation did not complete for application " + this.appId);
                this.dispatcher.getEventHandler().handle((Event)new ApplicationEvent(this.appId, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED));
            }
            this.appAggregationFinished.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAppLogAggregation() throws LogAggregationDFSException {
        while (!this.appFinishing.get() && !this.aborted.get()) {
            AppLogAggregatorImpl appLogAggregatorImpl = this;
            synchronized (appLogAggregatorImpl) {
                try {
                    this.waiting.set(true);
                    if (this.logControllerContext.isLogAggregationInRolling()) {
                        this.wait(this.logControllerContext.getRollingMonitorInterval() * 1000L);
                        if (this.appFinishing.get() || this.aborted.get()) {
                            break;
                        }
                        this.uploadLogsForContainers(false);
                    } else {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("PendingContainers queue is interrupted");
                    this.appFinishing.set(true);
                }
                catch (LogAggregationDFSException e) {
                    this.appFinishing.set(true);
                    throw e;
                }
            }
        }
        if (this.aborted.get()) {
            return;
        }
        try {
            this.uploadLogsForContainers(true);
            this.doAppLogAggregationPostCleanUp();
        }
        catch (LogAggregationDFSException e) {
            LOG.error("Error during log aggregation", (Throwable)e);
        }
        this.dispatcher.getEventHandler().handle((Event)new ApplicationEvent(this.appId, ApplicationEventType.APPLICATION_LOG_HANDLING_FINISHED));
        this.appAggregationFinished.set(true);
    }

    private void doAppLogAggregationPostCleanUp() {
        ArrayList<Path> localAppLogDirs = new ArrayList<Path>();
        for (String rootLogDir : this.dirsHandler.getLogDirsForCleanup()) {
            Path logPath = new Path(rootLogDir, this.applicationId);
            try {
                this.lfs.getFileStatus(logPath);
                localAppLogDirs.add(logPath);
            }
            catch (UnsupportedFileSystemException ue) {
                LOG.warn("Log dir {} is in an unsupported file system", (Object)rootLogDir, (Object)ue);
            }
            catch (IOException fe) {
                LOG.warn("An exception occurred while getting file information", (Throwable)fe);
            }
        }
        if (localAppLogDirs.size() > 0) {
            LOG.debug("Cleaning up {} files", (Object)localAppLogDirs.size());
            ArrayList<Path> localAppLogDirsList = new ArrayList<Path>();
            localAppLogDirsList.addAll(localAppLogDirs);
            FileDeletionTask deletionTask = new FileDeletionTask(this.delService, this.userUgi.getShortUserName(), null, localAppLogDirsList);
            this.delService.delete(deletionTask);
        }
    }

    private Path getRemoteNodeTmpLogFileForApp() {
        return new Path(this.remoteNodeLogFileForApp.getParent(), this.remoteNodeLogFileForApp.getName() + ".tmp");
    }

    private boolean shouldUploadLogs(ContainerLogContext logContext) {
        return this.logAggPolicy.shouldDoLogAggregation(logContext);
    }

    @Override
    public void startContainerLogAggregation(ContainerLogContext logContext) {
        if (this.shouldUploadLogs(logContext)) {
            LOG.info("Considering container " + logContext.getContainerId() + " for log-aggregation");
            this.pendingContainers.add(logContext.getContainerId());
        }
    }

    @Override
    public synchronized void finishLogAggregation() {
        LOG.info("Application just finished : " + this.applicationId);
        this.appFinishing.set(true);
        this.notifyAll();
    }

    @Override
    public synchronized void abortLogAggregation() {
        LOG.info("Aborting log aggregation for " + this.applicationId);
        this.aborted.set(true);
        this.notifyAll();
    }

    @Override
    public void disableLogAggregation() {
        this.logAggregationDisabled = true;
    }

    @Override
    public void enableLogAggregation() {
        this.logAggregationDisabled = false;
    }

    @Override
    public boolean isAggregationEnabled() {
        return !this.logAggregationDisabled;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized void doLogAggregationOutOfBand() {
        while (!this.waiting.get()) {
            try {
                this.wait(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        LOG.info("Do OutOfBand log aggregation");
        this.notifyAll();
    }

    @VisibleForTesting
    public UserGroupInformation getUgi() {
        return this.userUgi;
    }

    @Override
    public UserGroupInformation updateCredentials(Credentials cred) {
        this.userUgi.addCredentials(cred);
        return this.userUgi;
    }

    @VisibleForTesting
    public LogAggregationFileController getLogAggregationFileController() {
        return this.logAggregationFileController;
    }

    @VisibleForTesting
    public LogAggregationFileControllerContext getLogAggregationFileControllerContext() {
        return this.logControllerContext;
    }

    class ContainerLogAggregator {
        private final AggregatedLogFormat.LogRetentionContext retentionContext;
        private final ContainerId containerId;
        private Set<String> uploadedFileMeta = new HashSet<String>();

        public ContainerLogAggregator(ContainerId containerId) {
            this.containerId = containerId;
            this.retentionContext = this.getRetentionContext();
        }

        private AggregatedLogFormat.LogRetentionContext getRetentionContext() {
            long logRetentionSecs = AppLogAggregatorImpl.this.conf.getLong("yarn.log-aggregation.retain-seconds", -1L);
            return new AggregatedLogFormat.LogRetentionContext(AppLogAggregatorImpl.this.recoveredLogInitedTime, logRetentionSecs * 1000L);
        }

        public Set<Path> doContainerLogAggregation(LogAggregationFileController logAggregationFileController, boolean appFinished, boolean containerFinished) {
            LOG.info("Uploading logs for container " + this.containerId + ". Current good log dirs are " + StringUtils.join((CharSequence)",", AppLogAggregatorImpl.this.dirsHandler.getLogDirsForRead()));
            AggregatedLogFormat.LogKey logKey = new AggregatedLogFormat.LogKey(this.containerId);
            AggregatedLogFormat.LogValue logValue = new AggregatedLogFormat.LogValue(AppLogAggregatorImpl.this.dirsHandler.getLogDirsForRead(), this.containerId, AppLogAggregatorImpl.this.userUgi.getShortUserName(), AppLogAggregatorImpl.this.logAggregationContext, this.uploadedFileMeta, this.retentionContext, appFinished, containerFinished);
            try {
                logAggregationFileController.write(logKey, logValue);
            }
            catch (Exception e) {
                LOG.error("Couldn't upload logs for " + this.containerId + ". Skipping this container.", (Throwable)e);
                return new HashSet<Path>();
            }
            this.uploadedFileMeta.addAll(logValue.getCurrentUpLoadedFileMeta());
            this.uploadedFileMeta = this.uploadedFileMeta.stream().filter(next -> logValue.getAllExistingFilesMeta().contains(next)).collect(Collectors.toSet());
            return Sets.union((Set)logValue.getCurrentUpLoadedFilesPath(), (Set)logValue.getObsoleteRetentionLogFiles());
        }
    }
}

