/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.verification;

import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoAssertionError;
import org.apache.hadoop.shaded.org.mockito.internal.verification.api.VerificationData;
import org.apache.hadoop.shaded.org.mockito.verification.VerificationMode;

public class VerificationWithTimeoutImpl {
    VerificationMode delegate;
    int timeout;
    int treshhold;

    public VerificationWithTimeoutImpl(int treshhold, int millis, VerificationMode delegate) {
        this.treshhold = treshhold;
        this.timeout = millis;
        this.delegate = delegate;
    }

    public void verify(VerificationData data) {
        MockitoAssertionError error = null;
        for (int soFar = 0; soFar <= this.timeout; soFar += this.treshhold) {
            try {
                this.delegate.verify(data);
                return;
            }
            catch (MockitoAssertionError e) {
                error = e;
                this.sleep(this.treshhold);
                continue;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    void sleep(int sleep) {
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public VerificationMode getDelegate() {
        return this.delegate;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTreshhold() {
        return this.treshhold;
    }
}

