/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.matchers;

import java.io.Serializable;
import org.apache.hadoop.shaded.org.hamcrest.Description;
import org.apache.hadoop.shaded.org.hamcrest.SelfDescribing;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.ContainsExtraTypeInformation;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.Equality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Equals
extends ArgumentMatcher<Object>
implements ContainsExtraTypeInformation,
Serializable {
    private static final long serialVersionUID = -3395637450058086891L;
    private final Object wanted;

    public Equals(Object wanted) {
        this.wanted = wanted;
    }

    @Override
    public boolean matches(Object actual) {
        return Equality.areEqual(this.wanted, actual);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(this.describe(this.wanted));
    }

    public String describe(Object object) {
        String text = this.quoting();
        text = object == null ? text + "null" : text + object.toString();
        text = text + this.quoting();
        return text;
    }

    private String quoting() {
        if (this.wanted instanceof String) {
            return "\"";
        }
        if (this.wanted instanceof Character) {
            return "'";
        }
        return "";
    }

    protected final Object getWanted() {
        return this.wanted;
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Equals other = (Equals)o;
        return this.wanted == null && other.wanted == null || this.wanted != null && this.wanted.equals(other.wanted);
    }

    public int hashCode() {
        return 1;
    }

    @Override
    public SelfDescribing withExtraTypeInfo() {
        return new SelfDescribing(){

            public void describeTo(Description description) {
                description.appendText(Equals.this.describe("(" + Equals.this.wanted.getClass().getSimpleName() + ") " + Equals.this.wanted));
            }
        };
    }

    @Override
    public boolean typeMatches(Object object) {
        return this.wanted != null && object != null && object.getClass() == this.wanted.getClass();
    }
}

