/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.apache.hadoop.shaded.org.mockito.configuration.AnnotationEngine;
import org.apache.hadoop.shaded.org.mockito.configuration.DefaultMockitoConfiguration;
import org.apache.hadoop.shaded.org.mockito.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.GlobalConfiguration;
import org.apache.hadoop.shaded.org.mockito.internal.util.reflection.FieldSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockitoAnnotations {
    public static void initMocks(Object testClass) {
        if (testClass == null) {
            throw new MockitoException("testClass cannot be null. For info how to use @Mock annotations see examples in javadoc for MockitoAnnotations class");
        }
        for (Class<?> clazz = testClass.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            MockitoAnnotations.scan(testClass, clazz);
        }
    }

    static void scan(Object testClass, Class<?> clazz) {
        Field[] fields;
        AnnotationEngine annotationEngine = new GlobalConfiguration().getAnnotationEngine();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (annotationEngine.getClass() == new DefaultMockitoConfiguration().getAnnotationEngine().getClass()) continue;
            MockitoAnnotations.processAnnotationDeprecatedWay(annotationEngine, testClass, field);
        }
        annotationEngine.process(clazz, testClass);
    }

    static void processAnnotationDeprecatedWay(AnnotationEngine annotationEngine, Object testClass, Field field) {
        boolean alreadyAssigned = false;
        for (Annotation annotation : field.getAnnotations()) {
            Object mock = annotationEngine.createMockFor(annotation, field);
            if (mock == null) continue;
            MockitoAnnotations.throwIfAlreadyAssigned(field, alreadyAssigned);
            alreadyAssigned = true;
            try {
                new FieldSetter(testClass, field).set(mock);
            }
            catch (Exception e) {
                throw new MockitoException("Problems setting field " + field.getName() + " annotated with " + annotation, e);
            }
        }
    }

    static void throwIfAlreadyAssigned(Field field, boolean alreadyAssigned) {
        if (alreadyAssigned) {
            new Reporter().moreThanOneAnnotationNotAllowed(field.getName());
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Deprecated
    public static @interface Mock {
    }
}

