/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.xml;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.apache.hadoop.shaded.org.ehcache.config.ResourcePool;
import org.apache.hadoop.shaded.org.ehcache.config.ResourceType;
import org.apache.hadoop.shaded.org.ehcache.config.ResourceUnit;
import org.apache.hadoop.shaded.org.ehcache.config.SizedResourcePool;
import org.apache.hadoop.shaded.org.ehcache.config.units.EntryUnit;
import org.apache.hadoop.shaded.org.ehcache.config.units.MemoryUnit;
import org.apache.hadoop.shaded.org.ehcache.core.config.SizedResourcePoolImpl;
import org.apache.hadoop.shaded.org.ehcache.core.internal.util.ClassLoading;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceCreationConfiguration;
import org.apache.hadoop.shaded.org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.CacheResourceConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.CacheServiceConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.JaxbHelper;
import org.apache.hadoop.shaded.org.ehcache.xml.XmlConfiguration;
import org.apache.hadoop.shaded.org.ehcache.xml.XmlModel;
import org.apache.hadoop.shaded.org.ehcache.xml.exceptions.XmlConfigurationException;
import org.apache.hadoop.shaded.org.ehcache.xml.model.BaseCacheType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.CacheLoaderWriterType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.CacheTemplateType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.CacheType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ConfigType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.CopierType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.Disk;
import org.apache.hadoop.shaded.org.ehcache.xml.model.DiskStoreSettingsType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.EventFiringType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.EventOrderingType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.EventType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ExpiryType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.Heap;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ListenersType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.MemoryType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ObjectFactory;
import org.apache.hadoop.shaded.org.ehcache.xml.model.Offheap;
import org.apache.hadoop.shaded.org.ehcache.xml.model.PersistableMemoryType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.PersistenceType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ResourceType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ResourcesType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.SerializerType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ServiceType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.SizeofType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ThreadPoolReferenceType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ThreadPoolsType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.TimeType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ConfigurationParser {
    private static final Pattern SYSPROP = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final SchemaFactory XSD_SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final URL CORE_SCHEMA_URL = XmlConfiguration.class.getResource("/ehcache-core.xsd");
    private static final String CORE_SCHEMA_NAMESPACE = "http://www.ehcache.org/v3";
    private static final String CORE_SCHEMA_ROOT_ELEMENT = "config";
    private static final String CORE_SCHEMA_JAXB_MODEL_PACKAGE = ConfigType.class.getPackage().getName();
    private final Map<URI, CacheManagerServiceConfigurationParser<?>> xmlParsers = new HashMap();
    private final Map<URI, CacheServiceConfigurationParser<?>> cacheXmlParsers = new HashMap();
    private final Unmarshaller unmarshaller;
    private final Map<URI, CacheResourceConfigurationParser> resourceXmlParsers = new HashMap<URI, CacheResourceConfigurationParser>();
    private final ConfigType config;

    static String replaceProperties(String originalValue, Properties properties) {
        Matcher matcher = SYSPROP.matcher(originalValue);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String property = matcher.group(1);
            String value = properties.getProperty(property);
            if (value == null) {
                throw new IllegalStateException(String.format("Replacement for ${%s} not found!", property));
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        String resolvedValue = sb.toString();
        return resolvedValue.equals(originalValue) ? null : resolvedValue;
    }

    public ConfigurationParser(String xml) throws IOException, SAXException, JAXBException, ParserConfigurationException {
        ArrayList<Source> schemaSources = new ArrayList<Source>();
        schemaSources.add(new StreamSource(CORE_SCHEMA_URL.openStream()));
        for (CacheManagerServiceConfigurationParser cacheManagerServiceConfigurationParser : ClassLoading.libraryServiceLoaderFor(CacheManagerServiceConfigurationParser.class)) {
            schemaSources.add(cacheManagerServiceConfigurationParser.getXmlSchema());
            this.xmlParsers.put(cacheManagerServiceConfigurationParser.getNamespace(), cacheManagerServiceConfigurationParser);
        }
        for (CacheServiceConfigurationParser cacheServiceConfigurationParser : ClassLoading.libraryServiceLoaderFor(CacheServiceConfigurationParser.class)) {
            schemaSources.add(cacheServiceConfigurationParser.getXmlSchema());
            this.cacheXmlParsers.put(cacheServiceConfigurationParser.getNamespace(), cacheServiceConfigurationParser);
        }
        for (CacheResourceConfigurationParser cacheResourceConfigurationParser : ClassLoading.libraryServiceLoaderFor(CacheResourceConfigurationParser.class)) {
            schemaSources.add(cacheResourceConfigurationParser.getXmlSchema());
            this.resourceXmlParsers.put(cacheResourceConfigurationParser.getNamespace(), cacheResourceConfigurationParser);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(XSD_SCHEMA_FACTORY.newSchema(schemaSources.toArray(new Source[schemaSources.size()])));
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new FatalErrorHandler());
        Element dom = documentBuilder.parse(xml).getDocumentElement();
        this.substituteSystemProperties(dom);
        if (!CORE_SCHEMA_ROOT_ELEMENT.equals(dom.getLocalName()) || !CORE_SCHEMA_NAMESPACE.equals(dom.getNamespaceURI())) {
            throw new XmlConfigurationException("Expecting {http://www.ehcache.org/v3}config element; found {" + dom.getNamespaceURI() + "}" + dom.getLocalName());
        }
        Class<ConfigType> configTypeClass = ConfigType.class;
        JAXBContext jc = JAXBContext.newInstance((String)CORE_SCHEMA_JAXB_MODEL_PACKAGE, (ClassLoader)configTypeClass.getClassLoader());
        this.unmarshaller = jc.createUnmarshaller();
        this.config = (ConfigType)this.unmarshaller.unmarshal((Node)dom, configTypeClass).getValue();
    }

    private void substituteSystemProperties(Element dom) {
        Properties properties = System.getProperties();
        Stack<NodeList> nodeLists = new Stack<NodeList>();
        nodeLists.push(dom.getChildNodes());
        while (!nodeLists.isEmpty()) {
            NodeList nodeList = (NodeList)nodeLists.pop();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String newValue;
                NamedNodeMap attributes;
                Node currentNode = nodeList.item(i);
                if (currentNode.hasChildNodes()) {
                    nodeLists.push(currentNode.getChildNodes());
                }
                if ((attributes = currentNode.getAttributes()) != null) {
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Node attributeNode = attributes.item(j);
                        String newValue2 = ConfigurationParser.replaceProperties(attributeNode.getNodeValue(), properties);
                        if (newValue2 == null) continue;
                        attributeNode.setNodeValue(newValue2);
                    }
                }
                if (currentNode.getNodeType() != 3 || (newValue = ConfigurationParser.replaceProperties(currentNode.getNodeValue(), properties)) == null) continue;
                currentNode.setNodeValue(newValue);
            }
        }
    }

    public Iterable<ServiceType> getServiceElements() {
        return this.config.getService();
    }

    public SerializerType getDefaultSerializers() {
        return this.config.getDefaultSerializers();
    }

    public CopierType getDefaultCopiers() {
        return this.config.getDefaultCopiers();
    }

    public PersistenceType getPersistence() {
        return this.config.getPersistence();
    }

    public ThreadPoolReferenceType getEventDispatch() {
        return this.config.getEventDispatch();
    }

    public ThreadPoolReferenceType getWriteBehind() {
        return this.config.getWriteBehind();
    }

    public ThreadPoolReferenceType getDiskStore() {
        return this.config.getDiskStore();
    }

    public ThreadPoolsType getThreadPools() {
        return this.config.getThreadPools();
    }

    public SizeOfEngineLimits getHeapStore() {
        SizeofType type = this.config.getHeapStore();
        return type == null ? null : new XmlSizeOfEngineLimits(type);
    }

    public Iterable<CacheDefinition> getCacheElements() {
        ArrayList<1> cacheCfgs = new ArrayList<1>();
        List<BaseCacheType> cacheOrCacheTemplate = this.config.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheType)) continue;
            final CacheType cacheType = (CacheType)baseCacheType;
            final BaseCacheType[] sources = cacheType.getUsesTemplate() != null ? new BaseCacheType[]{cacheType, (BaseCacheType)cacheType.getUsesTemplate()} : new BaseCacheType[]{cacheType};
            cacheCfgs.add(new CacheDefinition(){

                @Override
                public String id() {
                    return cacheType.getAlias();
                }

                @Override
                public String keyType() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getKeyType() != null ? source.getKeyType().getValue() : null;
                        if (value != null) break;
                    }
                    if (value == null) {
                        BaseCacheType source;
                        BaseCacheType[] arr$ = sources;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (value = JaxbHelper.findDefaultValue(source = arr$[i$], "keyType")) == null; ++i$) {
                        }
                    }
                    return value;
                }

                @Override
                public String keySerializer() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getKeyType() != null ? source.getKeyType().getSerializer() : null;
                        if (value != null) break;
                    }
                    return value;
                }

                @Override
                public String keyCopier() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getKeyType() != null ? source.getKeyType().getCopier() : null;
                        if (value != null) break;
                    }
                    return value;
                }

                @Override
                public String valueType() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getValueType() != null ? source.getValueType().getValue() : null;
                        if (value != null) break;
                    }
                    if (value == null) {
                        BaseCacheType source;
                        BaseCacheType[] arr$ = sources;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (value = JaxbHelper.findDefaultValue(source = arr$[i$], "valueType")) == null; ++i$) {
                        }
                    }
                    return value;
                }

                @Override
                public String valueSerializer() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getValueType() != null ? source.getValueType().getSerializer() : null;
                        if (value != null) break;
                    }
                    return value;
                }

                @Override
                public String valueCopier() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getValueType() != null ? source.getValueType().getCopier() : null;
                        if (value != null) break;
                    }
                    return value;
                }

                @Override
                public String evictionAdvisor() {
                    BaseCacheType source;
                    String value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getEvictionAdvisor()) == null; ++i$) {
                    }
                    return value;
                }

                @Override
                public Expiry expiry() {
                    BaseCacheType source;
                    ExpiryType value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getExpiry()) == null; ++i$) {
                    }
                    if (value != null) {
                        return new XmlExpiry(value);
                    }
                    return null;
                }

                @Override
                public String loaderWriter() {
                    String configClass = null;
                    for (BaseCacheType source : sources) {
                        CacheLoaderWriterType loaderWriter = source.getLoaderWriter();
                        if (loaderWriter == null) continue;
                        configClass = loaderWriter.getClazz();
                        break;
                    }
                    return configClass;
                }

                @Override
                public ListenersConfig listenersConfig() {
                    ListenersType base = null;
                    ArrayList<ListenersType> additionals = new ArrayList<ListenersType>();
                    for (BaseCacheType source : sources) {
                        if (source.getListeners() == null) continue;
                        if (base == null) {
                            base = source.getListeners();
                            continue;
                        }
                        additionals.add(source.getListeners());
                    }
                    return base != null ? new XmlListenersConfig(base, additionals.toArray(new ListenersType[0])) : null;
                }

                @Override
                public Iterable<ServiceConfiguration<?>> serviceConfigs() {
                    HashMap configsMap = new HashMap();
                    for (BaseCacheType source : sources) {
                        for (Element child : source.getServiceConfiguration()) {
                            ServiceConfiguration<?> serviceConfiguration = ConfigurationParser.this.parseCacheExtension(child);
                            if (configsMap.containsKey(serviceConfiguration.getClass())) continue;
                            configsMap.put(serviceConfiguration.getClass(), serviceConfiguration);
                        }
                    }
                    return configsMap.values();
                }

                @Override
                public Collection<ResourcePool> resourcePools() {
                    for (BaseCacheType source : sources) {
                        Heap heapResource = source.getHeap();
                        if (heapResource != null) {
                            return Collections.singleton(ConfigurationParser.this.parseResource(heapResource));
                        }
                        ResourcesType resources = source.getResources();
                        if (resources == null) continue;
                        return ConfigurationParser.this.parseResources(resources);
                    }
                    return Collections.emptySet();
                }

                @Override
                public WriteBehind writeBehind() {
                    for (BaseCacheType source : sources) {
                        CacheLoaderWriterType.WriteBehind writebehind;
                        CacheLoaderWriterType loaderWriter = source.getLoaderWriter();
                        CacheLoaderWriterType.WriteBehind writeBehind = writebehind = loaderWriter != null ? loaderWriter.getWriteBehind() : null;
                        if (writebehind == null) continue;
                        return new XmlWriteBehind(writebehind);
                    }
                    return null;
                }

                @Override
                public DiskStoreSettings diskStoreSettings() {
                    BaseCacheType source;
                    DiskStoreSettingsType value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getDiskStoreSettings()) == null; ++i$) {
                    }
                    if (value != null) {
                        return new XmlDiskStoreSettings(value);
                    }
                    return null;
                }

                @Override
                public SizeOfEngineLimits heapStoreSettings() {
                    BaseCacheType source;
                    SizeofType sizeofType = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (sizeofType = (source = arr$[i$]).getHeapStoreSettings()) == null; ++i$) {
                    }
                    return sizeofType != null ? new XmlSizeOfEngineLimits(sizeofType) : null;
                }
            });
        }
        return Collections.unmodifiableList(cacheCfgs);
    }

    public Map<String, CacheTemplate> getTemplates() {
        HashMap<String, 2> templates = new HashMap<String, 2>();
        List<BaseCacheType> cacheOrCacheTemplate = this.config.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheTemplateType)) continue;
            final CacheTemplateType cacheTemplate = (CacheTemplateType)baseCacheType;
            templates.put(cacheTemplate.getName(), new CacheTemplate(){

                @Override
                public String keyType() {
                    String keyType;
                    String string = keyType = cacheTemplate.getKeyType() != null ? cacheTemplate.getKeyType().getValue() : null;
                    if (keyType == null) {
                        keyType = JaxbHelper.findDefaultValue(cacheTemplate, "keyType");
                    }
                    return keyType;
                }

                @Override
                public String keySerializer() {
                    return cacheTemplate.getKeyType() != null ? cacheTemplate.getKeyType().getSerializer() : null;
                }

                @Override
                public String keyCopier() {
                    return cacheTemplate.getKeyType() != null ? cacheTemplate.getKeyType().getCopier() : null;
                }

                @Override
                public String valueType() {
                    String valueType;
                    String string = valueType = cacheTemplate.getValueType() != null ? cacheTemplate.getValueType().getValue() : null;
                    if (valueType == null) {
                        valueType = JaxbHelper.findDefaultValue(cacheTemplate, "valueType");
                    }
                    return valueType;
                }

                @Override
                public String valueSerializer() {
                    return cacheTemplate.getValueType() != null ? cacheTemplate.getValueType().getSerializer() : null;
                }

                @Override
                public String valueCopier() {
                    return cacheTemplate.getValueType() != null ? cacheTemplate.getValueType().getCopier() : null;
                }

                @Override
                public String evictionAdvisor() {
                    return cacheTemplate.getEvictionAdvisor();
                }

                @Override
                public Expiry expiry() {
                    ExpiryType cacheTemplateExpiry = cacheTemplate.getExpiry();
                    if (cacheTemplateExpiry != null) {
                        return new XmlExpiry(cacheTemplateExpiry);
                    }
                    return null;
                }

                @Override
                public ListenersConfig listenersConfig() {
                    ListenersType integration = cacheTemplate.getListeners();
                    return integration != null ? new XmlListenersConfig(integration, new ListenersType[0]) : null;
                }

                @Override
                public String loaderWriter() {
                    CacheLoaderWriterType loaderWriter = cacheTemplate.getLoaderWriter();
                    return loaderWriter != null ? loaderWriter.getClazz() : null;
                }

                @Override
                public Iterable<ServiceConfiguration<?>> serviceConfigs() {
                    ArrayList configs = new ArrayList();
                    for (Element child : cacheTemplate.getServiceConfiguration()) {
                        configs.add(ConfigurationParser.this.parseCacheExtension(child));
                    }
                    return configs;
                }

                @Override
                public Collection<ResourcePool> resourcePools() {
                    Heap heapResource = cacheTemplate.getHeap();
                    if (heapResource != null) {
                        return Collections.singleton(ConfigurationParser.this.parseResource(heapResource));
                    }
                    ResourcesType resources = cacheTemplate.getResources();
                    if (resources != null) {
                        return ConfigurationParser.this.parseResources(resources);
                    }
                    return Collections.emptySet();
                }

                @Override
                public WriteBehind writeBehind() {
                    CacheLoaderWriterType loaderWriter = cacheTemplate.getLoaderWriter();
                    CacheLoaderWriterType.WriteBehind writebehind = loaderWriter != null ? loaderWriter.getWriteBehind() : null;
                    return writebehind != null ? new XmlWriteBehind(writebehind) : null;
                }

                @Override
                public DiskStoreSettings diskStoreSettings() {
                    DiskStoreSettingsType diskStoreSettings = cacheTemplate.getDiskStoreSettings();
                    return diskStoreSettings == null ? null : new XmlDiskStoreSettings(diskStoreSettings);
                }

                @Override
                public SizeOfEngineLimits heapStoreSettings() {
                    SizeofType type = cacheTemplate.getHeapStoreSettings();
                    return type == null ? null : new XmlSizeOfEngineLimits(type);
                }
            });
        }
        return Collections.unmodifiableMap(templates);
    }

    private Collection<ResourcePool> parseResources(ResourcesType resources) {
        ArrayList<ResourcePool> resourcePools = new ArrayList<ResourcePool>();
        for (Element resource : resources.getResource()) {
            resourcePools.add(this.parseResource(resource));
        }
        return resourcePools;
    }

    private ResourcePool parseResource(Heap resource) {
        ResourceType heapResource = (ResourceType)resource.getValue();
        return new SizedResourcePoolImpl<SizedResourcePool>(ResourceType.Core.HEAP, heapResource.getValue().longValue(), ConfigurationParser.parseUnit(heapResource), false);
    }

    private ResourcePool parseResource(Element element) {
        if (!CORE_SCHEMA_NAMESPACE.equals(element.getNamespaceURI())) {
            return this.parseResourceExtension(element);
        }
        try {
            Object resource = this.unmarshaller.unmarshal((Node)element);
            if (resource instanceof Heap) {
                ResourceType heapResource = (ResourceType)((Heap)((Object)resource)).getValue();
                return new SizedResourcePoolImpl<SizedResourcePool>(ResourceType.Core.HEAP, heapResource.getValue().longValue(), ConfigurationParser.parseUnit(heapResource), false);
            }
            if (resource instanceof Offheap) {
                MemoryType offheapResource = (MemoryType)((Offheap)((Object)resource)).getValue();
                return new SizedResourcePoolImpl<SizedResourcePool>(ResourceType.Core.OFFHEAP, offheapResource.getValue().longValue(), ConfigurationParser.parseMemory(offheapResource), false);
            }
            if (resource instanceof Disk) {
                PersistableMemoryType diskResource = (PersistableMemoryType)((Disk)((Object)resource)).getValue();
                return new SizedResourcePoolImpl<SizedResourcePool>(ResourceType.Core.DISK, diskResource.getValue().longValue(), ConfigurationParser.parseMemory(diskResource), diskResource.isPersistent());
            }
            throw new AssertionError((Object)("Unrecognized resource: " + element + " / " + resource.getClass().getName()));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Can't find parser for resource: " + element, e);
        }
    }

    private static ResourceUnit parseUnit(ResourceType resourceType) {
        if (resourceType.getUnit().value().equalsIgnoreCase("entries")) {
            return EntryUnit.ENTRIES;
        }
        return MemoryUnit.valueOf(resourceType.getUnit().value().toUpperCase());
    }

    private static MemoryUnit parseMemory(MemoryType memoryType) {
        return MemoryUnit.valueOf(memoryType.getUnit().value().toUpperCase());
    }

    ServiceCreationConfiguration<?> parseExtension(Element element) {
        URI namespace = URI.create(element.getNamespaceURI());
        CacheManagerServiceConfigurationParser<?> cacheManagerServiceConfigurationParser = this.xmlParsers.get(namespace);
        if (cacheManagerServiceConfigurationParser == null) {
            throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
        }
        return cacheManagerServiceConfigurationParser.parseServiceCreationConfiguration(element);
    }

    ServiceConfiguration<?> parseCacheExtension(Element element) {
        URI namespace = URI.create(element.getNamespaceURI());
        CacheServiceConfigurationParser<?> xmlConfigurationParser = this.cacheXmlParsers.get(namespace);
        if (xmlConfigurationParser == null) {
            throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
        }
        return xmlConfigurationParser.parseServiceConfiguration(element);
    }

    ResourcePool parseResourceExtension(Element element) {
        URI namespace = URI.create(element.getNamespaceURI());
        CacheResourceConfigurationParser xmlConfigurationParser = this.resourceXmlParsers.get(namespace);
        if (xmlConfigurationParser == null) {
            throw new XmlConfigurationException("Can't find parser for namespace: " + namespace);
        }
        return xmlConfigurationParser.parseResourceConfiguration(element);
    }

    private static class XmlDiskStoreSettings
    implements DiskStoreSettings {
        private final DiskStoreSettingsType diskStoreSettings;

        private XmlDiskStoreSettings(DiskStoreSettingsType diskStoreSettings) {
            this.diskStoreSettings = diskStoreSettings;
        }

        @Override
        public int writerConcurrency() {
            return this.diskStoreSettings.getWriterConcurrency().intValue();
        }

        @Override
        public String threadPool() {
            return this.diskStoreSettings.getThreadPool();
        }
    }

    private static class XmlBatching
    implements Batching {
        private final CacheLoaderWriterType.WriteBehind.Batching batching;

        private XmlBatching(CacheLoaderWriterType.WriteBehind.Batching batching) {
            this.batching = batching;
        }

        @Override
        public boolean isCoalesced() {
            return this.batching.isCoalesce();
        }

        @Override
        public int batchSize() {
            return this.batching.getBatchSize().intValue();
        }

        @Override
        public long maxDelay() {
            return this.batching.getMaxWriteDelay().getValue().longValue();
        }

        @Override
        public TimeUnit maxDelayUnit() {
            return XmlModel.convertToJavaTimeUnit(this.batching.getMaxWriteDelay().getUnit());
        }
    }

    private static class XmlWriteBehind
    implements WriteBehind {
        private final CacheLoaderWriterType.WriteBehind writebehind;

        private XmlWriteBehind(CacheLoaderWriterType.WriteBehind writebehind) {
            this.writebehind = writebehind;
        }

        @Override
        public int maxQueueSize() {
            return this.writebehind.getSize().intValue();
        }

        @Override
        public int concurrency() {
            return this.writebehind.getConcurrency().intValue();
        }

        @Override
        public String threadPool() {
            return this.writebehind.getThreadPool();
        }

        @Override
        public Batching batching() {
            CacheLoaderWriterType.WriteBehind.Batching batching = this.writebehind.getBatching();
            if (batching == null) {
                return null;
            }
            return new XmlBatching(batching);
        }
    }

    private static class XmlSizeOfEngineLimits
    implements SizeOfEngineLimits {
        private final SizeofType sizeoflimits;

        private XmlSizeOfEngineLimits(SizeofType sizeoflimits) {
            this.sizeoflimits = sizeoflimits;
        }

        @Override
        public long getMaxObjectGraphSize() {
            SizeofType.MaxObjectGraphSize value = this.sizeoflimits.getMaxObjectGraphSize();
            if (value == null) {
                return new BigInteger(JaxbHelper.findDefaultValue(this.sizeoflimits, "maxObjectGraphSize")).longValue();
            }
            return value.getValue().longValue();
        }

        @Override
        public long getMaxObjectSize() {
            MemoryType value = this.sizeoflimits.getMaxObjectSize();
            if (value == null) {
                return new BigInteger(JaxbHelper.findDefaultValue(this.sizeoflimits, "maxObjectSize")).longValue();
            }
            return value.getValue().longValue();
        }

        @Override
        public MemoryUnit getUnit() {
            MemoryType value = this.sizeoflimits.getMaxObjectSize();
            if (value == null) {
                return MemoryUnit.valueOf(new ObjectFactory().createMemoryType().getUnit().value().toUpperCase());
            }
            return MemoryUnit.valueOf(value.getUnit().value().toUpperCase());
        }
    }

    private static class XmlExpiry
    implements Expiry {
        final ExpiryType type;

        private XmlExpiry(ExpiryType type) {
            this.type = type;
        }

        @Override
        public boolean isUserDef() {
            return this.type != null && this.type.getClazz() != null;
        }

        @Override
        public boolean isTTI() {
            return this.type != null && this.type.getTti() != null;
        }

        @Override
        public boolean isTTL() {
            return this.type != null && this.type.getTtl() != null;
        }

        @Override
        public String type() {
            return this.type.getClazz();
        }

        @Override
        public long value() {
            TimeType time = this.isTTI() ? this.type.getTti() : this.type.getTtl();
            return time == null ? 0L : time.getValue().longValue();
        }

        @Override
        public TimeUnit unit() {
            TimeType time = this.isTTI() ? this.type.getTti() : this.type.getTtl();
            if (time != null) {
                return XmlModel.convertToJavaTimeUnit(time.getUnit());
            }
            return null;
        }
    }

    private static class XmlListenersConfig
    implements ListenersConfig {
        final int dispatcherConcurrency;
        final String threadPool;
        final Iterable<Listener> listeners;

        private XmlListenersConfig(ListenersType type, ListenersType ... others) {
            this.dispatcherConcurrency = type.getDispatcherConcurrency().intValue();
            String threadPool = type.getDispatcherThreadPool();
            HashSet<Listener> listenerSet = new HashSet<Listener>();
            List<ListenersType.Listener> xmlListeners = type.getListener();
            this.extractListeners(listenerSet, xmlListeners);
            for (ListenersType other : others) {
                if (threadPool == null && other.getDispatcherThreadPool() != null) {
                    threadPool = other.getDispatcherThreadPool();
                }
                this.extractListeners(listenerSet, other.getListener());
            }
            this.threadPool = threadPool;
            this.listeners = !listenerSet.isEmpty() ? listenerSet : null;
        }

        private void extractListeners(Set<Listener> listenerSet, List<ListenersType.Listener> xmlListeners) {
            if (xmlListeners != null) {
                for (final ListenersType.Listener listener : xmlListeners) {
                    listenerSet.add(new Listener(){

                        @Override
                        public String className() {
                            return listener.getClazz();
                        }

                        @Override
                        public EventFiringType eventFiring() {
                            return listener.getEventFiringMode();
                        }

                        @Override
                        public EventOrderingType eventOrdering() {
                            return listener.getEventOrderingMode();
                        }

                        @Override
                        public List<EventType> fireOn() {
                            return listener.getEventsToFireOn();
                        }
                    });
                }
            }
        }

        @Override
        public int dispatcherConcurrency() {
            return this.dispatcherConcurrency;
        }

        @Override
        public String threadPool() {
            return this.threadPool;
        }

        @Override
        public Iterable<Listener> listeners() {
            return this.listeners;
        }
    }

    static interface SizeOfEngineLimits {
        public long getMaxObjectGraphSize();

        public long getMaxObjectSize();

        public MemoryUnit getUnit();
    }

    static interface DiskStoreSettings {
        public int writerConcurrency();

        public String threadPool();
    }

    static interface Batching {
        public boolean isCoalesced();

        public int batchSize();

        public long maxDelay();

        public TimeUnit maxDelayUnit();
    }

    static interface WriteBehind {
        public int maxQueueSize();

        public int concurrency();

        public String threadPool();

        public Batching batching();
    }

    static interface Expiry {
        public boolean isUserDef();

        public boolean isTTI();

        public boolean isTTL();

        public String type();

        public long value();

        public TimeUnit unit();
    }

    static interface Listener {
        public String className();

        public EventFiringType eventFiring();

        public EventOrderingType eventOrdering();

        public List<EventType> fireOn();
    }

    static interface ListenersConfig {
        public int dispatcherConcurrency();

        public String threadPool();

        public Iterable<Listener> listeners();
    }

    static interface CacheDefinition
    extends CacheTemplate {
        public String id();
    }

    static interface CacheTemplate {
        public String keyType();

        public String keySerializer();

        public String keyCopier();

        public String valueType();

        public String valueSerializer();

        public String valueCopier();

        public String evictionAdvisor();

        public Expiry expiry();

        public String loaderWriter();

        public ListenersConfig listenersConfig();

        public Iterable<ServiceConfiguration<?>> serviceConfigs();

        public Collection<ResourcePool> resourcePools();

        public WriteBehind writeBehind();

        public DiskStoreSettings diskStoreSettings();

        public SizeOfEngineLimits heapStoreSettings();
    }

    static class FatalErrorHandler
    implements ErrorHandler {
        FatalErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

