/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.shaded.org.mockito.Matchers;
import org.apache.hadoop.shaded.org.mockito.Mockito;
import org.junit.Assert;
import org.junit.Test;

public class JobClientUnitTest {
    @Test
    public void testMapTaskReportsWithNullJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        Cluster mockCluster = Mockito.mock(Cluster.class);
        client.setCluster(mockCluster);
        JobID id = new JobID("test", 0);
        Mockito.when(mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)id)).thenReturn(null);
        org.apache.hadoop.mapred.TaskReport[] result = client.getMapTaskReports(id);
        Assert.assertEquals((long)0L, (long)result.length);
        Mockito.verify(mockCluster).getJob((org.apache.hadoop.mapreduce.JobID)id);
    }

    @Test
    public void testReduceTaskReportsWithNullJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        Cluster mockCluster = Mockito.mock(Cluster.class);
        client.setCluster(mockCluster);
        JobID id = new JobID("test", 0);
        Mockito.when(mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)id)).thenReturn(null);
        org.apache.hadoop.mapred.TaskReport[] result = client.getReduceTaskReports(id);
        Assert.assertEquals((long)0L, (long)result.length);
        Mockito.verify(mockCluster).getJob((org.apache.hadoop.mapreduce.JobID)id);
    }

    @Test
    public void testSetupTaskReportsWithNullJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        Cluster mockCluster = Mockito.mock(Cluster.class);
        client.setCluster(mockCluster);
        JobID id = new JobID("test", 0);
        Mockito.when(mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)id)).thenReturn(null);
        org.apache.hadoop.mapred.TaskReport[] result = client.getSetupTaskReports(id);
        Assert.assertEquals((long)0L, (long)result.length);
        Mockito.verify(mockCluster).getJob((org.apache.hadoop.mapreduce.JobID)id);
    }

    @Test
    public void testCleanupTaskReportsWithNullJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        Cluster mockCluster = Mockito.mock(Cluster.class);
        client.setCluster(mockCluster);
        JobID id = new JobID("test", 0);
        Mockito.when(mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)id)).thenReturn(null);
        org.apache.hadoop.mapred.TaskReport[] result = client.getCleanupTaskReports(id);
        Assert.assertEquals((long)0L, (long)result.length);
        Mockito.verify(mockCluster).getJob((org.apache.hadoop.mapreduce.JobID)id);
    }

    @Test
    public void testShowJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        long startTime = System.currentTimeMillis();
        JobID jobID = new JobID(String.valueOf(startTime), 12345);
        JobStatus mockJobStatus = Mockito.mock(JobStatus.class);
        Mockito.when(mockJobStatus.getJobID()).thenReturn((org.apache.hadoop.mapreduce.JobID)jobID);
        Mockito.when(mockJobStatus.getJobName()).thenReturn(jobID.toString());
        Mockito.when(mockJobStatus.getState()).thenReturn(JobStatus.State.RUNNING);
        Mockito.when(mockJobStatus.getStartTime()).thenReturn(startTime);
        Mockito.when(mockJobStatus.getUsername()).thenReturn("mockuser");
        Mockito.when(mockJobStatus.getQueue()).thenReturn("mockqueue");
        Mockito.when(mockJobStatus.getPriority()).thenReturn(JobPriority.NORMAL);
        Mockito.when(mockJobStatus.getNumUsedSlots()).thenReturn(1);
        Mockito.when(mockJobStatus.getNumReservedSlots()).thenReturn(1);
        Mockito.when(mockJobStatus.getUsedMem()).thenReturn(1024);
        Mockito.when(mockJobStatus.getReservedMem()).thenReturn(512);
        Mockito.when(mockJobStatus.getNeededMem()).thenReturn(2048);
        Mockito.when(mockJobStatus.getSchedulingInfo()).thenReturn("NA");
        Job mockJob = Mockito.mock(Job.class);
        Mockito.when(mockJob.getTaskReports(Matchers.isA(TaskType.class))).thenReturn(new TaskReport[5]);
        Cluster mockCluster = Mockito.mock(Cluster.class);
        Mockito.when(mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)jobID)).thenReturn(mockJob);
        client.setCluster(mockCluster);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        client.displayJobList(new JobStatus[]{mockJobStatus}, new PrintWriter(out));
        String commandLineOutput = out.toString();
        System.out.println(commandLineOutput);
        Assert.assertTrue((boolean)commandLineOutput.contains("Total jobs:1"));
        Mockito.verify(mockJobStatus, Mockito.atLeastOnce()).getJobID();
        Mockito.verify(mockJobStatus).getState();
        Mockito.verify(mockJobStatus).getStartTime();
        Mockito.verify(mockJobStatus).getUsername();
        Mockito.verify(mockJobStatus).getQueue();
        Mockito.verify(mockJobStatus).getPriority();
        Mockito.verify(mockJobStatus).getNumUsedSlots();
        Mockito.verify(mockJobStatus).getNumReservedSlots();
        Mockito.verify(mockJobStatus).getUsedMem();
        Mockito.verify(mockJobStatus).getReservedMem();
        Mockito.verify(mockJobStatus).getNeededMem();
        Mockito.verify(mockJobStatus).getSchedulingInfo();
        Mockito.verify(mockCluster, Mockito.never()).getJob((org.apache.hadoop.mapreduce.JobID)jobID);
        Mockito.verify(mockJob, Mockito.never()).getTaskReports(Matchers.isA(TaskType.class));
    }

    @Test
    public void testGetJobWithUnknownJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        Cluster mockCluster = Mockito.mock(Cluster.class);
        client.setCluster(mockCluster);
        JobID id = new JobID("unknown", 0);
        Mockito.when(mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)id)).thenReturn(null);
        Assert.assertNull((Object)client.getJob(id));
    }

    @Test
    public void testGetJobRetry() throws Exception {
        JobConf conf = new JobConf();
        conf.setInt("yarn.app.mapreduce.client.job.max-retries", 2);
        TestJobClientGetJob client = new TestJobClientGetJob(conf);
        JobID id = new JobID("ajob", 1);
        RunningJob rj = Mockito.mock(RunningJob.class);
        client.setRunningJob(rj);
        Assert.assertNotNull((Object)client.getJob(id));
        Assert.assertEquals((long)client.getLastGetJobRetriesCounter(), (long)0L);
        client.setGetJobRetries(2);
        Assert.assertNotNull((Object)client.getJob(id));
        Assert.assertEquals((long)client.getLastGetJobRetriesCounter(), (long)2L);
        client.setGetJobRetries(3);
        Assert.assertNull((Object)client.getJob(id));
    }

    @Test
    public void testGetJobRetryDefault() throws Exception {
        JobConf conf = new JobConf();
        TestJobClientGetJob client = new TestJobClientGetJob(conf);
        JobID id = new JobID("ajob", 1);
        RunningJob rj = Mockito.mock(RunningJob.class);
        client.setRunningJob(rj);
        client.setGetJobRetries(3);
        Assert.assertNotNull((Object)client.getJob(id));
        Assert.assertEquals((long)client.getLastGetJobRetriesCounter(), (long)3L);
        client.setGetJobRetries(4);
        Assert.assertNull((Object)client.getJob(id));
    }

    public class TestJobClientGetJob
    extends TestJobClient {
        int lastGetJobRetriesCounter;
        int getJobRetriesCounter;
        int getJobRetries;
        RunningJob runningJob;

        TestJobClientGetJob(JobConf jobConf) throws IOException {
            super(jobConf);
            this.lastGetJobRetriesCounter = 0;
            this.getJobRetriesCounter = 0;
            this.getJobRetries = 0;
        }

        public int getLastGetJobRetriesCounter() {
            return this.lastGetJobRetriesCounter;
        }

        public void setGetJobRetries(int getJobRetries) {
            this.getJobRetries = getJobRetries;
        }

        public void setRunningJob(RunningJob runningJob) {
            this.runningJob = runningJob;
        }

        protected RunningJob getJobInner(JobID jobid) throws IOException {
            if (this.getJobRetriesCounter >= this.getJobRetries) {
                this.lastGetJobRetriesCounter = this.getJobRetriesCounter;
                this.getJobRetriesCounter = 0;
                return this.runningJob;
            }
            ++this.getJobRetriesCounter;
            return null;
        }
    }

    public class TestJobClient
    extends JobClient {
        TestJobClient(JobConf jobConf) throws IOException {
            super(jobConf);
        }

        void setCluster(Cluster cluster) {
            this.cluster = cluster;
        }
    }
}

