/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.top;

import java.net.InetAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.hdfs.server.namenode.top.metrics.TopMetrics;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TopAuditLogger
implements AuditLogger {
    public static final Logger LOG = LoggerFactory.getLogger(TopAuditLogger.class);
    private final TopMetrics topMetrics;

    public TopAuditLogger(TopMetrics topMetrics) {
        Preconditions.checkNotNull((Object)topMetrics, (Object)"Cannot init with a null TopMetrics");
        this.topMetrics = topMetrics;
    }

    @Override
    public void initialize(Configuration conf) {
    }

    @Override
    public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status) {
        try {
            this.topMetrics.report(succeeded, userName, addr, cmd, src, dst, status);
        }
        catch (Throwable t) {
            LOG.error("An error occurred while reflecting the event in top service, event: (cmd={},userName={})", (Object)cmd, (Object)userName);
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("allowed=").append(succeeded).append("\t");
            sb.append("ugi=").append(userName).append("\t");
            sb.append("ip=").append(addr).append("\t");
            sb.append("cmd=").append(cmd).append("\t");
            sb.append("src=").append(src).append("\t");
            sb.append("dst=").append(dst).append("\t");
            if (null == status) {
                sb.append("perm=null");
            } else {
                sb.append("perm=");
                sb.append(status.getOwner()).append(":");
                sb.append(status.getGroup()).append(":");
                sb.append(status.getPermission());
            }
            LOG.debug("------------------- logged event for top service: " + sb);
        }
    }
}

