/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileNameGenerator;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.util.VersionInfo;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NNThroughputBenchmark
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(NNThroughputBenchmark.class);
    private static final int BLOCK_SIZE = 16;
    private static final String GENERAL_OPTIONS_USAGE = "[-keepResults] | [-logLevel L] | [-UGCacheRefreshCount G]";
    static Configuration config;
    static NameNode nameNode;
    static NamenodeProtocol nameNodeProto;
    static ClientProtocol clientProto;
    static DatanodeProtocol dataNodeProto;
    static RefreshUserMappingsProtocol refreshUserMappingsProto;
    static String bpid;

    NNThroughputBenchmark(Configuration conf) throws IOException {
        config = conf;
        config.setInt("dfs.datanode.handler.count", 1);
        config.setInt("dfs.namenode.fs-limits.min-block-size", 0);
        config.set("dfs.hosts.exclude", "${hadoop.tmp.dir}/dfs/hosts/exclude");
        File excludeFile = new File(config.get("dfs.hosts.exclude", "exclude"));
        if (!(excludeFile.exists() || excludeFile.getParentFile().exists() || excludeFile.getParentFile().mkdirs())) {
            throw new IOException("NNThroughputBenchmark: cannot mkdir " + excludeFile);
        }
        new FileOutputStream(excludeFile).close();
        config.set("dfs.hosts", "${hadoop.tmp.dir}/dfs/hosts/include");
        File includeFile = new File(config.get("dfs.hosts", "include"));
        new FileOutputStream(includeFile).close();
    }

    void close() {
        if (nameNode != null) {
            nameNode.stop();
        }
    }

    static void setNameNodeLoggingLevel(Level logLevel) {
        LOG.error("Log level = " + logLevel.toString());
        DFSTestUtil.setNameNodeLogLevel(logLevel);
        GenericTestUtils.setLogLevel(LogManager.getLogger((String)NetworkTopology.class.getName()), logLevel);
        GenericTestUtils.setLogLevel(LogManager.getLogger((String)Groups.class.getName()), logLevel);
    }

    static void printUsage() {
        System.err.println("Usage: NNThroughputBenchmark\n\t-op all <other ops options> | \n\t-op create [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-close] | \n\t-op mkdirs [-threads T] [-dirs N] [-dirsPerDir P] | \n\t-op open [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-useExisting] | \n\t-op delete [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-useExisting] | \n\t-op fileStatus [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-useExisting] | \n\t-op rename [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-useExisting] | \n\t-op blockReport [-datanodes T] [-reports N] [-blocksPerReport B] [-blocksPerFile F] [-blockSize S] | \n\t-op replication [-datanodes T] [-nodesToDecommission D] [-nodeReplicationLimit C] [-totalBlocks B] [-blockSize S] [-replication R] | \n\t-op clean | \n\t[-keepResults] | [-logLevel L] | [-UGCacheRefreshCount G]");
        System.err.println();
        GenericOptionsParser.printGenericCommandUsage((PrintStream)System.err);
        System.err.println("If connecting to a remote NameNode with -fs option, dfs.namenode.fs-limits.min-block-size should be set to 16.");
        ExitUtil.terminate((int)-1);
    }

    public static void runBenchmark(Configuration conf, String[] args) throws Exception {
        try (NNThroughputBenchmark bench = null;){
            bench = new NNThroughputBenchmark(conf);
            ToolRunner.run((Tool)bench, (String[])args);
        }
    }

    public int run(String[] aArgs) throws Exception {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(aArgs));
        if (args.size() < 2 || !((String)args.get(0)).startsWith("-op")) {
            NNThroughputBenchmark.printUsage();
        }
        String type = (String)args.get(1);
        boolean runAll = "all".equals(type);
        URI nnUri = FileSystem.getDefaultUri((Configuration)config);
        String[] argv = new String[]{};
        ArrayList<CreateFileStats> ops = new ArrayList<CreateFileStats>();
        OperationStatsBase opStat = null;
        try {
            if (runAll || "create".equals(type)) {
                opStat = new CreateFileStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "mkdirs".equals(type)) {
                opStat = new MkdirsStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "open".equals(type)) {
                opStat = new OpenFileStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "delete".equals(type)) {
                opStat = new DeleteFileStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "fileStatus".equals(type)) {
                opStat = new FileStatusStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "rename".equals(type)) {
                opStat = new RenameFileStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "blockReport".equals(type)) {
                opStat = new BlockReportStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "replication".equals(type)) {
                if (nnUri.getScheme() != null && nnUri.getScheme().equals("hdfs")) {
                    LOG.warn("The replication test is ignored as it does not support standalone namenode in another process or on another host. ");
                } else {
                    opStat = new ReplicationStats(args);
                    ops.add((CreateFileStats)opStat);
                }
            }
            if (runAll || "clean".equals(type)) {
                opStat = new CleanAllStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (ops.isEmpty()) {
                NNThroughputBenchmark.printUsage();
            }
            if (nnUri.getScheme() == null || nnUri.getScheme().equals("file")) {
                LOG.info("Remote NameNode is not specified. Creating one.");
                FileSystem.setDefaultUri((Configuration)config, (String)"hdfs://localhost:0");
                config.set("dfs.namenode.http-address", "0.0.0.0:0");
                nameNode = NameNode.createNameNode(argv, config);
                NamenodeProtocols nnProtos = nameNode.getRpcServer();
                nameNodeProto = nnProtos;
                clientProto = nnProtos;
                dataNodeProto = nnProtos;
                refreshUserMappingsProto = nnProtos;
                bpid = nameNode.getNamesystem().getBlockPoolId();
            } else {
                DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.get((Configuration)this.getConf());
                nameNodeProto = DFSTestUtil.getNamenodeProtocolProxy(config, nnUri, UserGroupInformation.getCurrentUser());
                clientProto = dfs.getClient().getNamenode();
                InetSocketAddress inetSocketAddress = DFSUtilClient.getNNAddress((URI)nnUri);
                dataNodeProto = new DatanodeProtocolClientSideTranslatorPB(inetSocketAddress, config);
                refreshUserMappingsProto = DFSTestUtil.getRefreshUserMappingsProtocolProxy(config, inetSocketAddress);
                this.getBlockPoolId(dfs);
            }
            for (OperationStatsBase operationStatsBase : ops) {
                LOG.info("Starting benchmark: " + operationStatsBase.getOpName());
                operationStatsBase.benchmark();
                operationStatsBase.cleanUp();
            }
            for (OperationStatsBase operationStatsBase : ops) {
                LOG.info("");
                operationStatsBase.printResults();
            }
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        return 0;
    }

    private void getBlockPoolId(DistributedFileSystem unused) throws IOException {
        NamespaceInfo nsInfo = nameNodeProto.versionRequest();
        bpid = nsInfo.getBlockPoolID();
    }

    public static void main(String[] args) throws Exception {
        NNThroughputBenchmark.runBenchmark((Configuration)new HdfsConfiguration(), args);
    }

    public void setConf(Configuration conf) {
        config = conf;
    }

    public Configuration getConf() {
        return config;
    }

    static {
        bpid = null;
    }

    class ReplicationStats
    extends OperationStatsBase {
        static final String OP_REPLICATION_NAME = "replication";
        static final String OP_REPLICATION_USAGE = "-op replication [-datanodes T] [-nodesToDecommission D] [-nodeReplicationLimit C] [-totalBlocks B] [-blockSize S] [-replication R]";
        private final BlockReportStats blockReportObject;
        private int numDatanodes;
        private int nodesToDecommission;
        private int nodeReplicationLimit;
        private int totalBlocks;
        private int numDecommissionedBlocks;
        private int numPendingBlocks;

        ReplicationStats(List<String> args) {
            this.numThreads = 1;
            this.numDatanodes = 10;
            this.nodesToDecommission = 1;
            this.nodeReplicationLimit = 100;
            this.totalBlocks = 100;
            this.parseArguments(args);
            this.numOpsRequired = this.totalBlocks * this.replication * this.nodesToDecommission * 2 / (this.numDatanodes * this.numDatanodes);
            String[] blkReportArgs = new String[]{"-op", "blockReport", "-datanodes", String.valueOf(this.numDatanodes), "-blocksPerReport", String.valueOf(this.totalBlocks * this.replication / this.numDatanodes), "-blocksPerFile", String.valueOf(this.numDatanodes), "-blockSize", String.valueOf(this.blockSize)};
            this.blockReportObject = new BlockReportStats(Arrays.asList(blkReportArgs));
            this.numDecommissionedBlocks = 0;
            this.numPendingBlocks = 0;
        }

        @Override
        String getOpName() {
            return OP_REPLICATION_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            boolean ignoreUnrelatedOptions = this.verifyOpArgument(args);
            for (int i = 2; i < args.size(); ++i) {
                if (args.get(i).equals("-datanodes")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numDatanodes = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-nodesToDecommission")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.nodesToDecommission = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-nodeReplicationLimit")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.nodeReplicationLimit = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-totalBlocks")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.totalBlocks = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-replication")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.replication = Short.parseShort(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-blockSize")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.blockSize = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (ignoreUnrelatedOptions) continue;
                NNThroughputBenchmark.printUsage();
            }
        }

        @Override
        void generateInputs(int[] ignore) throws IOException {
            FSNamesystem namesystem = nameNode.getNamesystem();
            this.blockReportObject.generateInputs(ignore);
            BlockManagerTestUtil.stopRedundancyThread(namesystem.getBlockManager());
            int nrDatanodes = this.blockReportObject.getNumDatanodes();
            for (int idx = 0; idx < nrDatanodes; ++idx) {
                this.blockReportObject.executeOp(idx, 0, null);
            }
            this.decommissionNodes();
            BlockManagerTestUtil.setNodeReplicationLimit(namesystem.getBlockManager(), this.nodeReplicationLimit);
        }

        private void decommissionNodes() throws IOException {
            String excludeFN = config.get("dfs.hosts.exclude", "exclude");
            FileOutputStream excludeFile = new FileOutputStream(excludeFN);
            excludeFile.getChannel().truncate(0L);
            int nrDatanodes = this.blockReportObject.getNumDatanodes();
            this.numDecommissionedBlocks = 0;
            for (int i = 0; i < this.nodesToDecommission; ++i) {
                TinyDatanode dn = this.blockReportObject.datanodes[nrDatanodes - 1 - i];
                this.numDecommissionedBlocks += dn.nrBlocks;
                excludeFile.write(dn.getXferAddr().getBytes());
                excludeFile.write(10);
                LOG.info("Datanode " + dn + " is decommissioned.");
            }
            excludeFile.close();
            clientProto.refreshNodes();
        }

        @Override
        String getExecutionArgument(int daemonId) {
            return null;
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            assert (daemonId < this.numThreads) : "Wrong daemonId.";
            long start = Time.now();
            int work = BlockManagerTestUtil.getComputedDatanodeWork(nameNode.getNamesystem().getBlockManager());
            long end = Time.now();
            this.numPendingBlocks += work;
            if (work == 0) {
                ((StatsDaemon)this.daemons.get(daemonId)).terminate();
            }
            return end - start;
        }

        @Override
        void printResults() {
            String blockDistribution = "";
            String delim = "(";
            for (int idx = 0; idx < this.blockReportObject.getNumDatanodes(); ++idx) {
                blockDistribution = blockDistribution + delim + ((BlockReportStats)this.blockReportObject).datanodes[idx].nrBlocks;
                delim = ", ";
            }
            blockDistribution = blockDistribution + ")";
            LOG.info("--- " + this.getOpName() + " inputs ---");
            LOG.info("numOpsRequired = " + this.numOpsRequired);
            LOG.info("datanodes = " + this.numDatanodes + " " + blockDistribution);
            LOG.info("decommissioned datanodes = " + this.nodesToDecommission);
            LOG.info("datanode replication limit = " + this.nodeReplicationLimit);
            LOG.info("total blocks = " + this.totalBlocks);
            this.printStats();
            LOG.info("decommissioned blocks = " + this.numDecommissionedBlocks);
            LOG.info("pending replications = " + this.numPendingBlocks);
            LOG.info("replications per sec: " + this.getBlocksPerSecond());
        }

        private double getBlocksPerSecond() {
            return this.elapsedTime == 0L ? 0.0 : 1000.0 * (double)this.numPendingBlocks / (double)this.elapsedTime;
        }
    }

    class BlockReportStats
    extends OperationStatsBase {
        static final String OP_BLOCK_REPORT_NAME = "blockReport";
        static final String OP_BLOCK_REPORT_USAGE = "-op blockReport [-datanodes T] [-reports N] [-blocksPerReport B] [-blocksPerFile F] [-blockSize S]";
        private int blocksPerReport;
        private int blocksPerFile;
        private TinyDatanode[] datanodes;

        BlockReportStats(List<String> args) {
            this.numThreads = 10;
            this.numOpsRequired = 30;
            this.blocksPerReport = 100;
            this.blocksPerFile = 10;
            config.setLong("dfs.heartbeat.interval", 180L);
            this.parseArguments(args);
            this.replication = (short)Math.min(this.replication, this.getNumDatanodes());
        }

        private int getNumDatanodes() {
            return this.numThreads;
        }

        @Override
        String getOpName() {
            return OP_BLOCK_REPORT_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            boolean ignoreUnrelatedOptions = this.verifyOpArgument(args);
            for (int i = 2; i < args.size(); ++i) {
                if (args.get(i).equals("-reports")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numOpsRequired = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-datanodes")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numThreads = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-blocksPerReport")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.blocksPerReport = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-blocksPerFile")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.blocksPerFile = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-blockSize")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.blockSize = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (ignoreUnrelatedOptions) continue;
                NNThroughputBenchmark.printUsage();
            }
        }

        @Override
        void generateInputs(int[] ignore) throws IOException {
            int idx;
            int nrDatanodes = this.getNumDatanodes();
            int nrBlocks = (int)Math.ceil((double)this.blocksPerReport * (double)nrDatanodes / (double)this.replication);
            int nrFiles = (int)Math.ceil((double)nrBlocks / (double)this.blocksPerFile);
            this.datanodes = new TinyDatanode[nrDatanodes];
            for (int idx2 = 0; idx2 < nrDatanodes; ++idx2) {
                this.datanodes[idx2] = new TinyDatanode(idx2, this.blocksPerReport);
                this.datanodes[idx2].register();
                this.datanodes[idx2].sendHeartbeat();
            }
            LOG.info("Creating " + nrFiles + " files with " + this.blocksPerFile + " blocks each.");
            FileNameGenerator nameGenerator = new FileNameGenerator(this.getBaseDir(), 100);
            String clientName = this.getClientName(7);
            clientProto.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            for (idx = 0; idx < nrFiles; ++idx) {
                String fileName = nameGenerator.getNextFileName("ThroughputBench");
                clientProto.create(fileName, FsPermission.getDefault(), clientName, new EnumSetWritable(EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE)), true, this.replication, (long)this.blockSize, CryptoProtocolVersion.supported(), null);
                ExtendedBlock lastBlock = this.addBlocks(fileName, clientName);
                clientProto.complete(fileName, clientName, lastBlock, 0L);
            }
            for (idx = 0; idx < nrDatanodes; ++idx) {
                this.datanodes[idx].formBlockReport();
            }
        }

        private ExtendedBlock addBlocks(String fileName, String clientName) throws IOException {
            ExtendedBlock prevBlock = null;
            for (int jdx = 0; jdx < this.blocksPerFile; ++jdx) {
                LocatedBlock loc = this.addBlock(fileName, clientName, prevBlock, null, 0L, null);
                prevBlock = loc.getBlock();
                for (DatanodeInfo dnInfo : loc.getLocations()) {
                    int dnIdx = dnInfo.getXferPort() - 1;
                    this.datanodes[dnIdx].addBlock(loc.getBlock().getLocalBlock());
                    ReceivedDeletedBlockInfo[] rdBlocks = new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo(loc.getBlock().getLocalBlock(), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null)};
                    StorageReceivedDeletedBlocks[] report = new StorageReceivedDeletedBlocks[]{new StorageReceivedDeletedBlocks(new DatanodeStorage(this.datanodes[dnIdx].storage.getStorageID()), rdBlocks)};
                    dataNodeProto.blockReceivedAndDeleted(this.datanodes[dnIdx].dnRegistration, bpid, report);
                }
            }
            return prevBlock;
        }

        private LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludeNodes, long fileId, String[] favoredNodes) throws IOException {
            for (int i = 0; i < 30; ++i) {
                try {
                    return clientProto.addBlock(src, clientName, previous, excludeNodes, fileId, favoredNodes, null);
                }
                catch (NotReplicatedYetException | RemoteException e) {
                    String className;
                    if (e instanceof RemoteException && !(className = ((RemoteException)e).getClassName()).equals(NotReplicatedYetException.class.getName())) {
                        throw e;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        LOG.warn("interrupted while retrying addBlock.", (Throwable)ie);
                    }
                    continue;
                }
            }
            throw new IOException("failed to add block.");
        }

        @Override
        String getExecutionArgument(int daemonId) {
            return null;
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            assert (daemonId < this.numThreads) : "Wrong daemonId.";
            TinyDatanode dn = this.datanodes[daemonId];
            long start = Time.now();
            StorageBlockReport[] report = new StorageBlockReport[]{new StorageBlockReport(dn.storage, dn.getBlockReportList())};
            dataNodeProto.blockReport(dn.dnRegistration, bpid, report, new BlockReportContext(1, 0, System.nanoTime(), 0L));
            long end = Time.now();
            return end - start;
        }

        @Override
        void printResults() {
            String blockDistribution = "";
            String delim = "(";
            for (int idx = 0; idx < this.getNumDatanodes(); ++idx) {
                blockDistribution = blockDistribution + delim + this.datanodes[idx].nrBlocks;
                delim = ", ";
            }
            blockDistribution = blockDistribution + ")";
            LOG.info("--- " + this.getOpName() + " inputs ---");
            LOG.info("reports = " + this.numOpsRequired);
            LOG.info("datanodes = " + this.numThreads + " " + blockDistribution);
            LOG.info("blocksPerReport = " + this.blocksPerReport);
            LOG.info("blocksPerFile = " + this.blocksPerFile);
            this.printStats();
        }
    }

    private static class TinyDatanode
    implements Comparable<String> {
        private static final long DF_CAPACITY = 0x6400000L;
        private static final long DF_USED = 0L;
        NamespaceInfo nsInfo;
        DatanodeRegistration dnRegistration;
        DatanodeStorage storage;
        final List<BlockListAsLongs.BlockReportReplica> blocks;
        int nrBlocks;
        BlockListAsLongs blockReportList;
        final int dnIdx;

        private static int getNodePort(int num) throws IOException {
            int port = 1 + num;
            Preconditions.checkState((port < Short.MAX_VALUE ? 1 : 0) != 0);
            return port;
        }

        TinyDatanode(int dnIdx, int blockCapacity) throws IOException {
            this.dnIdx = dnIdx;
            this.blocks = Arrays.asList(new BlockListAsLongs.BlockReportReplica[blockCapacity]);
            this.nrBlocks = 0;
        }

        public String toString() {
            return this.dnRegistration.toString();
        }

        String getXferAddr() {
            return this.dnRegistration.getXferAddr();
        }

        void register() throws IOException {
            this.nsInfo = nameNodeProto.versionRequest();
            this.dnRegistration = new DatanodeRegistration(new DatanodeID(DNS.getDefaultIP((String)"default"), DNS.getDefaultHost((String)"default", (String)"default"), DataNode.generateUuid(), TinyDatanode.getNodePort(this.dnIdx), 9864, 9865, 9867), new DataStorage(this.nsInfo), new ExportedBlockKeys(), VersionInfo.getVersion());
            this.dnRegistration = dataNodeProto.registerDatanode(this.dnRegistration);
            this.dnRegistration.setNamespaceInfo(this.nsInfo);
            this.storage = new DatanodeStorage(DatanodeStorage.generateUuid());
            StorageBlockReport[] reports = new StorageBlockReport[]{new StorageBlockReport(this.storage, BlockListAsLongs.EMPTY)};
            dataNodeProto.blockReport(this.dnRegistration, bpid, reports, new BlockReportContext(1, 0, System.nanoTime(), 0L));
        }

        void sendHeartbeat() throws IOException {
            StorageReport[] rep = new StorageReport[]{new StorageReport(this.storage, false, 0x6400000L, 0L, 0x6400000L, 0L, 0L)};
            DatanodeCommand[] cmds = dataNodeProto.sendHeartbeat(this.dnRegistration, rep, 0L, 0L, 0, 0, 0, null, true, SlowPeerReports.EMPTY_REPORT, SlowDiskReports.EMPTY_REPORT).getCommands();
            if (cmds != null) {
                for (DatanodeCommand cmd : cmds) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("sendHeartbeat Name-node reply: " + cmd.getAction());
                }
            }
        }

        boolean addBlock(Block blk) {
            if (this.nrBlocks == this.blocks.size()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cannot add block: datanode capacity = " + this.blocks.size());
                }
                return false;
            }
            this.blocks.set(this.nrBlocks, new BlockListAsLongs.BlockReportReplica(blk));
            ++this.nrBlocks;
            return true;
        }

        void formBlockReport() {
            for (int idx = this.blocks.size() - 1; idx >= this.nrBlocks; --idx) {
                Block block = new Block((long)(this.blocks.size() - idx), 0L, 0L);
                this.blocks.set(idx, new BlockListAsLongs.BlockReportReplica(block));
            }
            this.blockReportList = BlockListAsLongs.encode(this.blocks);
        }

        BlockListAsLongs getBlockReportList() {
            return this.blockReportList;
        }

        @Override
        public int compareTo(String xferAddr) {
            return this.getXferAddr().compareTo(xferAddr);
        }

        int replicateBlocks() throws IOException {
            StorageReport[] rep = new StorageReport[]{new StorageReport(this.storage, false, 0x6400000L, 0L, 0x6400000L, 0L, 0L)};
            DatanodeCommand[] cmds = dataNodeProto.sendHeartbeat(this.dnRegistration, rep, 0L, 0L, 0, 0, 0, null, true, SlowPeerReports.EMPTY_REPORT, SlowDiskReports.EMPTY_REPORT).getCommands();
            if (cmds != null) {
                for (DatanodeCommand cmd : cmds) {
                    if (cmd.getAction() != 1) continue;
                    BlockCommand bcmd = (BlockCommand)cmd;
                    return this.transferBlocks(bcmd.getBlocks(), bcmd.getTargets(), bcmd.getTargetStorageIDs());
                }
            }
            return 0;
        }

        private int transferBlocks(Block[] blocks, DatanodeInfo[][] xferTargets, String[][] targetStorageIDs) throws IOException {
            for (int i = 0; i < blocks.length; ++i) {
                DatanodeInfo[] blockTargets = xferTargets[i];
                for (int t = 0; t < blockTargets.length; ++t) {
                    DatanodeInfo dnInfo = blockTargets[t];
                    String targetStorageID = targetStorageIDs[i][t];
                    DatanodeRegistration receivedDNReg = new DatanodeRegistration((DatanodeID)dnInfo, new DataStorage(this.nsInfo), new ExportedBlockKeys(), VersionInfo.getVersion());
                    ReceivedDeletedBlockInfo[] rdBlocks = new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo(blocks[i], ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null)};
                    StorageReceivedDeletedBlocks[] report = new StorageReceivedDeletedBlocks[]{new StorageReceivedDeletedBlocks(new DatanodeStorage(targetStorageID), rdBlocks)};
                    dataNodeProto.blockReceivedAndDeleted(receivedDNReg, bpid, report);
                }
            }
            return blocks.length;
        }
    }

    class RenameFileStats
    extends OpenFileStats {
        static final String OP_RENAME_NAME = "rename";
        static final String OP_RENAME_USAGE = "-op rename [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-useExisting]";
        protected String[][] destNames;

        RenameFileStats(List<String> args) {
            super(args);
        }

        @Override
        String getOpName() {
            return OP_RENAME_NAME;
        }

        @Override
        void generateInputs(int[] opsPerThread) throws IOException {
            super.generateInputs(opsPerThread);
            this.destNames = new String[this.fileNames.length][];
            for (int idx = 0; idx < this.numThreads; ++idx) {
                int nrNames = this.fileNames[idx].length;
                this.destNames[idx] = new String[nrNames];
                for (int jdx = 0; jdx < nrNames; ++jdx) {
                    this.destNames[idx][jdx] = this.fileNames[idx][jdx] + ".r";
                }
            }
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            long start = Time.now();
            clientProto.rename(this.fileNames[daemonId][inputIdx], this.destNames[daemonId][inputIdx]);
            long end = Time.now();
            return end - start;
        }
    }

    class FileStatusStats
    extends OpenFileStats {
        static final String OP_FILE_STATUS_NAME = "fileStatus";
        static final String OP_FILE_STATUS_USAGE = "-op fileStatus [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-useExisting]";

        FileStatusStats(List<String> args) {
            super(args);
        }

        @Override
        String getOpName() {
            return OP_FILE_STATUS_NAME;
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            long start = Time.now();
            clientProto.getFileInfo(this.fileNames[daemonId][inputIdx]);
            long end = Time.now();
            return end - start;
        }
    }

    class DeleteFileStats
    extends OpenFileStats {
        static final String OP_DELETE_NAME = "delete";
        static final String OP_DELETE_USAGE = "-op delete [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-useExisting]";

        DeleteFileStats(List<String> args) {
            super(args);
        }

        @Override
        String getOpName() {
            return OP_DELETE_NAME;
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            long start = Time.now();
            clientProto.delete(this.fileNames[daemonId][inputIdx], false);
            long end = Time.now();
            return end - start;
        }
    }

    class OpenFileStats
    extends CreateFileStats {
        static final String OP_OPEN_NAME = "open";
        static final String OP_USAGE_ARGS = " [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-useExisting]";
        static final String OP_OPEN_USAGE = "-op open [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-useExisting]";
        private boolean useExisting;

        OpenFileStats(List<String> args) {
            super(args);
        }

        @Override
        String getOpName() {
            return OP_OPEN_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            int ueIndex = args.indexOf("-useExisting");
            boolean bl = this.useExisting = ueIndex >= 0;
            if (this.useExisting) {
                args.remove(ueIndex);
            }
            super.parseArguments(args);
        }

        @Override
        void generateInputs(int[] opsPerThread) throws IOException {
            String[] createArgs = new String[]{"-op", "create", "-threads", String.valueOf(this.numThreads), "-files", String.valueOf(this.numOpsRequired), "-blockSize", String.valueOf(this.blockSize), "-filesPerDir", String.valueOf(this.nameGenerator.getFilesPerDirectory()), "-close"};
            CreateFileStats opCreate = new CreateFileStats(Arrays.asList(createArgs));
            if (!this.useExisting) {
                opCreate.benchmark();
                LOG.info("Created " + this.numOpsRequired + " files.");
            } else {
                LOG.info("useExisting = true. Assuming " + this.numOpsRequired + " files have been created before.");
            }
            super.generateInputs(opsPerThread);
            if (clientProto.getFileInfo(opCreate.getBaseDir()) != null && clientProto.getFileInfo(this.getBaseDir()) == null) {
                clientProto.rename(opCreate.getBaseDir(), this.getBaseDir());
            }
            if (clientProto.getFileInfo(this.getBaseDir()) == null) {
                throw new IOException(this.getBaseDir() + " does not exist.");
            }
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            long start = Time.now();
            clientProto.getBlockLocations(this.fileNames[daemonId][inputIdx], 0L, (long)this.blockSize);
            long end = Time.now();
            return end - start;
        }
    }

    class MkdirsStats
    extends OperationStatsBase {
        static final String OP_MKDIRS_NAME = "mkdirs";
        static final String OP_MKDIRS_USAGE = "-op mkdirs [-threads T] [-dirs N] [-dirsPerDir P]";
        protected FileNameGenerator nameGenerator;
        protected String[][] dirPaths;

        MkdirsStats(List<String> args) {
            this.parseArguments(args);
        }

        @Override
        String getOpName() {
            return OP_MKDIRS_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            boolean ignoreUnrelatedOptions = this.verifyOpArgument(args);
            int nrDirsPerDir = 2;
            for (int i = 2; i < args.size(); ++i) {
                if (args.get(i).equals("-dirs")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numOpsRequired = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-threads")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numThreads = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-dirsPerDir")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    nrDirsPerDir = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (ignoreUnrelatedOptions) continue;
                NNThroughputBenchmark.printUsage();
            }
            this.nameGenerator = new FileNameGenerator(this.getBaseDir(), nrDirsPerDir);
        }

        @Override
        void generateInputs(int[] opsPerThread) throws IOException {
            assert (opsPerThread.length == this.numThreads) : "Error opsPerThread.length";
            clientProto.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            LOG.info("Generate " + this.numOpsRequired + " inputs for " + this.getOpName());
            this.dirPaths = new String[this.numThreads][];
            try {
                for (int idx = 0; idx < this.numThreads; ++idx) {
                    int threadOps = opsPerThread[idx];
                    this.dirPaths[idx] = new String[threadOps];
                    for (int jdx = 0; jdx < threadOps; ++jdx) {
                        this.dirPaths[idx][jdx] = this.nameGenerator.getNextFileName("ThroughputBench");
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.error("The current environment allows {} directories to be created. If you want to test more directories, please update the -dirsPerDir parameter.", (Object)this.nameGenerator.getFileCount());
                throw e;
            }
        }

        @Override
        String getExecutionArgument(int daemonId) {
            return this.getClientName(daemonId);
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String clientName) throws IOException {
            long start = Time.now();
            clientProto.mkdirs(this.dirPaths[daemonId][inputIdx], FsPermission.getDefault(), true);
            long end = Time.now();
            return end - start;
        }

        @Override
        void printResults() {
            LOG.info("--- " + this.getOpName() + " inputs ---");
            LOG.info("nrDirs = " + this.numOpsRequired);
            LOG.info("nrThreads = " + this.numThreads);
            LOG.info("nrDirsPerDir = " + this.nameGenerator.getFilesPerDirectory());
            this.printStats();
        }
    }

    class CreateFileStats
    extends OperationStatsBase {
        static final String OP_CREATE_NAME = "create";
        static final String OP_CREATE_USAGE = "-op create [-threads T] [-files N] [-blockSize S] [-filesPerDir P] [-close]";
        protected FileNameGenerator nameGenerator;
        protected String[][] fileNames;
        private boolean closeUponCreate;

        CreateFileStats(List<String> args) {
            this.parseArguments(args);
        }

        @Override
        String getOpName() {
            return OP_CREATE_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            boolean ignoreUnrelatedOptions = this.verifyOpArgument(args);
            int nrFilesPerDir = 4;
            this.closeUponCreate = false;
            for (int i = 2; i < args.size(); ++i) {
                if (args.get(i).equals("-files")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numOpsRequired = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-blockSize")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.blockSize = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-threads")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numThreads = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-filesPerDir")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    nrFilesPerDir = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-close")) {
                    this.closeUponCreate = true;
                    continue;
                }
                if (ignoreUnrelatedOptions) continue;
                NNThroughputBenchmark.printUsage();
            }
            this.nameGenerator = new FileNameGenerator(this.getBaseDir(), nrFilesPerDir);
        }

        @Override
        void generateInputs(int[] opsPerThread) throws IOException {
            assert (opsPerThread.length == this.numThreads) : "Error opsPerThread.length";
            clientProto.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            LOG.info("Generate " + this.numOpsRequired + " intputs for " + this.getOpName());
            this.fileNames = new String[this.numThreads][];
            try {
                for (int idx = 0; idx < this.numThreads; ++idx) {
                    int threadOps = opsPerThread[idx];
                    this.fileNames[idx] = new String[threadOps];
                    for (int jdx = 0; jdx < threadOps; ++jdx) {
                        this.fileNames[idx][jdx] = this.nameGenerator.getNextFileName("ThroughputBench");
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.error("The current environment allows {} files to be created. If you want to test more files, please update the -filesPerDir parameter.", (Object)this.nameGenerator.getFileCount());
                throw e;
            }
        }

        @Override
        String getExecutionArgument(int daemonId) {
            return this.getClientName(daemonId);
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String clientName) throws IOException {
            boolean written;
            long start = Time.now();
            clientProto.create(this.fileNames[daemonId][inputIdx], FsPermission.getDefault(), clientName, new EnumSetWritable(EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE)), true, this.replication, (long)this.blockSize, CryptoProtocolVersion.supported(), null);
            long end = Time.now();
            boolean bl = written = !this.closeUponCreate;
            while (!written) {
                written = clientProto.complete(this.fileNames[daemonId][inputIdx], clientName, null, 0L);
            }
            return end - start;
        }

        @Override
        void printResults() {
            LOG.info("--- " + this.getOpName() + " inputs ---");
            LOG.info("nrFiles = " + this.numOpsRequired);
            LOG.info("nrThreads = " + this.numThreads);
            LOG.info("nrFilesPerDir = " + this.nameGenerator.getFilesPerDirectory());
            this.printStats();
        }
    }

    class CleanAllStats
    extends OperationStatsBase {
        static final String OP_CLEAN_NAME = "clean";
        static final String OP_CLEAN_USAGE = "-op clean";

        CleanAllStats(List<String> args) {
            this.parseArguments(args);
            this.numOpsRequired = 1;
            this.numThreads = 1;
            this.keepResults = true;
        }

        @Override
        String getOpName() {
            return OP_CLEAN_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            boolean ignoreUnrelatedOptions = this.verifyOpArgument(args);
            if (args.size() > 2 && !ignoreUnrelatedOptions) {
                NNThroughputBenchmark.printUsage();
            }
        }

        @Override
        void generateInputs(int[] opsPerThread) throws IOException {
        }

        @Override
        String getExecutionArgument(int daemonId) {
            return null;
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            clientProto.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            long start = Time.now();
            clientProto.delete("/nnThroughputBenchmark", true);
            long end = Time.now();
            return end - start;
        }

        @Override
        void printResults() {
            LOG.info("--- " + this.getOpName() + " inputs ---");
            LOG.info("Remove directory /nnThroughputBenchmark");
            this.printStats();
        }
    }

    private class StatsDaemon
    extends Thread {
        private final int daemonId;
        private int opsPerThread;
        private String arg1;
        private volatile int localNumOpsExecuted = 0;
        private volatile long localCumulativeTime = 0L;
        private final OperationStatsBase statsOp;

        StatsDaemon(int daemonId, int nrOps, OperationStatsBase op) {
            this.daemonId = daemonId;
            this.opsPerThread = nrOps;
            this.statsOp = op;
            this.setName(this.toString());
        }

        @Override
        public void run() {
            this.localNumOpsExecuted = 0;
            this.localCumulativeTime = 0L;
            this.arg1 = this.statsOp.getExecutionArgument(this.daemonId);
            try {
                this.benchmarkOne();
            }
            catch (IOException ex) {
                LOG.error("StatsDaemon " + this.daemonId + " failed: \n" + StringUtils.stringifyException((Throwable)ex));
            }
        }

        @Override
        public String toString() {
            return "StatsDaemon-" + this.daemonId;
        }

        void benchmarkOne() throws IOException {
            for (int idx = 0; idx < this.opsPerThread; ++idx) {
                if ((this.localNumOpsExecuted + 1) % this.statsOp.ugcRefreshCount == 0) {
                    refreshUserMappingsProto.refreshUserToGroupsMappings();
                }
                long stat = this.statsOp.executeOp(this.daemonId, idx, this.arg1);
                ++this.localNumOpsExecuted;
                this.localCumulativeTime += stat;
            }
        }

        boolean isInProgress() {
            return this.localNumOpsExecuted < this.opsPerThread;
        }

        void terminate() {
            this.opsPerThread = this.localNumOpsExecuted;
        }
    }

    abstract class OperationStatsBase {
        protected static final String BASE_DIR_NAME = "/nnThroughputBenchmark";
        protected static final String OP_ALL_NAME = "all";
        protected static final String OP_ALL_USAGE = "-op all <other ops options>";
        protected final String baseDir = "/nnThroughputBenchmark/" + this.getOpName();
        protected short replication = (short)config.getInt("dfs.replication", 3);
        protected int blockSize = config.getInt("dfs.blocksize", 16);
        protected int numThreads = 3;
        protected int numOpsRequired = 10;
        protected int numOpsExecuted = 0;
        protected long cumulativeTime = 0L;
        protected long elapsedTime = 0L;
        protected boolean keepResults = false;
        protected Level logLevel = Level.ERROR;
        protected int ugcRefreshCount = Integer.MAX_VALUE;
        protected List<StatsDaemon> daemons;

        abstract String getOpName();

        abstract void parseArguments(List<String> var1) throws IOException;

        abstract void generateInputs(int[] var1) throws IOException;

        abstract String getExecutionArgument(int var1);

        abstract long executeOp(int var1, int var2, String var3) throws IOException;

        abstract void printResults();

        OperationStatsBase() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void benchmark() throws IOException {
            this.daemons = new ArrayList<StatsDaemon>();
            long start = 0L;
            try {
                this.numOpsExecuted = 0;
                this.cumulativeTime = 0L;
                if (this.numThreads < 1) {
                    return;
                }
                int tIdx = 0;
                int[] opsPerThread = new int[this.numThreads];
                for (int opsScheduled = 0; opsScheduled < this.numOpsRequired; opsScheduled += opsPerThread[tIdx++]) {
                    opsPerThread[tIdx] = (this.numOpsRequired - opsScheduled) / (this.numThreads - tIdx);
                    if (opsPerThread[tIdx] != 0) continue;
                    opsPerThread[tIdx] = 1;
                }
                while (tIdx < this.numThreads) {
                    opsPerThread[tIdx] = 0;
                    ++tIdx;
                }
                this.generateInputs(opsPerThread);
                NNThroughputBenchmark.setNameNodeLoggingLevel(this.logLevel);
                for (tIdx = 0; tIdx < this.numThreads; ++tIdx) {
                    this.daemons.add(new StatsDaemon(tIdx, opsPerThread[tIdx], this));
                }
                start = Time.now();
                LOG.info("Starting " + this.numOpsRequired + " " + this.getOpName() + "(s).");
                for (StatsDaemon d : this.daemons) {
                    d.start();
                }
            }
            finally {
                while (this.isInProgress()) {
                }
                this.elapsedTime = Time.now() - start;
                for (StatsDaemon d : this.daemons) {
                    this.incrementStats(d.localNumOpsExecuted, d.localCumulativeTime);
                }
            }
        }

        private boolean isInProgress() {
            for (StatsDaemon d : this.daemons) {
                if (!d.isInProgress()) continue;
                return true;
            }
            return false;
        }

        void cleanUp() throws IOException {
            clientProto.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            if (!this.keepResults) {
                clientProto.delete(this.getBaseDir(), true);
            } else {
                clientProto.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, true);
                clientProto.saveNamespace(0L, 0L);
            }
        }

        int getNumOpsExecuted() {
            return this.numOpsExecuted;
        }

        long getCumulativeTime() {
            return this.cumulativeTime;
        }

        long getElapsedTime() {
            return this.elapsedTime;
        }

        long getAverageTime() {
            return this.numOpsExecuted == 0 ? 0L : this.cumulativeTime / (long)this.numOpsExecuted;
        }

        double getOpsPerSecond() {
            return this.elapsedTime == 0L ? 0.0 : 1000.0 * (double)this.numOpsExecuted / (double)this.elapsedTime;
        }

        String getBaseDir() {
            return this.baseDir;
        }

        String getClientName(int idx) {
            return this.getOpName() + "-client-" + idx;
        }

        void incrementStats(int ops, long time) {
            this.numOpsExecuted += ops;
            this.cumulativeTime += time;
        }

        protected boolean verifyOpArgument(List<String> args) {
            String type;
            int ugrcIndex;
            int llIndex;
            int krIndex;
            if (args.size() < 2 || !args.get(0).startsWith("-op")) {
                NNThroughputBenchmark.printUsage();
            }
            boolean bl = this.keepResults = (krIndex = args.indexOf("-keepResults")) >= 0;
            if (this.keepResults) {
                args.remove(krIndex);
            }
            if ((llIndex = args.indexOf("-logLevel")) >= 0) {
                if (args.size() <= llIndex + 1) {
                    NNThroughputBenchmark.printUsage();
                }
                this.logLevel = Level.toLevel((String)args.get(llIndex + 1), (Level)Level.ERROR);
                args.remove(llIndex + 1);
                args.remove(llIndex);
            }
            if ((ugrcIndex = args.indexOf("-UGCacheRefreshCount")) >= 0) {
                int g;
                if (args.size() <= ugrcIndex + 1) {
                    NNThroughputBenchmark.printUsage();
                }
                if ((g = Integer.parseInt(args.get(ugrcIndex + 1))) > 0) {
                    this.ugcRefreshCount = g;
                }
                args.remove(ugrcIndex + 1);
                args.remove(ugrcIndex);
            }
            if (OP_ALL_NAME.equals(type = args.get(1))) {
                type = this.getOpName();
                return true;
            }
            if (!this.getOpName().equals(type)) {
                NNThroughputBenchmark.printUsage();
            }
            return false;
        }

        void printStats() {
            LOG.info("--- " + this.getOpName() + " stats  ---");
            LOG.info("# operations: " + this.getNumOpsExecuted());
            LOG.info("Elapsed Time: " + this.getElapsedTime());
            LOG.info(" Ops per sec: " + this.getOpsPerSecond());
            LOG.info("Average Time: " + this.getAverageTime());
        }
    }
}

