/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.qjournal.protocol.InterQJournalProtocol;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.qjournal.protocolPB.InterQJournalProtocolPB;
import org.apache.hadoop.hdfs.qjournal.protocolPB.InterQJournalProtocolTranslatorPB;
import org.apache.hadoop.hdfs.qjournal.server.GetJournalEditServlet;
import org.apache.hadoop.hdfs.qjournal.server.JNStorage;
import org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.hadoop.hdfs.qjournal.server.JournalMetrics;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.util.Daemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JournalNodeSyncer {
    public static final Logger LOG = LoggerFactory.getLogger(JournalNodeSyncer.class);
    private final JournalNode jn;
    private final Journal journal;
    private final String jid;
    private String nameServiceId;
    private final JNStorage jnStorage;
    private final Configuration conf;
    private volatile Daemon syncJournalDaemon;
    private volatile boolean shouldSync = true;
    private List<JournalNodeProxy> otherJNProxies = Lists.newArrayList();
    private int numOtherJNs;
    private int journalNodeIndexForSync = 0;
    private final long journalSyncInterval;
    private final int logSegmentTransferTimeout;
    private final DataTransferThrottler throttler;
    private final JournalMetrics metrics;
    private boolean journalSyncerStarted;

    JournalNodeSyncer(JournalNode jouranlNode, Journal journal, String jid, Configuration conf, String nameServiceId) {
        this.jn = jouranlNode;
        this.journal = journal;
        this.jid = jid;
        this.nameServiceId = nameServiceId;
        this.jnStorage = journal.getStorage();
        this.conf = conf;
        this.journalSyncInterval = conf.getLong("dfs.journalnode.sync.interval", 120000L);
        this.logSegmentTransferTimeout = conf.getInt("dfs.edit.log.transfer.timeout", 30000);
        this.throttler = JournalNodeSyncer.getThrottler(conf);
        this.metrics = journal.getMetrics();
        this.journalSyncerStarted = false;
    }

    void stopSync() {
        this.shouldSync = false;
        File editsSyncDir = this.journal.getStorage().getEditsSyncDir();
        if (editsSyncDir.exists()) {
            FileUtil.fullyDelete((File)editsSyncDir);
        }
        if (this.syncJournalDaemon != null) {
            this.syncJournalDaemon.interrupt();
        }
    }

    public void start(String nsId) {
        if (nsId != null) {
            this.nameServiceId = nsId;
            this.journal.setTriedJournalSyncerStartedwithnsId(true);
        }
        if (!this.journalSyncerStarted && this.getOtherJournalNodeProxies()) {
            LOG.info("Starting SyncJournal daemon for journal " + this.jid);
            this.startSyncJournalsDaemon();
            this.journalSyncerStarted = true;
        }
    }

    public boolean isJournalSyncerStarted() {
        return this.journalSyncerStarted;
    }

    private boolean createEditsSyncDir() {
        File editsSyncDir = this.journal.getStorage().getEditsSyncDir();
        if (editsSyncDir.exists()) {
            LOG.info(editsSyncDir + " directory already exists.");
            return true;
        }
        return editsSyncDir.mkdir();
    }

    private boolean getOtherJournalNodeProxies() {
        List<InetSocketAddress> otherJournalNodes = this.getOtherJournalNodeAddrs();
        if (otherJournalNodes == null || otherJournalNodes.isEmpty()) {
            LOG.warn("Other JournalNode addresses not available. Journal Syncing cannot be done");
            return false;
        }
        for (InetSocketAddress addr : otherJournalNodes) {
            try {
                this.otherJNProxies.add(new JournalNodeProxy(addr));
            }
            catch (IOException e) {
                LOG.warn("Could not add proxy for Journal at addresss " + addr, (Throwable)e);
            }
        }
        if (this.otherJNProxies.isEmpty()) {
            LOG.error("Cannot sync as there is no other JN available for sync.");
            return false;
        }
        this.numOtherJNs = this.otherJNProxies.size();
        return true;
    }

    private void startSyncJournalsDaemon() {
        this.syncJournalDaemon = new Daemon(() -> {
            while (!this.journal.isFormatted()) {
                try {
                    Thread.sleep(this.journalSyncInterval);
                }
                catch (InterruptedException e) {
                    LOG.error("JournalNodeSyncer daemon received Runtime exception.", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (!this.createEditsSyncDir()) {
                LOG.error("Failed to create directory for downloading log segments: {}. Stopping Journal Node Sync.", (Object)this.journal.getStorage().getEditsSyncDir());
                return;
            }
            while (this.shouldSync) {
                try {
                    if (!this.journal.isFormatted()) {
                        LOG.warn("Journal cannot sync. Not formatted.");
                    } else {
                        this.syncJournals();
                    }
                }
                catch (Throwable t) {
                    if (!this.shouldSync) {
                        if (t instanceof InterruptedException) {
                            LOG.info("Stopping JournalNode Sync.");
                            Thread.currentThread().interrupt();
                            return;
                        }
                        LOG.warn("JournalNodeSyncer received an exception while shutting down.", t);
                        break;
                    }
                    if (t instanceof InterruptedException) {
                        LOG.warn("JournalNodeSyncer interrupted", t);
                        Thread.currentThread().interrupt();
                        return;
                    }
                    LOG.error("JournalNodeSyncer daemon received Runtime exception. ", t);
                }
                try {
                    Thread.sleep(this.journalSyncInterval);
                }
                catch (InterruptedException e) {
                    if (!this.shouldSync) {
                        LOG.info("Stopping JournalNode Sync.");
                    } else {
                        LOG.warn("JournalNodeSyncer interrupted", (Throwable)e);
                    }
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        });
        this.syncJournalDaemon.start();
    }

    private void syncJournals() {
        this.syncWithJournalAtIndex(this.journalNodeIndexForSync);
        this.journalNodeIndexForSync = (this.journalNodeIndexForSync + 1) % this.numOtherJNs;
    }

    private void syncWithJournalAtIndex(int index) {
        QJournalProtocolProtos.GetEditLogManifestResponseProto editLogManifest;
        List<RemoteEditLog> thisJournalEditLogs;
        LOG.info("Syncing Journal " + this.jn.getBoundIpcAddress().getAddress() + ":" + this.jn.getBoundIpcAddress().getPort() + " with " + this.otherJNProxies.get(index) + ", journal id: " + this.jid);
        InterQJournalProtocol jnProxy = this.otherJNProxies.get(index).jnProxy;
        if (jnProxy == null) {
            LOG.error("JournalNode Proxy not found.");
            return;
        }
        try {
            thisJournalEditLogs = this.journal.getEditLogManifest(0L, false).getLogs();
        }
        catch (IOException e) {
            LOG.error("Exception in getting local edit log manifest", (Throwable)e);
            return;
        }
        try {
            editLogManifest = jnProxy.getEditLogManifestFromJournal(this.jid, this.nameServiceId, 0L, false);
        }
        catch (IOException e) {
            LOG.debug("Could not sync with Journal at {}.", (Object)this.otherJNProxies.get(this.journalNodeIndexForSync), (Object)e);
            return;
        }
        this.getMissingLogSegments(thisJournalEditLogs, editLogManifest, this.otherJNProxies.get(index));
    }

    private List<InetSocketAddress> getOtherJournalNodeAddrs() {
        String uriStr = "";
        try {
            uriStr = this.conf.getTrimmed("dfs.namenode.shared.edits.dir");
            if ((uriStr == null || uriStr.isEmpty()) && this.nameServiceId != null) {
                uriStr = this.conf.getTrimmed("dfs.namenode.shared.edits.dir." + this.nameServiceId);
            }
            if (uriStr == null || uriStr.isEmpty()) {
                HashSet sharedEditsUri = Sets.newHashSet();
                if (this.nameServiceId != null) {
                    Collection nnIds = DFSUtilClient.getNameNodeIds((Configuration)this.conf, (String)this.nameServiceId);
                    for (String nnId : nnIds) {
                        String suffix = this.nameServiceId + "." + nnId;
                        uriStr = this.conf.getTrimmed("dfs.namenode.shared.edits.dir." + suffix);
                        sharedEditsUri.add(uriStr);
                    }
                    if (sharedEditsUri.size() > 1) {
                        uriStr = null;
                        LOG.error("The conf property dfs.namenode.shared.edits.dir not set properly, it has been configured with different journalnode values " + sharedEditsUri.toString() + " for a single nameserviceId" + this.nameServiceId);
                    }
                }
            }
            if (uriStr == null || uriStr.isEmpty()) {
                LOG.error("Could not construct Shared Edits Uri");
                return null;
            }
            return this.getJournalAddrList(uriStr);
        }
        catch (URISyntaxException e) {
            LOG.error("The conf property dfs.namenode.shared.edits.dir not set properly.");
        }
        catch (IOException e) {
            LOG.error("Could not parse JournalNode addresses: " + uriStr);
        }
        return null;
    }

    private List<InetSocketAddress> getJournalAddrList(String uriStr) throws URISyntaxException, IOException {
        URI uri = new URI(uriStr);
        return Util.getLoggerAddresses(uri, Sets.newHashSet((Object[])new InetSocketAddress[]{this.jn.getBoundIpcAddress()}));
    }

    private void getMissingLogSegments(List<RemoteEditLog> thisJournalEditLogs, QJournalProtocolProtos.GetEditLogManifestResponseProto response, JournalNodeProxy remoteJNproxy) {
        List<RemoteEditLog> otherJournalEditLogs = PBHelper.convert(response.getManifest()).getLogs();
        if (otherJournalEditLogs == null || otherJournalEditLogs.isEmpty()) {
            LOG.warn("Journal at " + remoteJNproxy.jnAddr + " has no edit logs");
            return;
        }
        List<RemoteEditLog> missingLogs = this.getMissingLogList(thisJournalEditLogs, otherJournalEditLogs);
        if (!missingLogs.isEmpty()) {
            NamespaceInfo nsInfo = this.jnStorage.getNamespaceInfo();
            for (RemoteEditLog missingLog : missingLogs) {
                URL url = null;
                boolean success = false;
                try {
                    if (remoteJNproxy.httpServerUrl == null) {
                        if (response.hasFromURL()) {
                            remoteJNproxy.httpServerUrl = this.getHttpServerURI(response.getFromURL(), remoteJNproxy.jnAddr.getHostName());
                        } else {
                            LOG.error("EditLogManifest response does not have fromUrl field set. Aborting current sync attempt");
                            break;
                        }
                    }
                    String urlPath = GetJournalEditServlet.buildPath(this.jid, missingLog.getStartTxId(), nsInfo, false);
                    url = new URL(remoteJNproxy.httpServerUrl, urlPath);
                    success = this.downloadMissingLogSegment(url, missingLog);
                }
                catch (URISyntaxException e) {
                    LOG.error("EditLogManifest's fromUrl field syntax incorrect", (Throwable)e);
                }
                catch (MalformedURLException e) {
                    LOG.error("MalformedURL when download missing log segment", (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error("Exception in downloading missing log segment from url " + url, (Throwable)e);
                }
                if (success) continue;
                LOG.error("Aborting current sync attempt.");
                break;
            }
        }
    }

    private List<RemoteEditLog> getMissingLogList(List<RemoteEditLog> thisJournalEditLogs, List<RemoteEditLog> otherJournalEditLogs) {
        if (thisJournalEditLogs.isEmpty()) {
            return otherJournalEditLogs;
        }
        ArrayList missingEditLogs = Lists.newArrayList();
        int localJnIndex = 0;
        int remoteJnIndex = 0;
        int localJnNumLogs = thisJournalEditLogs.size();
        int remoteJnNumLogs = otherJournalEditLogs.size();
        while (localJnIndex < localJnNumLogs && remoteJnIndex < remoteJnNumLogs) {
            long remoteJNstartTxId;
            long localJNstartTxId = thisJournalEditLogs.get(localJnIndex).getStartTxId();
            if (localJNstartTxId == (remoteJNstartTxId = otherJournalEditLogs.get(remoteJnIndex).getStartTxId())) {
                ++localJnIndex;
                ++remoteJnIndex;
                continue;
            }
            if (localJNstartTxId > remoteJNstartTxId) {
                missingEditLogs.add(otherJournalEditLogs.get(remoteJnIndex));
                ++remoteJnIndex;
                continue;
            }
            ++localJnIndex;
        }
        if (remoteJnIndex < remoteJnNumLogs) {
            while (remoteJnIndex < remoteJnNumLogs) {
                missingEditLogs.add(otherJournalEditLogs.get(remoteJnIndex));
                ++remoteJnIndex;
            }
        }
        return missingEditLogs;
    }

    private URL getHttpServerURI(String fromUrl, String hostAddr) throws URISyntaxException, MalformedURLException {
        URI uri = new URI(fromUrl);
        return new URL(uri.getScheme(), hostAddr, uri.getPort(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadMissingLogSegment(URL url, RemoteEditLog log) throws IOException {
        LOG.info("Downloading missing Edit Log from " + url + " to " + this.jnStorage.getRoot());
        assert (log.getStartTxId() > 0L && log.getEndTxId() > 0L) : "bad log: " + log;
        File finalEditsFile = this.jnStorage.getFinalizedEditsFile(log.getStartTxId(), log.getEndTxId());
        if (finalEditsFile.exists() && FileUtil.canRead((File)finalEditsFile)) {
            LOG.info("Skipping download of remote edit log " + log + " since it's already stored locally at " + finalEditsFile);
            return true;
        }
        File tmpEditsFile = this.jnStorage.getTemporaryEditsFile(log.getStartTxId(), log.getEndTxId());
        if (!((Boolean)SecurityUtil.doAsLoginUser(() -> {
            if (UserGroupInformation.isSecurityEnabled()) {
                UserGroupInformation.getCurrentUser().checkTGTAndReloginFromKeytab();
            }
            try {
                Util.doGetUrl(url, (List<File>)ImmutableList.of((Object)tmpEditsFile), this.jnStorage, false, this.logSegmentTransferTimeout, this.throttler);
            }
            catch (IOException e) {
                LOG.error("Download of Edit Log file for Syncing failed. Deleting temp file: " + tmpEditsFile, (Throwable)e);
                if (!tmpEditsFile.delete()) {
                    LOG.warn("Deleting " + tmpEditsFile + " has failed");
                }
                return false;
            }
            return true;
        })).booleanValue()) {
            return false;
        }
        LOG.info("Downloaded file " + tmpEditsFile.getName() + " of size " + tmpEditsFile.length() + " bytes.");
        boolean moveSuccess = false;
        try {
            moveSuccess = this.journal.moveTmpSegmentToCurrent(tmpEditsFile, finalEditsFile, log.getEndTxId());
        }
        catch (IOException e) {
            LOG.info("Could not move {} to current directory.", (Object)tmpEditsFile);
        }
        finally {
            if (tmpEditsFile.exists() && !tmpEditsFile.delete()) {
                LOG.warn("Deleting " + tmpEditsFile + " has failed");
            }
        }
        if (moveSuccess) {
            this.metrics.incrNumEditLogsSynced();
            return true;
        }
        return false;
    }

    private static DataTransferThrottler getThrottler(Configuration conf) {
        long transferBandwidth = conf.getLong("dfs.edit.log.transfer.bandwidthPerSec", 0L);
        DataTransferThrottler throttler = null;
        if (transferBandwidth > 0L) {
            throttler = new DataTransferThrottler(transferBandwidth);
        }
        return throttler;
    }

    private class JournalNodeProxy {
        private final InetSocketAddress jnAddr;
        private final InterQJournalProtocol jnProxy;
        private URL httpServerUrl;

        JournalNodeProxy(final InetSocketAddress jnAddr) throws IOException {
            final Configuration confCopy = new Configuration(JournalNodeSyncer.this.conf);
            this.jnAddr = jnAddr;
            this.jnProxy = (InterQJournalProtocol)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<InterQJournalProtocol>(){

                @Override
                public InterQJournalProtocol run() throws IOException {
                    RPC.setProtocolEngine((Configuration)confCopy, InterQJournalProtocolPB.class, ProtobufRpcEngine.class);
                    InterQJournalProtocolPB interQJournalProtocolPB = (InterQJournalProtocolPB)RPC.getProxy(InterQJournalProtocolPB.class, (long)RPC.getProtocolVersion(InterQJournalProtocolPB.class), (InetSocketAddress)jnAddr, (Configuration)confCopy);
                    return new InterQJournalProtocolTranslatorPB(interQJournalProtocolPB);
                }
            });
        }

        public String toString() {
            return this.jnAddr.toString();
        }
    }
}

