/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BBUploadHandle;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MultipartUploader;
import org.apache.hadoop.fs.MultipartUploaderFactory;
import org.apache.hadoop.fs.PartHandle;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.UploadHandle;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.shaded.com.google.common.base.Charsets;
import org.apache.hadoop.shaded.org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractMultipartUploaderTest
extends AbstractFSContractTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractContractMultipartUploaderTest.class);
    protected static final int SMALL_FILE = 100;
    private MultipartUploader mpu;
    private MultipartUploader mpu2;
    private final Random random = new Random();
    private UploadHandle activeUpload;
    private Path activeUploadPath;

    protected String getMethodName() {
        return this.methodName.getMethodName();
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        Configuration conf = this.getContract().getConf();
        this.mpu = MultipartUploaderFactory.get((FileSystem)this.getFileSystem(), (Configuration)conf);
        this.mpu2 = MultipartUploaderFactory.get((FileSystem)this.getFileSystem(), (Configuration)conf);
    }

    @Override
    public void teardown() throws Exception {
        if (this.mpu != null && this.activeUpload != null) {
            try {
                this.mpu.abort(this.activeUploadPath, this.activeUpload);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                LOG.info("in teardown", (Throwable)e);
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.mpu, this.mpu2});
        super.teardown();
    }

    protected Path methodPath() throws IOException {
        return this.path(this.getMethodName());
    }

    private byte[] generatePayload(int partNumber) {
        return this.generatePayload(partNumber, this.partSizeInBytes());
    }

    private byte[] generatePayload(int partNumber, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (int i = 0; i < size / 4; ++i) {
            buffer.putInt(partNumber);
        }
        return buffer.array();
    }

    /*
     * Exception decompiling
     */
    protected byte[] digest(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract int partSizeInBytes();

    protected int getTestPayloadCount() {
        return 10;
    }

    protected int timeToBecomeConsistentMillis() {
        return 0;
    }

    protected abstract boolean finalizeConsumesUploadIdImmediately();

    protected abstract boolean supportsConcurrentUploadsToSamePath();

    protected MultipartUploader mpu(int index) {
        return index % 2 == 0 ? this.mpu : this.mpu2;
    }

    protected MultipartUploader randomMpu() {
        return this.mpu(this.random.nextInt(10));
    }

    @Test
    public void testSingleUpload() throws Exception {
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.initializeUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int size = 100;
        byte[] payload = this.generatePayload(1, size);
        origDigest.update(payload);
        PartHandle partHandle = this.putPart(file, uploadHandle, 1, payload);
        partHandles.put(1, partHandle);
        PathHandle fd = this.completeUpload(file, uploadHandle, partHandles, origDigest, size);
        if (this.finalizeConsumesUploadIdImmediately()) {
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.mpu.complete(file, partHandles, uploadHandle));
        } else {
            PathHandle fd2 = this.mpu.complete(file, partHandles, uploadHandle);
            AbstractContractMultipartUploaderTest.assertArrayEquals((String)"Path handles differ", (byte[])fd.toByteArray(), (byte[])fd2.toByteArray());
        }
    }

    protected UploadHandle initializeUpload(Path dest) throws IOException {
        this.activeUploadPath = dest;
        this.activeUpload = this.randomMpu().initialize(dest);
        return this.activeUpload;
    }

    protected PartHandle buildAndPutPart(Path file, UploadHandle uploadHandle, int index, MessageDigest origDigest) throws IOException {
        byte[] payload = this.generatePayload(index);
        if (origDigest != null) {
            origDigest.update(payload);
        }
        return this.putPart(file, uploadHandle, index, payload);
    }

    protected PartHandle putPart(Path file, UploadHandle uploadHandle, int index, byte[] payload) throws IOException {
        ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
        PartHandle partHandle = this.mpu(index).putPart(file, (InputStream)new ByteArrayInputStream(payload), index, uploadHandle, (long)payload.length);
        timer.end("Uploaded part %s", index);
        LOG.info("Upload bandwidth {} MB/s", (Object)timer.bandwidthDescription(payload.length));
        return partHandle;
    }

    private PathHandle completeUpload(Path file, UploadHandle uploadHandle, Map<Integer, PartHandle> partHandles, MessageDigest origDigest, int expectedLength) throws IOException {
        PathHandle fd = this.complete(file, uploadHandle, partHandles);
        FileStatus status = ContractTestUtils.verifyPathExists(this.getFileSystem(), "Completed file", file);
        AbstractContractMultipartUploaderTest.assertEquals((String)("length of " + status), (long)expectedLength, (long)status.getLen());
        if (origDigest != null) {
            this.verifyContents(file, origDigest, expectedLength);
        }
        return fd;
    }

    protected void verifyContents(Path file, MessageDigest origDigest, int expectedLength) throws IOException {
        ContractTestUtils.NanoTimer timer2 = new ContractTestUtils.NanoTimer();
        AbstractContractMultipartUploaderTest.assertArrayEquals((String)("digest of source and " + file + " differ"), (byte[])origDigest.digest(), (byte[])this.digest(file));
        timer2.end("Completed digest", file);
        LOG.info("Download bandwidth {} MB/s", (Object)timer2.bandwidthDescription(expectedLength));
    }

    private PathHandle complete(Path file, UploadHandle uploadHandle, Map<Integer, PartHandle> partHandles) throws IOException {
        ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
        PathHandle fd = this.randomMpu().complete(file, partHandles, uploadHandle);
        timer.end("Completed upload to %s", file);
        return fd;
    }

    private void abortUpload(Path file, UploadHandle uploadHandle) throws IOException {
        this.randomMpu().abort(file, uploadHandle);
    }

    @Test
    public void testMultipartUpload() throws Exception {
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.initializeUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int payloadCount = this.getTestPayloadCount();
        for (int i = 1; i <= payloadCount; ++i) {
            PartHandle partHandle = this.buildAndPutPart(file, uploadHandle, i, origDigest);
            partHandles.put(i, partHandle);
        }
        this.completeUpload(file, uploadHandle, partHandles, origDigest, payloadCount * this.partSizeInBytes());
    }

    @Test
    public void testMultipartUploadEmptyPart() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path file = this.path("testMultipartUpload");
        try (MultipartUploader uploader = MultipartUploaderFactory.get((FileSystem)fs, null);){
            UploadHandle uploadHandle = uploader.initialize(file);
            HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
            MessageDigest origDigest = DigestUtils.getMd5Digest();
            byte[] payload = new byte[]{};
            origDigest.update(payload);
            ByteArrayInputStream is = new ByteArrayInputStream(payload);
            PartHandle partHandle = uploader.putPart(file, (InputStream)is, 1, uploadHandle, (long)payload.length);
            partHandles.put(1, partHandle);
            this.completeUpload(file, uploadHandle, partHandles, origDigest, 0);
        }
    }

    @Test
    public void testUploadEmptyBlock() throws Exception {
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.initializeUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        partHandles.put(1, this.putPart(file, uploadHandle, 1, new byte[0]));
        this.completeUpload(file, uploadHandle, partHandles, null, 0);
    }

    @Test
    public void testMultipartUploadReverseOrder() throws Exception {
        int i;
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.initializeUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int payloadCount = this.getTestPayloadCount();
        for (i = 1; i <= payloadCount; ++i) {
            byte[] payload = this.generatePayload(i);
            origDigest.update(payload);
        }
        for (i = payloadCount; i > 0; --i) {
            partHandles.put(i, this.buildAndPutPart(file, uploadHandle, i, null));
        }
        this.completeUpload(file, uploadHandle, partHandles, origDigest, payloadCount * this.partSizeInBytes());
    }

    @Test
    public void testMultipartUploadReverseOrderNonContiguousPartNumbers() throws Exception {
        this.describe("Upload in reverse order and the part numbers are not contiguous");
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.initializeUpload(file);
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int payloadCount = 2 * this.getTestPayloadCount();
        for (int i = 2; i <= payloadCount; i += 2) {
            byte[] payload = this.generatePayload(i);
            origDigest.update(payload);
        }
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        for (int i = payloadCount; i > 0; i -= 2) {
            partHandles.put(i, this.buildAndPutPart(file, uploadHandle, i, null));
        }
        this.completeUpload(file, uploadHandle, partHandles, origDigest, this.getTestPayloadCount() * this.partSizeInBytes());
    }

    @Test
    public void testMultipartUploadAbort() throws Exception {
        this.describe("Upload and then abort it before completing");
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.initializeUpload(file);
        int end = 10;
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        for (int i = 12; i > 10; --i) {
            partHandles.put(i, this.buildAndPutPart(file, uploadHandle, i, null));
        }
        this.abortUpload(file, uploadHandle);
        String contents = "ThisIsPart49\n";
        int len = contents.getBytes(Charsets.UTF_8).length;
        InputStream is = org.apache.hadoop.shaded.org.apache.commons.io.IOUtils.toInputStream((String)contents, (String)"UTF-8");
        LambdaTestUtils.intercept(IOException.class, () -> this.mpu.putPart(file, is, 49, uploadHandle, (long)len));
        LambdaTestUtils.intercept(IOException.class, () -> this.mpu.complete(file, partHandles, uploadHandle));
        this.assertPathDoesNotExist("Uploaded file should not exist", file);
        if (this.finalizeConsumesUploadIdImmediately()) {
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.abortUpload(file, uploadHandle));
        } else {
            this.abortUpload(file, uploadHandle);
        }
    }

    @Test
    public void testAbortUnknownUpload() throws Exception {
        Path file = this.methodPath();
        ByteBuffer byteBuffer = ByteBuffer.wrap("invalid-handle".getBytes(Charsets.UTF_8));
        UploadHandle uploadHandle = BBUploadHandle.from((ByteBuffer)byteBuffer);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.abortUpload(file, uploadHandle));
    }

    @Test
    public void testAbortEmptyUpload() throws Exception {
        this.describe("initialize upload and abort before uploading data");
        Path file = this.methodPath();
        this.abortUpload(file, this.initializeUpload(file));
        this.assertPathDoesNotExist("Uploaded file should not exist", file);
    }

    @Test
    public void testAbortEmptyUploadHandle() throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[0]);
        UploadHandle uploadHandle = BBUploadHandle.from((ByteBuffer)byteBuffer);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.abortUpload(this.methodPath(), uploadHandle));
    }

    @Test
    public void testCompleteEmptyUpload() throws Exception {
        this.describe("Expect an empty MPU to fail, but still be abortable");
        Path dest = this.methodPath();
        UploadHandle handle = this.initializeUpload(dest);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.mpu.complete(dest, new HashMap(), handle));
        this.abortUpload(dest, handle);
    }

    @Test
    public void testPutPartEmptyUploadID() throws Exception {
        this.describe("Expect IllegalArgumentException when putPart uploadID is empty");
        Path dest = this.methodPath();
        UploadHandle emptyHandle = BBUploadHandle.from((ByteBuffer)ByteBuffer.wrap(new byte[0]));
        byte[] payload = this.generatePayload(1);
        ByteArrayInputStream is = new ByteArrayInputStream(payload);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.mpu.putPart(dest, is, 1, emptyHandle, (long)payload.length));
    }

    @Test
    public void testCompleteEmptyUploadID() throws Exception {
        this.describe("Expect IllegalArgumentException when complete uploadID is empty");
        Path dest = this.methodPath();
        UploadHandle realHandle = this.initializeUpload(dest);
        UploadHandle emptyHandle = BBUploadHandle.from((ByteBuffer)ByteBuffer.wrap(new byte[0]));
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        PartHandle partHandle = this.putPart(dest, realHandle, 1, this.generatePayload(1, 100));
        partHandles.put(1, partHandle);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.mpu.complete(dest, partHandles, emptyHandle));
        partHandles.clear();
        partHandles.put(0, partHandle);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.mpu.complete(dest, partHandles, realHandle));
    }

    @Test
    public void testDirectoryInTheWay() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.initializeUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        int size = 100;
        PartHandle partHandle = this.putPart(file, uploadHandle, 1, this.generatePayload(1, size));
        partHandles.put(1, partHandle);
        fs.mkdirs(file);
        LambdaTestUtils.intercept(IOException.class, () -> this.completeUpload(file, uploadHandle, partHandles, null, size));
        this.abortUpload(file, uploadHandle);
    }

    @Test
    public void testConcurrentUploads() throws Throwable {
        UploadHandle upload2;
        boolean concurrent = this.supportsConcurrentUploadsToSamePath();
        this.describe("testing concurrent uploads, MPU support for this is " + concurrent);
        FileSystem fs = this.getFileSystem();
        Path file = this.methodPath();
        int size1 = 100;
        boolean partId1 = true;
        byte[] payload1 = this.generatePayload(1, 100);
        MessageDigest digest1 = DigestUtils.getMd5Digest();
        digest1.update(payload1);
        UploadHandle upload1 = this.initializeUpload(file);
        HashMap<Integer, PartHandle> partHandles1 = new HashMap<Integer, PartHandle>();
        int size2 = 200;
        int partId2 = 2;
        byte[] payload2 = this.generatePayload(1, 200);
        MessageDigest digest2 = DigestUtils.getMd5Digest();
        digest2.update(payload2);
        try {
            upload2 = this.initializeUpload(file);
            Assume.assumeTrue((String)"The Filesystem is unexpectedly supporting concurrent uploads", (boolean)concurrent);
        }
        catch (IOException e) {
            if (!concurrent) {
                LOG.debug("Expected exception raised on concurrent uploads {}", (Throwable)e);
                return;
            }
            throw e;
        }
        HashMap<Integer, PartHandle> partHandles2 = new HashMap<Integer, PartHandle>();
        AbstractContractMultipartUploaderTest.assertNotEquals((String)"Upload handles match", (Object)upload1, (Object)upload2);
        partHandles1.put(1, this.putPart(file, upload1, 1, payload1));
        partHandles2.put(2, this.putPart(file, upload2, 2, payload2));
        this.completeUpload(file, upload1, partHandles1, digest1, 100);
        this.complete(file, upload2, partHandles2);
        LambdaTestUtils.eventually(this.timeToBecomeConsistentMillis(), 500, () -> {
            FileStatus status = fs.getFileStatus(file);
            AbstractContractMultipartUploaderTest.assertEquals((String)("File length in " + status), (long)200L, (long)status.getLen());
        });
        this.verifyContents(file, digest2, 200);
    }
}

