/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.InvalidPathHandleException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.RawPathHandle;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractContractPathHandleTest
extends AbstractFSContractTestBase {
    private final Options.HandleOpt[] opts;
    private final boolean serialized;
    private static final byte[] B1 = ContractTestUtils.dataset(1024, 43, 255);
    private static final byte[] B2 = ContractTestUtils.dataset(1024, 44, 255);

    public AbstractContractPathHandleTest(String testname, Options.HandleOpt[] opts, boolean serialized) {
        this.opts = opts;
        this.serialized = serialized;
    }

    @Parameterized.Parameters(name="Test{0}")
    public static Collection<Object[]> params() {
        return Arrays.asList(Arrays.asList("Exact", Options.HandleOpt.exact()), Arrays.asList("Content", Options.HandleOpt.content()), Arrays.asList("Path", Options.HandleOpt.path()), Arrays.asList("Reference", Options.HandleOpt.reference())).stream().flatMap(x -> Arrays.asList(true, false).stream().map(b -> {
            ArrayList<Boolean> y = new ArrayList<Boolean>((Collection<Boolean>)x);
            y.add((Boolean)b);
            return y;
        })).map(ArrayList::toArray).collect(Collectors.toList());
    }

    @Override
    protected Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setInt("io.file.buffer.size", 4096);
        return conf;
    }

    @Test
    public void testIdent() throws IOException {
        this.describe("verify simple open, no changes");
        FileStatus stat = this.testFile(B1);
        PathHandle fd = this.getHandleOrSkip(stat);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), stat.getPath(), B1);
        try (FSDataInputStream in = this.getFileSystem().open(fd);){
            ContractTestUtils.verifyRead(in, B1, 0, 1024);
        }
    }

    @Test
    public void testChanged() throws IOException {
        this.describe("verify open(PathHandle, changed(*))");
        this.assumeSupportsContentCheck();
        Options.HandleOpt.Data data = (Options.HandleOpt.Data)Options.HandleOpt.getOpt(Options.HandleOpt.Data.class, (Options.HandleOpt[])this.opts).orElseThrow(IllegalArgumentException::new);
        FileStatus stat = this.testFile(B1);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        ContractTestUtils.appendFile(this.getFileSystem(), stat.getPath(), B2);
        byte[] b12 = Arrays.copyOf(B1, B1.length + B2.length);
        System.arraycopy(B2, 0, b12, B1.length, B2.length);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), stat.getPath(), b12);
        PathHandle fd = this.getHandleOrSkip(stat);
        try (FSDataInputStream in = this.getFileSystem().open(fd);){
            AbstractContractPathHandleTest.assertTrue((String)"Failed to detect content change", (boolean)data.allowChange());
            ContractTestUtils.verifyRead(in, b12, 0, b12.length);
        }
        catch (InvalidPathHandleException e) {
            AbstractContractPathHandleTest.assertFalse((String)"Failed to allow content change", (boolean)data.allowChange());
        }
    }

    @Test
    public void testMoved() throws IOException {
        this.describe("verify open(PathHandle, moved(*))");
        this.assumeSupportsFileReference();
        Options.HandleOpt.Location loc = (Options.HandleOpt.Location)Options.HandleOpt.getOpt(Options.HandleOpt.Location.class, (Options.HandleOpt[])this.opts).orElseThrow(IllegalArgumentException::new);
        FileStatus stat = this.testFile(B1);
        ContractTestUtils.rename(this.getFileSystem(), stat.getPath(), this.path(stat.getPath() + "2"));
        PathHandle fd = this.getHandleOrSkip(stat);
        try (FSDataInputStream in = this.getFileSystem().open(fd);){
            AbstractContractPathHandleTest.assertTrue((String)"Failed to detect location change", (boolean)loc.allowChange());
            ContractTestUtils.verifyRead(in, B1, 0, B1.length);
        }
        catch (InvalidPathHandleException e) {
            AbstractContractPathHandleTest.assertFalse((String)"Failed to allow location change", (boolean)loc.allowChange());
        }
    }

    @Test
    public void testChangedAndMoved() throws IOException {
        block15: {
            this.describe("verify open(PathHandle, changed(*), moved(*))");
            this.assumeSupportsFileReference();
            this.assumeSupportsContentCheck();
            Options.HandleOpt.Data data = (Options.HandleOpt.Data)Options.HandleOpt.getOpt(Options.HandleOpt.Data.class, (Options.HandleOpt[])this.opts).orElseThrow(IllegalArgumentException::new);
            Options.HandleOpt.Location loc = (Options.HandleOpt.Location)Options.HandleOpt.getOpt(Options.HandleOpt.Location.class, (Options.HandleOpt[])this.opts).orElseThrow(IllegalArgumentException::new);
            FileStatus stat = this.testFile(B1);
            Path dst = this.path(stat.getPath() + "2");
            ContractTestUtils.rename(this.getFileSystem(), stat.getPath(), dst);
            ContractTestUtils.appendFile(this.getFileSystem(), dst, B2);
            PathHandle fd = this.getHandleOrSkip(stat);
            byte[] b12 = Arrays.copyOf(B1, B1.length + B2.length);
            System.arraycopy(B2, 0, b12, B1.length, B2.length);
            try (FSDataInputStream in = this.getFileSystem().open(fd);){
                AbstractContractPathHandleTest.assertTrue((String)"Failed to detect location change", (boolean)loc.allowChange());
                AbstractContractPathHandleTest.assertTrue((String)"Failed to detect content change", (boolean)data.allowChange());
                ContractTestUtils.verifyRead(in, b12, 0, b12.length);
            }
            catch (InvalidPathHandleException e) {
                if (data.allowChange()) {
                    AbstractContractPathHandleTest.assertFalse((String)"Failed to allow location change", (boolean)loc.allowChange());
                }
                if (!loc.allowChange()) break block15;
                AbstractContractPathHandleTest.assertFalse((String)"Failed to allow content change", (boolean)data.allowChange());
            }
        }
    }

    private FileStatus testFile(byte[] content) throws IOException {
        Path path = this.path(this.methodName.getMethodName());
        ContractTestUtils.createFile(this.getFileSystem(), path, false, content);
        FileStatus stat = this.getFileSystem().getFileStatus(path);
        AbstractContractPathHandleTest.assertNotNull((Object)stat);
        AbstractContractPathHandleTest.assertEquals((Object)path, (Object)stat.getPath());
        return stat;
    }

    protected void assumeSupportsFileReference() throws IOException {
        if (this.getContract().isSupported("supports-file-reference", false)) {
            return;
        }
        ContractTestUtils.skip("Skipping as unsupported feature: supports-file-reference");
    }

    protected void assumeSupportsContentCheck() throws IOException {
        if (this.getContract().isSupported("supports-content-check", false)) {
            return;
        }
        ContractTestUtils.skip("Skipping as unsupported feature: supports-content-check");
    }

    protected PathHandle getHandleOrSkip(FileStatus stat) {
        try {
            PathHandle fd = this.getFileSystem().getPathHandle(stat, this.opts);
            if (this.serialized) {
                ByteBuffer sb = fd.bytes();
                return new RawPathHandle(sb);
            }
            return fd;
        }
        catch (UnsupportedOperationException e) {
            ContractTestUtils.skip("FileSystem does not support " + Arrays.toString(this.opts));
            return null;
        }
    }
}

