/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationRPCMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.RouterNamenodeProtocol;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcMonitor;
import org.apache.hadoop.hdfs.server.federation.router.RouterSafemodeService;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterRpcServer
extends AbstractService
implements ClientProtocol,
NamenodeProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(RouterRpcServer.class);
    private Configuration conf;
    private final Router router;
    private final RPC.Server rpcServer;
    private final InetSocketAddress rpcAddress;
    private final RouterRpcClient rpcClient;
    private final RouterRpcMonitor rpcMonitor;
    private final ActiveNamenodeResolver namenodeResolver;
    private final FileSubclusterResolver subclusterResolver;
    private final ThreadLocal<NameNode.OperationCategory> opCategory = new ThreadLocal();
    private final Quota quotaCall;
    private final RouterNamenodeProtocol nnProto;
    private final RouterClientProtocol clientProto;

    public RouterRpcServer(Configuration configuration, Router router, ActiveNamenodeResolver nnResolver, FileSubclusterResolver fileResolver) throws IOException {
        super(RouterRpcServer.class.getName());
        this.conf = configuration;
        this.router = router;
        this.namenodeResolver = nnResolver;
        this.subclusterResolver = fileResolver;
        int handlerCount = this.conf.getInt("dfs.federation.router.handler.count", 10);
        int readerCount = this.conf.getInt("dfs.federation.router.reader.count", 1);
        int handlerQueueSize = this.conf.getInt("dfs.federation.router.handler.queue.size", 100);
        int readerQueueSize = this.conf.getInt("dfs.federation.router.reader.queue.size", 100);
        this.conf.setInt("ipc.server.read.connection-queue.size", readerQueueSize);
        RPC.setProtocolEngine((Configuration)this.conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        ClientNamenodeProtocolServerSideTranslatorPB clientProtocolServerTranslator = new ClientNamenodeProtocolServerSideTranslatorPB((ClientProtocol)this);
        BlockingService clientNNPbService = ClientNamenodeProtocolProtos.ClientNamenodeProtocol.newReflectiveBlockingService((ClientNamenodeProtocolProtos.ClientNamenodeProtocol.BlockingInterface)clientProtocolServerTranslator);
        NamenodeProtocolServerSideTranslatorPB namenodeProtocolXlator = new NamenodeProtocolServerSideTranslatorPB((NamenodeProtocol)this);
        BlockingService nnPbService = NamenodeProtocolProtos.NamenodeProtocolService.newReflectiveBlockingService((NamenodeProtocolProtos.NamenodeProtocolService.BlockingInterface)namenodeProtocolXlator);
        InetSocketAddress confRpcAddress = this.conf.getSocketAddr("dfs.federation.router.rpc-bind-host", "dfs.federation.router.rpc-address", "0.0.0.0:8888", 8888);
        LOG.info("RPC server binding to {} with {} handlers for Router {}", new Object[]{confRpcAddress, handlerCount, this.router.getRouterId()});
        this.rpcServer = new RPC.Builder(this.conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance((Object)clientNNPbService).setBindAddress(confRpcAddress.getHostName()).setPort(confRpcAddress.getPort()).setNumHandlers(handlerCount).setnumReaders(readerCount).setQueueSizePerHandler(handlerQueueSize).setVerbose(false).build();
        DFSUtil.addPBProtocol((Configuration)this.conf, NamenodeProtocolPB.class, (BlockingService)nnPbService, (RPC.Server)this.rpcServer);
        this.rpcServer.addTerseExceptions(new Class[]{RemoteException.class, SafeModeException.class, FileNotFoundException.class, FileAlreadyExistsException.class, AccessControlException.class, LeaseExpiredException.class, NotReplicatedYetException.class, IOException.class});
        this.rpcServer.addSuppressedLoggingExceptions(new Class[]{StandbyException.class});
        InetSocketAddress listenAddress = this.rpcServer.getListenerAddress();
        this.rpcAddress = new InetSocketAddress(confRpcAddress.getHostName(), listenAddress.getPort());
        Class rpcMonitorClass = this.conf.getClass("dfs.federation.router.metrics.class", RBFConfigKeys.DFS_ROUTER_METRICS_CLASS_DEFAULT, RouterRpcMonitor.class);
        this.rpcMonitor = (RouterRpcMonitor)ReflectionUtils.newInstance((Class)rpcMonitorClass, (Configuration)this.conf);
        this.rpcClient = new RouterRpcClient(this.conf, this.router, this.namenodeResolver, this.rpcMonitor);
        this.quotaCall = new Quota(this.router, this);
        this.nnProto = new RouterNamenodeProtocol(this);
        this.clientProto = new RouterClientProtocol(this.conf, this);
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.conf = configuration;
        if (this.rpcMonitor == null) {
            LOG.error("Cannot instantiate Router RPC metrics class");
        } else {
            this.rpcMonitor.init(this.conf, this, this.router.getStateStore());
        }
        super.serviceInit(configuration);
    }

    protected void serviceStart() throws Exception {
        if (this.rpcServer != null) {
            this.rpcServer.start();
            LOG.info("Router RPC up at: {}", (Object)this.getRpcAddress());
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.rpcMonitor != null) {
            this.rpcMonitor.close();
        }
        super.serviceStop();
    }

    public RouterRpcClient getRPCClient() {
        return this.rpcClient;
    }

    public FileSubclusterResolver getSubclusterResolver() {
        return this.subclusterResolver;
    }

    public ActiveNamenodeResolver getNamenodeResolver() {
        return this.namenodeResolver;
    }

    public RouterRpcMonitor getRPCMonitor() {
        return this.rpcMonitor;
    }

    @VisibleForTesting
    public RPC.Server getServer() {
        return this.rpcServer;
    }

    public InetSocketAddress getRpcAddress() {
        return this.rpcAddress;
    }

    void checkOperation(NameNode.OperationCategory op, boolean supported) throws StandbyException, UnsupportedOperationException {
        this.checkOperation(op);
        if (!supported) {
            if (this.rpcMonitor != null) {
                this.rpcMonitor.proxyOpNotImplemented();
            }
            String methodName = RouterRpcServer.getMethodName();
            throw new UnsupportedOperationException("Operation \"" + methodName + "\" is not supported");
        }
    }

    void checkOperation(NameNode.OperationCategory op) throws StandbyException {
        if (this.rpcMonitor != null) {
            this.rpcMonitor.startOp();
        }
        if (LOG.isDebugEnabled()) {
            String methodName = RouterRpcServer.getMethodName();
            LOG.debug("Proxying operation: {}", (Object)methodName);
        }
        this.opCategory.set(op);
        if (op == NameNode.OperationCategory.UNCHECKED || op == NameNode.OperationCategory.READ) {
            return;
        }
        RouterSafemodeService safemodeService = this.router.getSafemodeService();
        if (safemodeService != null && safemodeService.isInSafeMode()) {
            if (this.rpcMonitor != null) {
                this.rpcMonitor.routerFailureSafemode();
            }
            throw new StandbyException("Router " + this.router.getRouterId() + " is in safe mode and cannot handle " + op + " requests");
        }
    }

    static String getMethodName() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String methodName = stack[3].getMethodName();
        return methodName;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.clientProto.getDelegationToken(renewer);
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        return this.clientProto.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.clientProto.cancelDelegationToken(token);
    }

    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        return this.clientProto.getBlockLocations(src, offset, length);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.clientProto.getServerDefaults();
    }

    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, String ecPolicyName) throws IOException {
        return this.clientProto.create(src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions, ecPolicyName);
    }

    RemoteLocation getCreateLocation(String src) throws IOException {
        RemoteLocation createLocation;
        block6: {
            List<RemoteLocation> locations = this.getLocationsForPath(src, true);
            if (locations == null || locations.isEmpty()) {
                throw new IOException("Cannot get locations to create " + src);
            }
            createLocation = locations.get(0);
            if (locations.size() > 1) {
                try {
                    LocatedBlocks existingLocation = this.getBlockLocations(src, 0L, 1L);
                    if (existingLocation == null) break block6;
                    LocatedBlock existingLocationLastLocatedBlock = existingLocation.getLastLocatedBlock();
                    if (existingLocationLastLocatedBlock == null) {
                        for (RemoteLocation location : locations) {
                            RemoteMethod method;
                            if (this.rpcClient.invokeSingle(location, method = new RemoteMethod("getFileInfo", new Class[]{String.class}, new RemoteParam())) == null) continue;
                            createLocation = location;
                            break block6;
                        }
                        break block6;
                    }
                    ExtendedBlock existingLocationLastBlock = existingLocationLastLocatedBlock.getBlock();
                    String blockPoolId = existingLocationLastBlock.getBlockPoolId();
                    createLocation = this.getLocationForPath(src, true, blockPoolId);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return createLocation;
    }

    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws IOException {
        return this.clientProto.append(src, clientName, flag);
    }

    public boolean recoverLease(String src, String clientName) throws IOException {
        return this.clientProto.recoverLease(src, clientName);
    }

    public boolean setReplication(String src, short replication) throws IOException {
        return this.clientProto.setReplication(src, replication);
    }

    public void setStoragePolicy(String src, String policyName) throws IOException {
        this.clientProto.setStoragePolicy(src, policyName);
    }

    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        return this.clientProto.getStoragePolicies();
    }

    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.clientProto.setPermission(src, permissions);
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.clientProto.setOwner(src, username, groupname);
    }

    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, long fileId, String[] favoredNodes, EnumSet<AddBlockFlag> addBlockFlags) throws IOException {
        return this.clientProto.addBlock(src, clientName, previous, excludedNodes, fileId, favoredNodes, addBlockFlags);
    }

    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        return this.clientProto.getAdditionalDatanode(src, fileId, blk, existings, existingStorageIDs, excludes, numAdditionalNodes, clientName);
    }

    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        this.clientProto.abandonBlock(b, fileId, src, holder);
    }

    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId) throws IOException {
        return this.clientProto.complete(src, clientName, last, fileId);
    }

    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        return this.clientProto.updateBlockForPipeline(block, clientName);
    }

    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException {
        this.clientProto.updatePipeline(clientName, oldBlock, newBlock, newNodes, newStorageIDs);
    }

    public long getPreferredBlockSize(String src) throws IOException {
        return this.clientProto.getPreferredBlockSize(src);
    }

    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        return this.clientProto.rename(src, dst);
    }

    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        this.clientProto.rename2(src, dst, options);
    }

    public void concat(String trg, String[] src) throws IOException {
        this.clientProto.concat(trg, src);
    }

    public boolean truncate(String src, long newLength, String clientName) throws IOException {
        return this.clientProto.truncate(src, newLength, clientName);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        return this.clientProto.delete(src, recursive);
    }

    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        return this.clientProto.mkdirs(src, masked, createParent);
    }

    public void renewLease(String clientName) throws IOException {
        this.clientProto.renewLease(clientName);
    }

    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        return this.clientProto.getListing(src, startAfter, needLocation);
    }

    public HdfsFileStatus getFileInfo(String src) throws IOException {
        return this.clientProto.getFileInfo(src);
    }

    public boolean isFileClosed(String src) throws IOException {
        return this.clientProto.isFileClosed(src);
    }

    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        return this.clientProto.getFileLinkInfo(src);
    }

    public HdfsLocatedFileStatus getLocatedFileInfo(String src, boolean needBlockToken) throws IOException {
        return this.clientProto.getLocatedFileInfo(src, needBlockToken);
    }

    public long[] getStats() throws IOException {
        return this.clientProto.getStats();
    }

    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        return this.clientProto.getDatanodeReport(type);
    }

    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type, boolean requireResponse, long timeOutMs) throws IOException {
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        LinkedHashMap<String, DatanodeInfo> datanodesMap = new LinkedHashMap<String, DatanodeInfo>();
        RemoteMethod method = new RemoteMethod("getDatanodeReport", new Class[]{HdfsConstants.DatanodeReportType.class}, type);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, DatanodeInfo[]> results = this.rpcClient.invokeConcurrent(nss, method, requireResponse, false, timeOutMs, DatanodeInfo[].class);
        for (Map.Entry<FederationNamespaceInfo, DatanodeInfo[]> entry : results.entrySet()) {
            DatanodeInfo[] result;
            FederationNamespaceInfo ns = entry.getKey();
            for (DatanodeInfo node : result = entry.getValue()) {
                String nodeId = node.getXferAddr();
                if (!datanodesMap.containsKey(nodeId)) {
                    node.setNetworkLocation("/" + ns.getNameserviceId() + node.getNetworkLocation());
                    datanodesMap.put(nodeId, node);
                    continue;
                }
                LOG.debug("{} is in multiple subclusters", (Object)nodeId);
            }
        }
        Collection datanodes = datanodesMap.values();
        return RouterRpcServer.toArray(datanodes, DatanodeInfo.class);
    }

    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        return this.clientProto.getDatanodeStorageReport(type);
    }

    public Map<String, DatanodeStorageReport[]> getDatanodeStorageReportMap(HdfsConstants.DatanodeReportType type) throws IOException {
        LinkedHashMap<String, DatanodeStorageReport[]> ret = new LinkedHashMap<String, DatanodeStorageReport[]>();
        RemoteMethod method = new RemoteMethod("getDatanodeStorageReport", new Class[]{HdfsConstants.DatanodeReportType.class}, type);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, DatanodeStorageReport[]> results = this.rpcClient.invokeConcurrent(nss, method, true, false, DatanodeStorageReport[].class);
        for (Map.Entry<FederationNamespaceInfo, DatanodeStorageReport[]> entry : results.entrySet()) {
            FederationNamespaceInfo ns = entry.getKey();
            String nsId = ns.getNameserviceId();
            DatanodeStorageReport[] result = entry.getValue();
            ret.put(nsId, result);
        }
        return ret;
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        return this.clientProto.setSafeMode(action, isChecked);
    }

    public boolean restoreFailedStorage(String arg) throws IOException {
        return this.clientProto.restoreFailedStorage(arg);
    }

    public boolean saveNamespace(long timeWindow, long txGap) throws IOException {
        return this.clientProto.saveNamespace(timeWindow, txGap);
    }

    public long rollEdits() throws IOException {
        return this.clientProto.rollEdits();
    }

    public void refreshNodes() throws IOException {
        this.clientProto.refreshNodes();
    }

    public void finalizeUpgrade() throws IOException {
        this.clientProto.finalizeUpgrade();
    }

    public boolean upgradeStatus() throws IOException {
        return this.clientProto.upgradeStatus();
    }

    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        return this.clientProto.rollingUpgrade(action);
    }

    public void metaSave(String filename) throws IOException {
        this.clientProto.metaSave(filename);
    }

    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        return this.clientProto.listCorruptFileBlocks(path, cookie);
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.clientProto.setBalancerBandwidth(bandwidth);
    }

    public ContentSummary getContentSummary(String path) throws IOException {
        return this.clientProto.getContentSummary(path);
    }

    public void fsync(String src, long fileId, String clientName, long lastBlockLength) throws IOException {
        this.clientProto.fsync(src, fileId, clientName, lastBlockLength);
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.clientProto.setTimes(src, mtime, atime);
    }

    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        this.clientProto.createSymlink(target, link, dirPerms, createParent);
    }

    public String getLinkTarget(String path) throws IOException {
        return this.clientProto.getLinkTarget(path);
    }

    public void allowSnapshot(String snapshotRoot) throws IOException {
        this.clientProto.allowSnapshot(snapshotRoot);
    }

    public void disallowSnapshot(String snapshot) throws IOException {
        this.clientProto.disallowSnapshot(snapshot);
    }

    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        this.clientProto.renameSnapshot(snapshotRoot, snapshotOldName, snapshotNewName);
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        return this.clientProto.getSnapshottableDirListing();
    }

    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName) throws IOException {
        return this.clientProto.getSnapshotDiffReport(snapshotRoot, earlierSnapshotName, laterSnapshotName);
    }

    public SnapshotDiffReportListing getSnapshotDiffReportListing(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName, byte[] startPath, int index) throws IOException {
        return this.clientProto.getSnapshotDiffReportListing(snapshotRoot, earlierSnapshotName, laterSnapshotName, startPath, index);
    }

    public long addCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        return this.clientProto.addCacheDirective(path, flags);
    }

    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        this.clientProto.modifyCacheDirective(directive, flags);
    }

    public void removeCacheDirective(long id) throws IOException {
        this.clientProto.removeCacheDirective(id);
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        return this.clientProto.listCacheDirectives(prevId, filter);
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        this.clientProto.addCachePool(info);
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.clientProto.modifyCachePool(info);
    }

    public void removeCachePool(String cachePoolName) throws IOException {
        this.clientProto.removeCachePool(cachePoolName);
    }

    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        return this.clientProto.listCachePools(prevKey);
    }

    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.clientProto.modifyAclEntries(src, aclSpec);
    }

    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.clientProto.removeAclEntries(src, aclSpec);
    }

    public void removeDefaultAcl(String src) throws IOException {
        this.clientProto.removeDefaultAcl(src);
    }

    public void removeAcl(String src) throws IOException {
        this.clientProto.removeAcl(src);
    }

    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.clientProto.setAcl(src, aclSpec);
    }

    public AclStatus getAclStatus(String src) throws IOException {
        return this.clientProto.getAclStatus(src);
    }

    public void createEncryptionZone(String src, String keyName) throws IOException {
        this.clientProto.createEncryptionZone(src, keyName);
    }

    public EncryptionZone getEZForPath(String src) throws IOException {
        return this.clientProto.getEZForPath(src);
    }

    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        return this.clientProto.listEncryptionZones(prevId);
    }

    public void reencryptEncryptionZone(String zone, HdfsConstants.ReencryptAction action) throws IOException {
        this.clientProto.reencryptEncryptionZone(zone, action);
    }

    public BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> listReencryptionStatus(long prevId) throws IOException {
        return this.clientProto.listReencryptionStatus(prevId);
    }

    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.clientProto.setXAttr(src, xAttr, flag);
    }

    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        return this.clientProto.getXAttrs(src, xAttrs);
    }

    public List<XAttr> listXAttrs(String src) throws IOException {
        return this.clientProto.listXAttrs(src);
    }

    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        this.clientProto.removeXAttr(src, xAttr);
    }

    public void checkAccess(String path, FsAction mode) throws IOException {
        this.clientProto.checkAccess(path, mode);
    }

    public long getCurrentEditLogTxid() throws IOException {
        return this.clientProto.getCurrentEditLogTxid();
    }

    public EventBatchList getEditsFromTxid(long txid) throws IOException {
        return this.clientProto.getEditsFromTxid(txid);
    }

    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        return this.clientProto.getDataEncryptionKey();
    }

    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        return this.clientProto.createSnapshot(snapshotRoot, snapshotName);
    }

    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.clientProto.deleteSnapshot(snapshotRoot, snapshotName);
    }

    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws IOException {
        this.clientProto.setQuota(path, namespaceQuota, storagespaceQuota, type);
    }

    public QuotaUsage getQuotaUsage(String path) throws IOException {
        return this.clientProto.getQuotaUsage(path);
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.clientProto.reportBadBlocks(blocks);
    }

    public void unsetStoragePolicy(String src) throws IOException {
        this.clientProto.unsetStoragePolicy(src);
    }

    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        return this.clientProto.getStoragePolicy(path);
    }

    public ErasureCodingPolicyInfo[] getErasureCodingPolicies() throws IOException {
        return this.clientProto.getErasureCodingPolicies();
    }

    public Map<String, String> getErasureCodingCodecs() throws IOException {
        return this.clientProto.getErasureCodingCodecs();
    }

    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies) throws IOException {
        return this.clientProto.addErasureCodingPolicies(policies);
    }

    public void removeErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.clientProto.removeErasureCodingPolicy(ecPolicyName);
    }

    public void disableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.clientProto.disableErasureCodingPolicy(ecPolicyName);
    }

    public void enableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.clientProto.enableErasureCodingPolicy(ecPolicyName);
    }

    public ErasureCodingPolicy getErasureCodingPolicy(String src) throws IOException {
        return this.clientProto.getErasureCodingPolicy(src);
    }

    public void setErasureCodingPolicy(String src, String ecPolicyName) throws IOException {
        this.clientProto.setErasureCodingPolicy(src, ecPolicyName);
    }

    public void unsetErasureCodingPolicy(String src) throws IOException {
        this.clientProto.unsetErasureCodingPolicy(src);
    }

    public ECTopologyVerifierResult getECTopologyResultForPolicies(String ... policyNames) throws IOException {
        return this.clientProto.getECTopologyResultForPolicies(policyNames);
    }

    public ECBlockGroupStats getECBlockGroupStats() throws IOException {
        return this.clientProto.getECBlockGroupStats();
    }

    public ReplicatedBlockStats getReplicatedBlockStats() throws IOException {
        return this.clientProto.getReplicatedBlockStats();
    }

    @Deprecated
    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId) throws IOException {
        return this.clientProto.listOpenFiles(prevId);
    }

    public HAServiceProtocol.HAServiceState getHAServiceState() throws IOException {
        return this.clientProto.getHAServiceState();
    }

    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId, EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes, String path) throws IOException {
        return this.clientProto.listOpenFiles(prevId, openFilesTypes, path);
    }

    public void msync() throws IOException {
        this.clientProto.msync();
    }

    public void satisfyStoragePolicy(String path) throws IOException {
        this.clientProto.satisfyStoragePolicy(path);
    }

    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size, long minBlockSize) throws IOException {
        return this.nnProto.getBlocks(datanode, size, minBlockSize);
    }

    public ExportedBlockKeys getBlockKeys() throws IOException {
        return this.nnProto.getBlockKeys();
    }

    public long getTransactionID() throws IOException {
        return this.nnProto.getTransactionID();
    }

    public long getMostRecentCheckpointTxId() throws IOException {
        return this.nnProto.getMostRecentCheckpointTxId();
    }

    public CheckpointSignature rollEditLog() throws IOException {
        return this.nnProto.rollEditLog();
    }

    public NamespaceInfo versionRequest() throws IOException {
        return this.nnProto.versionRequest();
    }

    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        this.nnProto.errorReport(registration, errorCode, msg);
    }

    public NamenodeRegistration registerSubordinateNamenode(NamenodeRegistration registration) throws IOException {
        return this.nnProto.registerSubordinateNamenode(registration);
    }

    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        return this.nnProto.startCheckpoint(registration);
    }

    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.nnProto.endCheckpoint(registration, sig);
    }

    public RemoteEditLogManifest getEditLogManifest(long sinceTxId) throws IOException {
        return this.nnProto.getEditLogManifest(sinceTxId);
    }

    public boolean isUpgradeFinalized() throws IOException {
        return this.nnProto.isUpgradeFinalized();
    }

    public boolean isRollingUpgrade() throws IOException {
        return this.nnProto.isRollingUpgrade();
    }

    public Long getNextSPSPath() throws IOException {
        return this.nnProto.getNextSPSPath();
    }

    protected RemoteLocation getLocationForPath(String path, boolean failIfLocked, String blockPoolId) throws IOException {
        List<RemoteLocation> locations = this.getLocationsForPath(path, failIfLocked);
        String nameserviceId = null;
        Set<FederationNamespaceInfo> namespaces = this.namenodeResolver.getNamespaces();
        for (FederationNamespaceInfo namespace : namespaces) {
            if (!namespace.getBlockPoolId().equals(blockPoolId)) continue;
            nameserviceId = namespace.getNameserviceId();
            break;
        }
        if (nameserviceId != null) {
            for (RemoteLocation location : locations) {
                if (!location.getNameserviceId().equals(nameserviceId)) continue;
                return location;
            }
        }
        throw new IOException("Cannot locate a nameservice for block pool " + blockPoolId);
    }

    protected List<RemoteLocation> getLocationsForPath(String path, boolean failIfLocked) throws IOException {
        return this.getLocationsForPath(path, failIfLocked, true);
    }

    protected List<RemoteLocation> getLocationsForPath(String path, boolean failIfLocked, boolean needQuotaVerify) throws IOException {
        try {
            PathLocation location = this.subclusterResolver.getDestinationForPath(path);
            if (location == null) {
                throw new IOException("Cannot find locations for " + path + " in " + this.subclusterResolver.getClass().getSimpleName());
            }
            if (this.opCategory.get() == NameNode.OperationCategory.WRITE) {
                RouterQuotaUsage quotaUsage;
                if (this.isPathReadOnly(path)) {
                    if (this.rpcMonitor != null) {
                        this.rpcMonitor.routerFailureReadOnly();
                    }
                    throw new IOException(path + " is in a read only mount point");
                }
                if (this.router.isQuotaEnabled() && needQuotaVerify && (quotaUsage = this.router.getQuotaManager().getQuotaUsage(path)) != null) {
                    quotaUsage.verifyNamespaceQuota();
                    quotaUsage.verifyStoragespaceQuota();
                }
            }
            Set<String> disabled = this.namenodeResolver.getDisabledNamespaces();
            ArrayList<RemoteLocation> locs = new ArrayList<RemoteLocation>();
            for (RemoteLocation loc : location.getDestinations()) {
                if (disabled.contains(loc.getNameserviceId())) continue;
                locs.add(loc);
            }
            return locs;
        }
        catch (IOException ioe) {
            if (this.rpcMonitor != null) {
                this.rpcMonitor.routerFailureStateStore();
            }
            throw ioe;
        }
    }

    private boolean isPathReadOnly(String path) {
        if (this.subclusterResolver instanceof MountTableResolver) {
            try {
                MountTableResolver mountTable = (MountTableResolver)this.subclusterResolver;
                MountTable entry = mountTable.getMountPoint(path);
                if (entry != null && entry.isReadOnly()) {
                    return true;
                }
            }
            catch (IOException e) {
                LOG.error("Cannot get mount point", (Throwable)e);
            }
        }
        return false;
    }

    static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = RPC.Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    protected static <T> T[] merge(Map<FederationNamespaceInfo, T[]> map, Class<T> clazz) {
        LinkedHashSet<T> ret = new LinkedHashSet<T>();
        for (T[] values : map.values()) {
            for (T val : values) {
                ret.add(val);
            }
        }
        return RouterRpcServer.toArray(ret, clazz);
    }

    private static <T> T[] toArray(Collection<T> set, Class<T> clazz) {
        Object[] combinedData = (Object[])Array.newInstance(clazz, set.size());
        combinedData = set.toArray(combinedData);
        return combinedData;
    }

    public Quota getQuotaModule() {
        return this.quotaCall;
    }

    public FederationRPCMetrics getRPCMetrics() {
        return this.rpcMonitor.getRPCMetrics();
    }
}

