/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.array.ArrayFactory;
import org.ojalgo.array.BasicArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;

final class SegmentedArray<N extends Number>
extends BasicArray<N> {
    private final int myIndexBits;
    private final long myIndexMask;
    private final ArrayFactory<N, ?> mySegmentFactory;
    private final BasicArray<N>[] mySegments;
    private final long mySegmentSize;

    SegmentedArray(BasicArray<N>[] segments, ArrayFactory<N, ?> segmentFactory) {
        this.mySegmentSize = segments[0].count();
        int tmpIndexOfLastSegment = segments.length - 1;
        for (int s = 1; s < tmpIndexOfLastSegment; ++s) {
            if (segments[s].count() == this.mySegmentSize) continue;
            throw new IllegalArgumentException("All segments (except possibly the last) must have the same size!");
        }
        if (segments[tmpIndexOfLastSegment].count() > this.mySegmentSize) {
            throw new IllegalArgumentException("The last segment cannot be larger than the others!");
        }
        this.myIndexBits = Arrays.binarySearch(PrimitiveMath.POWERS_OF_2, this.mySegmentSize);
        if (this.myIndexBits < 0 || this.mySegmentSize != 1L << this.myIndexBits) {
            throw new IllegalArgumentException("The segment size must be a power of 2!");
        }
        this.myIndexMask = this.mySegmentSize - 1L;
        this.mySegments = segments;
        this.mySegmentFactory = segmentFactory;
    }

    SegmentedArray(long count, int indexBits, ArrayFactory<N, ?> segmentFactory) {
        long tmpSegmentSize = 1L << indexBits;
        int tmpNumberOfUniformSegments = (int)(count / tmpSegmentSize);
        long tmpRemainder = count % tmpSegmentSize;
        int tmpTotalNumberOfSegments = tmpRemainder == 0L ? tmpNumberOfUniformSegments : tmpNumberOfUniformSegments + 1;
        this.mySegments = new BasicArray[tmpTotalNumberOfSegments];
        for (int s = 0; s < tmpNumberOfUniformSegments; ++s) {
            this.mySegments[s] = segmentFactory.makeStructuredZero(tmpSegmentSize);
        }
        if (tmpRemainder != 0L) {
            this.mySegments[tmpNumberOfUniformSegments] = segmentFactory.makeStructuredZero(tmpRemainder);
        }
        this.mySegmentSize = tmpSegmentSize;
        this.myIndexBits = indexBits;
        this.myIndexMask = tmpSegmentSize - 1L;
        this.mySegmentFactory = segmentFactory;
    }

    @Override
    public void add(long index, double addend) {
        this.mySegments[(int)(index >> this.myIndexBits)].add(index & this.myIndexMask, addend);
    }

    @Override
    public void add(long index, Number addend) {
        this.mySegments[(int)(index >> this.myIndexBits)].add(index & this.myIndexMask, addend);
    }

    @Override
    public long count() {
        return this.mySegments[0].count() * (long)(this.mySegments.length - 1) + this.mySegments[this.mySegments.length - 1].count();
    }

    @Override
    public double doubleValue(long index) {
        return this.mySegments[(int)(index >> this.myIndexBits)].doubleValue(index & this.myIndexMask);
    }

    @Override
    public void fillAll(N value) {
        for (BasicArray<N> tmpSegment : this.mySegments) {
            tmpSegment.fillAll(value);
        }
    }

    @Override
    public void fillAll(NullaryFunction<N> supplier) {
        for (BasicArray<N> tmpSegment : this.mySegments) {
            tmpSegment.fillAll(supplier);
        }
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        this.mySegments[(int)(index >> this.myIndexBits)].fillOne(index & this.myIndexMask, values, valueIndex);
    }

    @Override
    public void fillOne(long index, N value) {
        this.mySegments[(int)(index >> this.myIndexBits)].fillOne(index & this.myIndexMask, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        this.mySegments[(int)(index >> this.myIndexBits)].fillOne(index & this.myIndexMask, supplier);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        int tmpFirstSegment = (int)(first / this.mySegmentSize);
        int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
        long tmpFirstInSegment = first % this.mySegmentSize;
        for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
            this.mySegments[s].fillRange(tmpFirstInSegment, this.mySegmentSize, value);
            tmpFirstInSegment = 0L;
        }
        this.mySegments[tmpLastSegemnt].fillRange(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        int tmpFirstSegment = (int)(first / this.mySegmentSize);
        int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
        long tmpFirstInSegment = first % this.mySegmentSize;
        for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
            this.mySegments[s].fillRange(tmpFirstInSegment, this.mySegmentSize, supplier);
            tmpFirstInSegment = 0L;
        }
        this.mySegments[tmpLastSegemnt].fillRange(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, supplier);
    }

    @Override
    public N get(long index) {
        return this.mySegments[(int)(index >> this.myIndexBits)].get(index & this.myIndexMask);
    }

    public SegmentedArray<N> grow() {
        BasicArray<N> tmpLastSegment = this.mySegments[this.mySegments.length - 1];
        Structure1D tmpNewSegment = this.mySegmentFactory.makeZero(this.mySegmentSize);
        long tmpLastSegmentSize = tmpLastSegment.count();
        if (tmpLastSegmentSize < this.mySegmentSize) {
            this.mySegments[this.mySegments.length - 1] = tmpNewSegment;
            tmpNewSegment.fillMatching(tmpLastSegment);
            return this;
        }
        if (tmpLastSegmentSize == this.mySegmentSize) {
            BasicArray[] tmpSegments = new BasicArray[this.mySegments.length + 1];
            for (int i = 0; i < this.mySegments.length; ++i) {
                tmpSegments[i] = this.mySegments[i];
            }
            tmpSegments[this.mySegments.length] = tmpNewSegment;
            return new SegmentedArray<N>(tmpSegments, this.mySegmentFactory);
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isAbsolute(long index) {
        return this.mySegments[(int)(index >> this.myIndexBits)].isAbsolute(index & this.myIndexMask);
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        return this.mySegments[(int)(index >> this.myIndexBits)].isSmall(index & this.myIndexMask, comparedTo);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> modifier) {
        BasicArray<N> tmpSegment = this.mySegments[(int)(index >> this.myIndexBits)];
        long tmpIndex = index & this.myIndexMask;
        tmpSegment.set(tmpIndex, (Number)modifier.invoke(tmpSegment.get(tmpIndex)));
    }

    @Override
    public void set(long index, double value) {
        this.mySegments[(int)(index >> this.myIndexBits)].set(index & this.myIndexMask, value);
    }

    @Override
    public void set(long index, Number value) {
        this.mySegments[(int)(index >> this.myIndexBits)].set(index & this.myIndexMask, value);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        if (this.isPrimitive()) {
            visitor.invoke(this.doubleValue(index));
        } else {
            visitor.invoke(this.get(index));
        }
    }

    @Override
    protected void exchange(long firstA, long firstB, long step, long count) {
        if (this.isPrimitive()) {
            long tmpIndexA = firstA;
            long tmpIndexB = firstB;
            for (long i = 0L; i < count; ++i) {
                double tmpVal = this.doubleValue(tmpIndexA);
                this.set(tmpIndexA, this.doubleValue(tmpIndexB));
                this.set(tmpIndexB, tmpVal);
                tmpIndexA += step;
                tmpIndexB += step;
            }
        } else {
            long tmpIndexA = firstA;
            long tmpIndexB = firstB;
            for (long i = 0L; i < count; ++i) {
                N tmpVal = this.get(tmpIndexA);
                this.set(tmpIndexA, (Number)this.get(tmpIndexB));
                this.set(tmpIndexB, (Number)tmpVal);
                tmpIndexA += step;
                tmpIndexB += step;
            }
        }
    }

    @Override
    protected void fill(long first, long limit, long step, N value) {
        if (step <= this.mySegmentSize) {
            int tmpFirstSegment = (int)(first / this.mySegmentSize);
            int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
            long tmpFirstInSegment = first % this.mySegmentSize;
            for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
                this.mySegments[s].fill(tmpFirstInSegment, this.mySegmentSize, step, value);
                long tmpRemainder = (this.mySegmentSize - tmpFirstInSegment) % step;
                tmpFirstInSegment = tmpRemainder == 0L ? 0L : step - tmpRemainder;
            }
            this.mySegments[tmpLastSegemnt].fill(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, step, value);
        } else if (this.isPrimitive()) {
            double tmpValue = ((Number)value).doubleValue();
            for (long i = first; i < limit; i += step) {
                this.set(i, tmpValue);
            }
        } else {
            for (long i = first; i < limit; i += step) {
                this.set(i, (Number)value);
            }
        }
    }

    @Override
    protected void fill(long first, long limit, long step, NullaryFunction<N> supplier) {
        if (step <= this.mySegmentSize) {
            int tmpFirstSegment = (int)(first / this.mySegmentSize);
            int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
            long tmpFirstInSegment = first % this.mySegmentSize;
            for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
                this.mySegments[s].fill(tmpFirstInSegment, this.mySegmentSize, step, supplier);
                long tmpRemainder = (this.mySegmentSize - tmpFirstInSegment) % step;
                tmpFirstInSegment = tmpRemainder == 0L ? 0L : step - tmpRemainder;
            }
            this.mySegments[tmpLastSegemnt].fill(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, step, supplier);
        } else if (this.isPrimitive()) {
            for (long i = first; i < limit; i += step) {
                this.set(i, supplier.doubleValue());
            }
        } else {
            for (long i = first; i < limit; i += step) {
                this.set(i, (Number)supplier.invoke());
            }
        }
    }

    @Override
    protected boolean isSmall(long first, long limit, long step, double comparedTo) {
        boolean retVal = true;
        for (long i = first; retVal && i < limit; retVal &= this.isSmall(i, comparedTo), i += step) {
        }
        return retVal;
    }

    @Override
    protected void modify(long first, long limit, long step, Access1D<N> left, BinaryFunction<N> function) {
        if (this.isPrimitive()) {
            for (long l = first; l < limit; l += step) {
                this.set(l, function.invoke(left.doubleValue(l), this.doubleValue(l)));
            }
        } else {
            for (long l = first; l < limit; l += step) {
                this.set(l, (Number)function.invoke(left.get(l), this.get(l)));
            }
        }
    }

    @Override
    protected void modify(long first, long limit, long step, BinaryFunction<N> function, Access1D<N> right) {
        if (this.isPrimitive()) {
            for (long l = first; l < limit; l += step) {
                this.set(l, function.invoke(this.doubleValue(l), right.doubleValue(l)));
            }
        } else {
            for (long l = first; l < limit; l += step) {
                this.set(l, (Number)function.invoke(this.get(l), right.get(l)));
            }
        }
    }

    @Override
    protected void modify(long first, long limit, long step, UnaryFunction<N> function) {
        if (step <= this.mySegmentSize) {
            int tmpFirstSegment = (int)(first / this.mySegmentSize);
            int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
            long tmpFirstInSegment = first % this.mySegmentSize;
            for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
                this.mySegments[s].modify(tmpFirstInSegment, this.mySegmentSize, step, function);
                long tmpRemainder = (this.mySegmentSize - tmpFirstInSegment) % step;
                tmpFirstInSegment = tmpRemainder == 0L ? 0L : step - tmpRemainder;
            }
            this.mySegments[tmpLastSegemnt].modify(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, step, function);
        } else if (this.isPrimitive()) {
            for (long i = first; i < limit; i += step) {
                this.set(i, function.invoke(this.doubleValue(i)));
            }
        } else {
            for (long i = first; i < limit; i += step) {
                this.set(i, (Number)function.invoke(this.get(i)));
            }
        }
    }

    @Override
    protected void visit(long first, long limit, long step, VoidFunction<N> visitor) {
        if (step <= this.mySegmentSize) {
            int tmpFirstSegment = (int)(first / this.mySegmentSize);
            int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
            long tmpFirstInSegment = first % this.mySegmentSize;
            for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
                this.mySegments[s].visit(tmpFirstInSegment, this.mySegmentSize, step, visitor);
                long tmpRemainder = (this.mySegmentSize - tmpFirstInSegment) % step;
                tmpFirstInSegment = tmpRemainder == 0L ? 0L : step - tmpRemainder;
            }
            this.mySegments[tmpLastSegemnt].visit(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, step, visitor);
        } else if (this.isPrimitive()) {
            for (long i = first; i < limit; i += step) {
                visitor.invoke(this.doubleValue(i));
            }
        } else {
            for (long i = first; i < limit; i += step) {
                visitor.invoke(this.get(i));
            }
        }
    }

    @Override
    boolean isPrimitive() {
        return this.mySegments[0].isPrimitive();
    }

    @Override
    void reset() {
        for (BasicArray<N> tmpSegment : this.mySegments) {
            tmpSegment.reset();
        }
    }
}

