/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.reactive;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.springframework.boot.http.client.HttpComponentsHttpAsyncClientBuilder;
import org.springframework.boot.http.client.reactive.AbstractClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.http.client.reactive.HttpComponentsClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class HttpComponentsClientHttpConnectorBuilder
extends AbstractClientHttpConnectorBuilder<HttpComponentsClientHttpConnector> {
    private final HttpComponentsHttpAsyncClientBuilder httpClientBuilder;

    HttpComponentsClientHttpConnectorBuilder() {
        this(null, new HttpComponentsHttpAsyncClientBuilder());
    }

    private HttpComponentsClientHttpConnectorBuilder(List<Consumer<HttpComponentsClientHttpConnector>> customizers, HttpComponentsHttpAsyncClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public HttpComponentsClientHttpConnectorBuilder withHttpClientCustomizer(Consumer<HttpAsyncClientBuilder> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, "'customizer' must not be null");
        return new HttpComponentsClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withCustomizer(httpClientCustomizer));
    }

    public HttpComponentsClientHttpConnectorBuilder withConnectionManagerCustomizer(Consumer<PoolingAsyncClientConnectionManagerBuilder> connectionManagerCustomizer) {
        Assert.notNull(connectionManagerCustomizer, "'connectionManagerCustomizer' must not be null");
        return new HttpComponentsClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withConnectionManagerCustomizer(connectionManagerCustomizer));
    }

    public HttpComponentsClientHttpConnectorBuilder withConnectionConfigCustomizer(Consumer<ConnectionConfig.Builder> connectionConfigCustomizer) {
        Assert.notNull(connectionConfigCustomizer, "'connectionConfigCustomizer' must not be null");
        return new HttpComponentsClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withConnectionConfigCustomizer(connectionConfigCustomizer));
    }

    public HttpComponentsClientHttpConnectorBuilder withTlsSocketStrategyFactory(Function<SslBundle, TlsStrategy> tlsStrategyFactory) {
        Assert.notNull(tlsStrategyFactory, "'tlsStrategyFactory' must not be null");
        return new HttpComponentsClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withTlsStrategyFactory(tlsStrategyFactory));
    }

    public HttpComponentsClientHttpConnectorBuilder withDefaultRequestConfigCustomizer(Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer) {
        Assert.notNull(defaultRequestConfigCustomizer, "'defaultRequestConfigCustomizer' must not be null");
        return new HttpComponentsClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withDefaultRequestConfigCustomizer(defaultRequestConfigCustomizer));
    }

    @Override
    protected HttpComponentsClientHttpConnector createClientHttpConnector(ClientHttpConnectorSettings settings) {
        CloseableHttpAsyncClient client = this.httpClientBuilder.build(this.asHttpClientSettings(settings));
        return new HttpComponentsClientHttpConnector(client);
    }

    static class Classes {
        static final String HTTP_CLIENTS = "org.apache.hc.client5.http.impl.async.HttpAsyncClients";
        static final String REACTIVE_RESPONSE_CONSUMER = "org.apache.hc.core5.reactive.ReactiveResponseConsumer";

        Classes() {
        }

        static boolean present(ClassLoader classLoader) {
            return ClassUtils.isPresent(HTTP_CLIENTS, classLoader) && ClassUtils.isPresent(REACTIVE_RESPONSE_CONSUMER, classLoader);
        }
    }
}

