/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.util.Assert;

abstract class AbstractClientHttpConnectorBuilder<T extends ClientHttpConnector>
implements ClientHttpConnectorBuilder<T> {
    private final List<Consumer<T>> customizers;

    protected AbstractClientHttpConnectorBuilder(List<Consumer<T>> customizers) {
        this.customizers = customizers != null ? customizers : Collections.emptyList();
    }

    protected final List<Consumer<T>> getCustomizers() {
        return this.customizers;
    }

    protected final List<Consumer<T>> mergedCustomizers(Consumer<T> customizer2) {
        Assert.notNull(this.customizers, "'customizer' must not be null");
        return this.merge(this.customizers, List.of(customizer2));
    }

    protected final List<Consumer<T>> mergedCustomizers(Collection<Consumer<T>> customizers) {
        Assert.notNull(customizers, "'customizers' must not be null");
        Assert.noNullElements(customizers, "'customizers' must not contain null elements");
        return this.merge(this.customizers, customizers);
    }

    private <E> List<E> merge(Collection<E> list, Collection<? extends E> additional) {
        ArrayList<? extends E> merged = new ArrayList<E>(list);
        merged.addAll(additional);
        return List.copyOf(merged);
    }

    @Override
    public final T build(ClientHttpConnectorSettings settings) {
        Object connector = this.createClientHttpConnector(settings != null ? settings : ClientHttpConnectorSettings.defaults());
        LambdaSafe.callbacks(Consumer.class, this.customizers, connector, new Object[0]).invoke(consumer -> consumer.accept(connector));
        return connector;
    }

    protected abstract T createClientHttpConnector(ClientHttpConnectorSettings var1);

    protected final HttpClientSettings asHttpClientSettings(ClientHttpConnectorSettings settings) {
        return settings != null ? new HttpClientSettings(settings.redirects(), settings.connectTimeout(), settings.readTimeout(), settings.sslBundle()) : null;
    }
}

