/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.json;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.grails.web.json.JSONElement;
import org.grails.web.json.JSONException;
import org.grails.web.json.JSONObject;
import org.grails.web.json.JSONTokener;

public class JSONArray
implements JSONElement,
List {
    private ArrayList myArrayList;

    public JSONArray() {
        this.myArrayList = new ArrayList();
    }

    public JSONArray(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.myArrayList.add(null);
            } else {
                x.back();
                this.myArrayList.add(x.nextValue());
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    public JSONArray(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONArray(Collection collection) {
        this.myArrayList = new ArrayList(collection);
    }

    public Object get(int index2) {
        Object o = this.opt(index2);
        if (o == null) {
            throw new RuntimeException(new JSONException("JSONArray[" + index2 + "] not found."));
        }
        return o;
    }

    public Object set(int i2, Object o) {
        return this.myArrayList.set(i2, o);
    }

    @Override
    public boolean add(Object o) {
        return this.myArrayList.add(o);
    }

    public void add(int i2, Object o) {
        this.myArrayList.add(i2, o);
    }

    public Object remove(int i2) {
        return this.myArrayList.remove(i2);
    }

    @Override
    public boolean remove(Object o) {
        return this.myArrayList.remove(o);
    }

    @Override
    public void clear() {
        this.myArrayList.clear();
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.myArrayList.addAll(collection);
    }

    public boolean addAll(int i2, Collection collection) {
        return this.myArrayList.addAll(i2, collection);
    }

    @Override
    public Iterator iterator() {
        return this.myArrayList.iterator();
    }

    public ListIterator listIterator() {
        return this.myArrayList.listIterator();
    }

    public ListIterator listIterator(int i2) {
        return this.myArrayList.listIterator(i2);
    }

    public List subList(int i2, int i1) {
        return this.myArrayList.subList(i2, i1);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.myArrayList.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.myArrayList.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.myArrayList.retainAll(collection);
    }

    public boolean getBoolean(int index2) throws JSONException {
        Object o = this.get(index2);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a Boolean.");
    }

    public double getDouble(int index2) throws JSONException {
        Object o = this.get(index2);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            throw new JSONException("JSONArray[" + index2 + "] is not a number.");
        }
    }

    public int getInt(int index2) throws JSONException {
        Object o = this.get(index2);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index2);
    }

    public JSONArray getJSONArray(int index2) throws JSONException {
        Object o = this.get(index2);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index2) throws JSONException {
        Object o = this.get(index2);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a JSONObject.");
    }

    public long getLong(int index2) throws JSONException {
        Object o = this.get(index2);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(index2);
    }

    public String getString(int index2) throws JSONException {
        return this.get(index2).toString();
    }

    public boolean isNull(int index2) {
        return this.opt(index2) == null;
    }

    public String join(String separator) throws JSONException {
        int len = this.length();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                sb.append(separator);
            }
            sb.append(JSONObject.valueToString(this.myArrayList.get(i2)));
        }
        return sb.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index2) {
        return index2 < 0 || index2 >= this.length() ? null : this.myArrayList.get(index2);
    }

    public boolean optBoolean(int index2) {
        return this.optBoolean(index2, false);
    }

    public boolean optBoolean(int index2, boolean defaultValue) {
        try {
            return this.getBoolean(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(int index2) {
        return this.optDouble(index2, Double.NaN);
    }

    public double optDouble(int index2, double defaultValue) {
        try {
            return this.getDouble(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(int index2) {
        return this.optInt(index2, 0);
    }

    public int optInt(int index2, int defaultValue) {
        try {
            return this.getInt(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(int index2) {
        Object o = this.opt(index2);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(int index2) {
        Object o = this.opt(index2);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(int index2) {
        return this.optLong(index2, 0L);
    }

    public long optLong(int index2, long defaultValue) {
        try {
            return this.getLong(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(int index2) {
        return this.optString(index2, "");
    }

    public String optString(int index2, String defaultValue) {
        Object o = this.opt(index2);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONArray put(boolean value) {
        this.put(value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(double value) throws JSONException {
        Double d = value;
        JSONObject.testValidity(d);
        this.put(d);
        return this;
    }

    public JSONArray put(int value) {
        this.put((Object)value);
        return this;
    }

    public JSONArray put(long value) {
        this.put((Object)value);
        return this;
    }

    public JSONArray put(Object value) {
        this.myArrayList.add(value);
        return this;
    }

    public JSONArray put(int index2, boolean value) throws JSONException {
        this.put(index2, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(int index2, double value) throws JSONException {
        this.put(index2, (Object)value);
        return this;
    }

    public JSONArray put(int index2, int value) throws JSONException {
        this.put(index2, (Object)value);
        return this;
    }

    public JSONArray put(int index2, long value) throws JSONException {
        this.put(index2, (Object)value);
        return this;
    }

    public JSONArray put(int index2, Object value) throws JSONException {
        JSONObject.testValidity(value);
        if (index2 < 0) {
            throw new JSONException("JSONArray[" + index2 + "] not found.");
        }
        if (index2 < this.length()) {
            this.myArrayList.set(index2, value);
        } else {
            while (index2 != this.length()) {
                this.put(null);
            }
            this.put(value);
        }
        return this;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i2 = 0; i2 < names.length(); ++i2) {
            jo.put(names.getString(i2), this.opt(i2));
        }
        return jo;
    }

    public String toString() {
        try {
            return "[" + this.join(",") + "]";
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws JSONException {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        if (len == 1) {
            sb.append(JSONObject.valueToString(this.myArrayList.get(0), indentFactor, indent));
        } else {
            int i2;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i2 = 0; i2 < len; ++i2) {
                if (i2 > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JSONObject.valueToString(this.myArrayList.get(i2), indentFactor, newindent));
            }
            sb.append('\n');
            for (i2 = 0; i2 < indent; ++i2) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JSONArray that = (JSONArray)obj;
        return !(this.myArrayList != null ? !this.myArrayList.equals(that.myArrayList) : that.myArrayList != null);
    }

    @Override
    public int hashCode() {
        return this.myArrayList != null ? this.myArrayList.hashCode() : super.hashCode();
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            boolean b = false;
            int len = this.length();
            writer.write(91);
            for (int i2 = 0; i2 < len; ++i2) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = this.myArrayList.get(i2)) instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public void trimToSize() {
        this.myArrayList.trimToSize();
    }

    public void ensureCapacity(int i2) {
        this.myArrayList.ensureCapacity(i2);
    }

    @Override
    public int size() {
        return this.myArrayList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myArrayList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myArrayList.contains(o);
    }

    @Override
    public int indexOf(Object o) {
        return this.myArrayList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myArrayList.lastIndexOf(o);
    }

    public Object clone() {
        return this.myArrayList.clone();
    }

    @Override
    public Object[] toArray() {
        return this.myArrayList.toArray();
    }

    @Override
    public Object[] toArray(Object[] objects) {
        return this.myArrayList.toArray(objects);
    }

    @Override
    public Writer writeTo(Writer out) throws IOException {
        return this.write(out);
    }
}

