/*
 * Decompiled with CFR 0.152.
 */
package org.grails.charsequences;

import org.grails.charsequences.CharArrayAccessible;

class CharArrayCharSequence
implements CharSequence,
CharArrayAccessible {
    private final char[] chars;
    private final int count;
    private final int start;

    CharArrayCharSequence(char[] chars, int start, int count) {
        if (start + count > chars.length) {
            throw new StringIndexOutOfBoundsException(start);
        }
        this.chars = chars;
        this.start = start;
        this.count = count;
    }

    @Override
    public char charAt(int index2) {
        if (index2 < 0 || index2 + this.start >= this.chars.length) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        return this.chars[index2 + this.start];
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        if (start == 0 && end == this.count) {
            return this;
        }
        return new CharArrayCharSequence(this.chars, this.start + start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.chars, this.start, this.count);
    }

    @Override
    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.start + this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.chars, this.start + srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }
}

