/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.AbstractIdleService;
import com.typesafe.config.Config;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.event.DeleteJobConfigArrivalEvent;
import org.apache.gobblin.cluster.event.NewJobConfigArrivalEvent;
import org.apache.gobblin.cluster.event.UpdateJobConfigArrivalEvent;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.SchedulerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class JobConfigurationManager
extends AbstractIdleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobConfigurationManager.class);
    protected final EventBus eventBus;
    protected final Config config;
    protected Optional<String> jobConfDirPath;

    public JobConfigurationManager(EventBus eventBus, Config config) {
        this.eventBus = eventBus;
        this.config = config;
        this.jobConfDirPath = config.hasPath("gobblin.cluster.job.conf.path") ? Optional.of((Object)config.getString("gobblin.cluster.job.conf.path")) : Optional.absent();
    }

    protected void startUp() throws Exception {
        if (this.jobConfDirPath.isPresent()) {
            File path;
            File jobConfigDir = path = new File((String)this.jobConfDirPath.get());
            if (!path.exists()) {
                String pwd = System.getProperty("user.dir");
                jobConfigDir = new File(pwd, path.getName() + ".tar.gz");
            }
            if (jobConfigDir.exists()) {
                LOGGER.info("Loading job configurations from " + jobConfigDir);
                Properties properties = ConfigUtils.configToProperties((Config)this.config);
                properties.setProperty("jobconf.fullyQualifiedPath", "file://" + jobConfigDir.getAbsolutePath());
                List jobConfigs = SchedulerUtils.loadGenericJobConfigs((Properties)properties);
                LOGGER.info("Loaded " + jobConfigs.size() + " job configuration(s)");
                for (Properties config : jobConfigs) {
                    this.postNewJobConfigArrival(config.getProperty("job.name"), config);
                }
            } else {
                LOGGER.warn("Job configuration directory " + jobConfigDir + " not found");
            }
        }
    }

    protected void shutDown() throws Exception {
    }

    protected void postNewJobConfigArrival(String jobName, Properties jobConfig) {
        LOGGER.info(String.format("Posting new JobConfig with name: %s and config: %s", jobName, jobConfig));
        this.eventBus.post((Object)new NewJobConfigArrivalEvent(jobName, jobConfig));
    }

    protected void postUpdateJobConfigArrival(String jobName, Properties jobConfig) {
        LOGGER.info(String.format("Posting update JobConfig with name: %s and config: %s", jobName, jobConfig));
        this.eventBus.post((Object)new UpdateJobConfigArrivalEvent(jobName, jobConfig));
    }

    protected void postDeleteJobConfigArrival(String jobName, @Nullable Properties jobConfig) {
        LOGGER.info(String.format("Posting delete JobConfig with name: %s and config: %s", jobName, jobConfig));
        this.eventBus.post((Object)new DeleteJobConfigArrivalEvent(jobName, jobConfig));
    }
}

