/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.typesafe.config.Config;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.gobblin.annotation.Alpha;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinClusterUtils {
    private static final Logger log = LoggerFactory.getLogger(GobblinClusterUtils.class);

    public static String getHostname() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public static Path getAppWorkDirPath(FileSystem fs, String applicationName, String applicationId) {
        return new Path(fs.getHomeDirectory(), GobblinClusterUtils.getAppWorkDirPath(applicationName, applicationId));
    }

    public static Path getAppWorkDirPathFromConfig(Config config, FileSystem fs, String applicationName, String applicationId) {
        if (config.hasPath("gobblin.cluster.workDir")) {
            return new Path(config.getString("gobblin.cluster.workDir"));
        }
        return new Path(fs.getHomeDirectory(), GobblinClusterUtils.getAppWorkDirPath(applicationName, applicationId));
    }

    public static String getAppWorkDirPath(String applicationName, String applicationId) {
        return applicationName + "/" + applicationId;
    }

    public static Path getJobStateFilePath(boolean usingStateStore, Path appWorkPath, String jobId) {
        Path jobStateFilePath = usingStateStore ? new Path(appWorkPath, "_jobstates/" + jobId + "/" + jobId + "." + "job.state") : new Path(appWorkPath, jobId + "." + "job.state");
        log.info("job state file path: " + jobStateFilePath);
        return jobStateFilePath;
    }
}

