/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.grammar;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.Null;
import com.linkedin.data.codec.DataLocation;
import com.linkedin.data.grammar.PdlLexer;
import com.linkedin.data.grammar.PdlParser;
import com.linkedin.data.schema.AbstractSchemaParser;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaToJsonEncoder;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class PdlSchemaParser
extends AbstractSchemaParser {
    public static final String FILETYPE = "pdl";
    public static final String FILE_EXTENSION = ".pdl";
    private static final String NEWLINE = System.lineSeparator();
    private Map<String, Name> currentImports;
    private StringBuilder _errorMessageBuilder = new StringBuilder();

    public PdlSchemaParser(DataSchemaResolver resolver) {
        super(resolver);
    }

    @Override
    public void parse(String source) {
        this.parse(new StringReader(source));
    }

    @Override
    public void parse(InputStream inputStream) {
        this.parse(new InputStreamReader(inputStream));
    }

    @Override
    public void parse(Reader reader) {
        try {
            PdlLexer lexer;
            ErrorRecorder errorRecorder = new ErrorRecorder();
            try {
                lexer = new PdlLexer((CharStream)new ANTLRInputStream(reader));
            }
            catch (IOException e) {
                ParseError error = new ParseError(new ParseErrorLocation(0, 0), e.getMessage());
                this.startErrorMessage(error).append(error.message).append(NEWLINE);
                return;
            }
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)errorRecorder);
            PdlParser parser = new PdlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)errorRecorder);
            PdlParser.DocumentContext antlrDocument = parser.document();
            this.parse(antlrDocument);
            if (errorRecorder.errors.size() > 0) {
                for (ParseError error : errorRecorder.errors) {
                    this.startErrorMessage(error).append(error.message).append(NEWLINE);
                }
            }
        }
        catch (ParseException e) {
            this.startErrorMessage(e.error).append(e.getMessage()).append(NEWLINE);
        }
        catch (Throwable t) {
            ParseError parseError = new ParseError(new ParseErrorLocation(0, 0), null);
            this.startErrorMessage(parseError).append("Unexpected parser error: ").append(ExceptionUtils.getStackTrace((Throwable)t)).append(NEWLINE);
        }
    }

    private StringBuilder startErrorMessage(ParseError error) {
        return this.errorMessageBuilder().append(error.location).append(": ");
    }

    private StringBuilder startErrorMessage(ParserRuleContext context) {
        return this.errorMessageBuilder().append(new ParseErrorLocation(context)).append(": ");
    }

    private DataSchema parse(PdlParser.DocumentContext document) throws ParseException {
        DataSchema schema;
        PdlParser.NamespaceDeclarationContext namespaceDecl = document.namespaceDeclaration();
        if (namespaceDecl != null) {
            this.setCurrentNamespace(namespaceDecl.typeName().value);
        } else {
            this.setCurrentNamespace("");
        }
        if (document.packageDeclaration() != null) {
            this.setCurrentPackage(document.packageDeclaration().typeName().value);
        } else {
            this.setCurrentPackage(null);
        }
        this.setCurrentImports(document.importDeclarations());
        PdlParser.TypeDeclarationContext typeDeclaration = document.typeDeclaration();
        if (typeDeclaration.namedTypeDeclaration() != null) {
            NamedDataSchema namedSchema = this.parseNamedType(typeDeclaration.namedTypeDeclaration());
            if (!namedSchema.getNamespace().equals(this.getCurrentNamespace())) {
                throw new ParseException(typeDeclaration, "Top level type declaration may not be qualified with a namespace different than the file namespace: " + typeDeclaration.getText());
            }
            schema = namedSchema;
        } else if (typeDeclaration.anonymousTypeDeclaration() != null) {
            schema = this.parseAnonymousType(typeDeclaration.anonymousTypeDeclaration());
        } else {
            throw new ParseException(typeDeclaration, "Unrecognized type declaration: " + typeDeclaration.getText());
        }
        this.addTopLevelSchema(schema);
        return schema;
    }

    private DataSchema parseType(PdlParser.TypeDeclarationContext type) throws ParseException {
        if (type.scopedNamedTypeDeclaration() != null) {
            return this.parseScopedNamedType(type.scopedNamedTypeDeclaration());
        }
        if (type.namedTypeDeclaration() != null) {
            return this.parseNamedType(type.namedTypeDeclaration());
        }
        if (type.anonymousTypeDeclaration() != null) {
            return this.parseAnonymousType(type.anonymousTypeDeclaration());
        }
        throw new ParseException(type, "Unrecognized type declaration parse node: " + type.getText());
    }

    private DataSchema parseScopedNamedType(PdlParser.ScopedNamedTypeDeclarationContext type) throws ParseException {
        PdlParser.PackageDeclarationContext scopePackage;
        String surroundingNamespace = this.getCurrentNamespace();
        String surroundingPackage = this.getCurrentPackage();
        PdlParser.NamespaceDeclarationContext scopeNamespace = type.namespaceDeclaration();
        if (scopeNamespace != null) {
            this.setCurrentNamespace(scopeNamespace.typeName().value);
        }
        if ((scopePackage = type.packageDeclaration()) != null) {
            this.setCurrentPackage(scopePackage.typeName().value);
        }
        NamedDataSchema parsedType = this.parseNamedType(type.namedTypeDeclaration());
        this.setCurrentNamespace(surroundingNamespace);
        this.setCurrentPackage(surroundingPackage);
        return parsedType;
    }

    private DataSchema parseAnonymousType(PdlParser.AnonymousTypeDeclarationContext anon) throws ParseException {
        if (anon.unionDeclaration() != null) {
            return this.parseUnion(anon.unionDeclaration(), false);
        }
        if (anon.mapDeclaration() != null) {
            return this.parseMap(anon.mapDeclaration());
        }
        if (anon.arrayDeclaration() != null) {
            return this.parseArray(anon.arrayDeclaration());
        }
        throw new ParseException(anon, "Unrecognized type parse node: " + anon.getText());
    }

    private NamedDataSchema parseNamedType(PdlParser.NamedTypeDeclarationContext namedType) throws ParseException {
        NamedDataSchema schema;
        if (namedType.recordDeclaration() != null) {
            schema = this.parseRecord(namedType, namedType.recordDeclaration());
        } else if (namedType.typerefDeclaration() != null) {
            schema = this.parseTyperef(namedType, namedType.typerefDeclaration());
        } else if (namedType.fixedDeclaration() != null) {
            schema = this.parseFixed(namedType, namedType.fixedDeclaration());
        } else if (namedType.enumDeclaration() != null) {
            schema = this.parseEnum(namedType, namedType.enumDeclaration());
        } else {
            throw new ParseException(namedType, "Unrecognized named type parse node: " + namedType.getText());
        }
        schema.setPackage(this.getCurrentPackage());
        return schema;
    }

    private FixedDataSchema parseFixed(PdlParser.NamedTypeDeclarationContext context, PdlParser.FixedDeclarationContext fixed) throws ParseException {
        Name name = this.toName(fixed.name);
        FixedDataSchema schema = new FixedDataSchema(name);
        this.bindNameToSchema(name, schema);
        schema.setSize(fixed.size, this.errorMessageBuilder());
        this.setProperties(context, schema);
        return schema;
    }

    private EnumDataSchema parseEnum(PdlParser.NamedTypeDeclarationContext context, PdlParser.EnumDeclarationContext enumDecl) throws ParseException {
        Name name = this.toName(enumDecl.name);
        EnumDataSchema schema = new EnumDataSchema(name);
        this.bindNameToSchema(name, schema);
        List<PdlParser.EnumSymbolDeclarationContext> symbolDecls = enumDecl.enumDecl.symbolDecls;
        ArrayList<String> symbols = new ArrayList<String>(symbolDecls.size());
        Map<String, Object> props = this.setProperties(context, schema);
        HashMap<String, Object> symbolDocs = new HashMap<String, Object>();
        DataMap deprecatedSymbols = new DataMap();
        DataMap symbolProperties = new DataMap();
        for (PdlParser.EnumSymbolDeclarationContext symbolDecl : symbolDecls) {
            symbols.add(symbolDecl.symbol.value);
            if (symbolDecl.doc != null) {
                symbolDocs.put(symbolDecl.symbol.value, symbolDecl.doc.value);
            }
            for (PdlParser.PropDeclarationContext prop : symbolDecl.props) {
                String symbol = symbolDecl.symbol.value;
                Object value = this.parsePropValue(prop);
                if (prop.name.equals("deprecated")) {
                    deprecatedSymbols.put(symbol, value);
                    continue;
                }
                ArrayList<String> path = new ArrayList<String>(prop.path);
                path.add(0, symbol);
                this.addPropertiesAtPath(prop, symbolProperties, path, value);
            }
        }
        schema.setSymbols(symbols, this.errorMessageBuilder());
        if (symbolDocs.size() > 0) {
            schema.setSymbolDocs(symbolDocs, this.errorMessageBuilder());
        }
        if (deprecatedSymbols.size() > 0) {
            props.put("deprecatedSymbols", deprecatedSymbols);
        }
        if (symbolProperties.size() > 0) {
            props.put("symbolProperties", symbolProperties);
        }
        schema.setProperties(props);
        return schema;
    }

    private TyperefDataSchema parseTyperef(PdlParser.NamedTypeDeclarationContext context, PdlParser.TyperefDeclarationContext typeref) throws ParseException {
        Name name = this.toName(typeref.name);
        TyperefDataSchema schema = new TyperefDataSchema(name);
        this.bindNameToSchema(name, schema);
        DataSchema refSchema = this.toDataSchema(typeref.ref);
        schema.setReferencedType(refSchema);
        schema.setRefDeclaredInline(this.isDeclaredInline(typeref.ref));
        this.setProperties(context, schema);
        return schema;
    }

    private ArrayDataSchema parseArray(PdlParser.ArrayDeclarationContext array) throws ParseException {
        ArrayDataSchema schema = new ArrayDataSchema(this.toDataSchema(array.typeParams.items));
        schema.setItemsDeclaredInline(this.isDeclaredInline(array.typeParams.items));
        return schema;
    }

    private MapDataSchema parseMap(PdlParser.MapDeclarationContext map) throws ParseException {
        PdlParser.TypeAssignmentContext keyType = map.typeParams.key;
        PdlParser.TypeAssignmentContext valueType = map.typeParams.value;
        MapDataSchema schema = new MapDataSchema(this.toDataSchema(valueType));
        HashMap<String, Object> propsToAdd = new HashMap<String, Object>();
        if (keyType.typeReference() != null) {
            String typeName = keyType.typeReference().value;
            if (!typeName.equals("string")) {
                this.startErrorMessage(map).append("Unsupported map key type: ").append(typeName).append(". 'string' is the only currently supported map key type.\n");
            }
        } else if (keyType.typeDeclaration() != null) {
            DataSchema keySchema = this.parseType(keyType.typeDeclaration());
            String json = SchemaToJsonEncoder.schemaToJson(keySchema, JsonBuilder.Pretty.COMPACT);
            this.startErrorMessage(map).append("Unsupported map key type declaration: ").append(json).append(". 'string' is the only currently supported map key type.\n");
        }
        schema.setProperties(propsToAdd);
        schema.setValuesDeclaredInline(this.isDeclaredInline(valueType));
        return schema;
    }

    private UnionDataSchema parseUnion(PdlParser.UnionDeclarationContext union, boolean withinTypref) throws ParseException {
        UnionDataSchema schema = new UnionDataSchema();
        List<PdlParser.UnionMemberDeclarationContext> members = union.typeParams.members;
        ArrayList<DataSchema> types = new ArrayList<DataSchema>(members.size());
        HashSet<DataSchema> typesDeclaredInline = new HashSet<DataSchema>();
        for (PdlParser.UnionMemberDeclarationContext memberDecl : members) {
            PdlParser.TypeAssignmentContext memberType = memberDecl.member;
            DataSchema dataSchema = this.toDataSchema(memberType);
            if (dataSchema == null) continue;
            types.add(dataSchema);
            if (!this.isDeclaredInline(memberDecl.member)) continue;
            typesDeclaredInline.add(dataSchema);
        }
        schema.setTypes(types, this.errorMessageBuilder());
        schema.setTypesDeclaredInline(typesDeclaredInline);
        return schema;
    }

    private RecordDataSchema parseRecord(PdlParser.NamedTypeDeclarationContext context, PdlParser.RecordDeclarationContext record) throws ParseException {
        Name name = this.toName(record.name);
        RecordDataSchema schema = new RecordDataSchema(name, RecordDataSchema.RecordType.RECORD);
        this.bindNameToSchema(name, schema);
        FieldsAndIncludes fieldsAndIncludes = this.parseIncludes(record.fieldIncludes());
        fieldsAndIncludes.fields.addAll(this.parseFields(schema, record.recordDecl));
        schema.setFields(fieldsAndIncludes.fields, this.errorMessageBuilder());
        schema.setInclude(fieldsAndIncludes.includes);
        schema.setIncludesDeclaredInline(fieldsAndIncludes.includesDeclaredInline);
        this.validateDefaults(schema);
        this.setProperties(context, schema);
        return schema;
    }

    private Map<String, Object> setProperties(PdlParser.NamedTypeDeclarationContext source, NamedDataSchema target) throws ParseException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(target.getProperties());
        if (source.doc != null) {
            target.setDoc(source.doc.value);
        }
        for (PdlParser.PropDeclarationContext prop : source.props) {
            this.addPropertiesAtPath(properties, prop);
        }
        target.setProperties(properties);
        return properties;
    }

    private void addPropertiesAtPath(Map<String, Object> existingProperties, PdlParser.PropDeclarationContext prop) throws ParseException {
        this.addPropertiesAtPath(prop, existingProperties, prop.path, this.parsePropValue(prop));
    }

    private void addPropertiesAtPath(ParserRuleContext context, Map<String, Object> existingProperties, Iterable<String> path, Object value) throws ParseException {
        DataMap current = existingProperties;
        Iterator<String> iter = path.iterator();
        while (iter.hasNext()) {
            String pathPart = iter.next();
            if (iter.hasNext()) {
                if (existingProperties.containsKey(pathPart)) {
                    Object val = existingProperties.get(pathPart);
                    if (!(val instanceof DataMap)) {
                        throw new ParseException(new ParseError(new ParseErrorLocation(context), "Conflicting property: " + path.toString()));
                    }
                    current = (DataMap)val;
                    continue;
                }
                DataMap next = new DataMap();
                current.put((String)pathPart, (Object)next);
                current = next;
                continue;
            }
            if (current.containsKey(pathPart)) {
                throw new ParseException(new ParseError(new ParseErrorLocation(context), "Property already defined: " + path.toString()));
            }
            current.put((String)pathPart, (Object)value);
        }
    }

    private FieldsAndIncludes parseIncludes(PdlParser.FieldIncludesContext includeSet) throws ParseException {
        ArrayList<NamedDataSchema> includes = new ArrayList<NamedDataSchema>();
        HashSet<NamedDataSchema> includesDeclaredInline = new HashSet<NamedDataSchema>();
        ArrayList<RecordDataSchema.Field> fields = new ArrayList<RecordDataSchema.Field>();
        if (includeSet != null) {
            List<PdlParser.TypeAssignmentContext> includeTypes = includeSet.typeAssignment();
            for (PdlParser.TypeAssignmentContext includeRef : includeTypes) {
                DataSchema includedSchema = this.toDataSchema(includeRef);
                if (includedSchema != null) {
                    DataSchema dereferencedIncludedSchema = includedSchema.getDereferencedDataSchema();
                    if (includedSchema instanceof NamedDataSchema && dereferencedIncludedSchema instanceof RecordDataSchema) {
                        NamedDataSchema includedNamedSchema = (NamedDataSchema)includedSchema;
                        RecordDataSchema dereferencedIncludedRecordSchema = (RecordDataSchema)dereferencedIncludedSchema;
                        fields.addAll(dereferencedIncludedRecordSchema.getFields());
                        includes.add(includedNamedSchema);
                        if (!this.isDeclaredInline(includeRef)) continue;
                        includesDeclaredInline.add(includedNamedSchema);
                        continue;
                    }
                    this.startErrorMessage(includeRef).append("Include is not a record type or a typeref to a record type: ").append((Object)includeRef).append(NEWLINE);
                    continue;
                }
                this.startErrorMessage(includeRef).append("Unable to resolve included schema: ").append((Object)includeRef).append(NEWLINE);
            }
        }
        return new FieldsAndIncludes(fields, includes, includesDeclaredInline);
    }

    private List<RecordDataSchema.Field> parseFields(RecordDataSchema recordSchema, PdlParser.FieldSelectionContext fieldGroup) throws ParseException {
        ArrayList<RecordDataSchema.Field> results = new ArrayList<RecordDataSchema.Field>();
        for (PdlParser.FieldDeclarationContext field : fieldGroup.fields) {
            if (field != null) {
                PdlParser.JsonValueContext defaultValue;
                if (field.type == null) {
                    throw new IllegalStateException("type is missing for field: " + field.getText());
                }
                RecordDataSchema.Field result = new RecordDataSchema.Field(this.toDataSchema(field.type));
                HashMap<String, Object> properties = new HashMap<String, Object>();
                result.setName(field.name, this.errorMessageBuilder());
                result.setOptional(field.isOptional);
                PdlParser.FieldDefaultContext fieldDefault = field.fieldDefault();
                if (fieldDefault != null && (defaultValue = fieldDefault.jsonValue()) != null) {
                    result.setDefault(this.parseJsonValue(defaultValue));
                }
                for (PdlParser.PropDeclarationContext prop : field.props) {
                    this.addPropertiesAtPath(properties, prop);
                }
                if (field.doc != null) {
                    result.setDoc(field.doc.value);
                }
                result.setProperties(properties);
                result.setRecord(recordSchema);
                result.setDeclaredInline(this.isDeclaredInline(field.type));
                results.add(result);
                continue;
            }
            this.startErrorMessage(field).append("Unrecognized field element parse node: ").append(field.getText()).append(NEWLINE);
        }
        return results;
    }

    private boolean isDeclaredInline(PdlParser.TypeAssignmentContext assignment) {
        return assignment.typeReference() == null;
    }

    private DataSchema toDataSchema(PdlParser.TypeReferenceContext typeReference) throws ParseException {
        DataSchema dataSchema = this.stringToDataSchema(typeReference.value);
        if (dataSchema != null) {
            return dataSchema;
        }
        this.startErrorMessage(typeReference).append("Type not found: ").append(typeReference.value).append(NEWLINE);
        return null;
    }

    @Override
    public DataSchema lookupName(String fullName) {
        DataSchema schema = DataSchemaUtil.typeStringToPrimitiveDataSchema(fullName);
        if (schema == null) {
            schema = this.getResolver().findDataSchema(fullName, this.errorMessageBuilder());
        }
        return schema;
    }

    private DataSchema toDataSchema(PdlParser.TypeAssignmentContext typeAssignment) throws ParseException {
        PdlParser.TypeReferenceContext typeReference = typeAssignment.typeReference();
        if (typeReference != null) {
            return this.toDataSchema(typeReference);
        }
        if (typeAssignment.typeDeclaration() != null) {
            return this.parseType(typeAssignment.typeDeclaration());
        }
        throw new ParseException(typeAssignment, "Unrecognized type assignment parse node: " + typeAssignment.getText() + NEWLINE);
    }

    private Name toName(String name) {
        if (name.contains(".")) {
            return new Name(name, this.errorMessageBuilder());
        }
        return new Name(name, this.getCurrentNamespace(), this.errorMessageBuilder());
    }

    private Object parsePropValue(PdlParser.PropDeclarationContext prop) throws ParseException {
        if (prop.propJsonValue() != null) {
            return this.parseJsonValue(prop.propJsonValue().jsonValue());
        }
        return Boolean.TRUE;
    }

    private Object parseJsonValue(PdlParser.JsonValueContext jsonValue) throws ParseException {
        if (jsonValue.array() != null) {
            DataList dataList = new DataList();
            for (PdlParser.JsonValueContext item : jsonValue.array().jsonValue()) {
                dataList.add(this.parseJsonValue(item));
            }
            return dataList;
        }
        if (jsonValue.object() != null) {
            DataMap dataMap = new DataMap();
            for (PdlParser.ObjectEntryContext entry : jsonValue.object().objectEntry()) {
                dataMap.put(entry.key.value, this.parseJsonValue(entry.value));
            }
            return dataMap;
        }
        if (jsonValue.string() != null) {
            return jsonValue.string().value;
        }
        if (jsonValue.number() != null) {
            Number numberValue = jsonValue.number().value;
            if (numberValue == null) {
                this.startErrorMessage(jsonValue).append("'").append(jsonValue.number().getText()).append("' is not a valid int, long, float or double.").append(NEWLINE);
                return 0;
            }
            return numberValue;
        }
        if (jsonValue.bool() != null) {
            return jsonValue.bool().value;
        }
        if (jsonValue.nullValue() != null) {
            return Null.getInstance();
        }
        this.startErrorMessage(jsonValue).append("Unrecognized JSON parse node: ").append(jsonValue.getText()).append(NEWLINE);
        return Null.getInstance();
    }

    @Override
    public String computeFullName(String name) {
        String fullname = DataSchemaUtil.typeStringToPrimitiveDataSchema(name) != null ? name : (Name.isFullName(name) ? name : (this.currentImports.containsKey(name) ? this.currentImports.get(name).getFullName() : (this.getCurrentNamespace().isEmpty() ? name : this.getCurrentNamespace() + "." + name)));
        return fullname;
    }

    private void setCurrentImports(PdlParser.ImportDeclarationsContext imports) {
        HashMap<String, Name> importsBySimpleName = new HashMap<String, Name>();
        for (PdlParser.ImportDeclarationContext importDecl : imports.importDeclaration()) {
            String importedFullname = importDecl.type.value;
            Name importedName = new Name(importedFullname);
            String importedSimpleName = importedName.getName();
            if (importsBySimpleName.containsKey(importedSimpleName)) {
                this.startErrorMessage(importDecl).append("'").append(importsBySimpleName.get(importedSimpleName)).append("' is already defined in an import.").append(NEWLINE);
            }
            importsBySimpleName.put(importedSimpleName, importedName);
        }
        this.currentImports = importsBySimpleName;
    }

    @Override
    public String schemasToString() {
        return SchemaToJsonEncoder.schemasToJson(this.topLevelDataSchemas(), JsonBuilder.Pretty.SPACES);
    }

    @Override
    public StringBuilder errorMessageBuilder() {
        return this._errorMessageBuilder;
    }

    private static class FieldsAndIncludes {
        public final List<RecordDataSchema.Field> fields;
        public final List<NamedDataSchema> includes;
        public final Set<NamedDataSchema> includesDeclaredInline;

        public FieldsAndIncludes(List<RecordDataSchema.Field> fields, List<NamedDataSchema> includes, Set<NamedDataSchema> includesDeclaredInline) {
            this.fields = fields;
            this.includes = includes;
            this.includesDeclaredInline = includesDeclaredInline;
        }
    }

    private class ErrorRecorder
    extends BaseErrorListener {
        public final List<ParseError> errors = new LinkedList<ParseError>();

        private ErrorRecorder() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int column, String msg, RecognitionException e) {
            ParseErrorLocation location = new ParseErrorLocation(line, column);
            this.errors.add(new ParseError(location, msg));
        }
    }

    private class ParseException
    extends IOException {
        private static final long serialVersionUID = 1L;
        public final ParseError error;

        public ParseException(ParserRuleContext context, String msg) {
            this(pdlSchemaParser.new ParseError(pdlSchemaParser.new ParseErrorLocation(context), msg));
        }

        public ParseException(ParseError error) {
            super(error.message);
            this.error = error;
        }
    }

    private class ParseErrorLocation
    implements DataLocation {
        public final int line;
        public final int column;

        public ParseErrorLocation(ParserRuleContext context) {
            Token start = context.getStart();
            this.line = start.getLine();
            this.column = start.getCharPositionInLine();
        }

        public ParseErrorLocation(int line, int column) {
            this.line = line;
            this.column = column;
        }

        @Override
        public int compareTo(DataLocation location) {
            if (!(location instanceof ParseErrorLocation)) {
                return -1;
            }
            ParseErrorLocation other = (ParseErrorLocation)location;
            int lineCompare = this.line - other.line;
            if (lineCompare != 0) {
                return lineCompare;
            }
            return this.column - other.column;
        }

        public String toString() {
            return this.line + "," + this.column;
        }
    }

    private class ParseError {
        public final ParseErrorLocation location;
        public final String message;

        public ParseError(ParseErrorLocation location, String message) {
            this.location = location;
            this.message = message;
        }
    }
}

